/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.ai.edited;

import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.server.ai.edited.AITargetEdit;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.datastructures.ExplicitPriorityQueue;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIDefendVillage;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.village.Village;

public class AIDefendVillageEdit
extends AITargetEdit {
    private static Field villageReputationsField = ReflectionTool.getField(Village.class, (String[])new String[]{"field_82693_j", "playerReputation"});
    EntityIronGolem irongolem;
    EntityLivingBase villageAgressorTarget;

    public AIDefendVillageEdit(EntityAIDefendVillage oldAI) {
        super((EntityAITarget)oldAI);
        this.irongolem = (EntityIronGolem)this.attacker;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        Village village = this.irongolem.func_70852_n();
        if (village == null) {
            return false;
        }
        this.villageAgressorTarget = village.func_75571_b((EntityLivingBase)this.irongolem);
        if (this.villageAgressorTarget instanceof EntityCreeper) {
            return false;
        }
        if (this.isSuitableTarget(this.villageAgressorTarget)) {
            return true;
        }
        if (this.attacker.func_70681_au().nextInt(20) == 0) {
            try {
                Map map = (Map)villageReputationsField.get(village);
                ExplicitPriorityQueue queue = new ExplicitPriorityQueue(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    UUID uuid = (UUID)entry.getKey();
                    if (!village.isPlayerReputationTooLow(uuid)) continue;
                    EntityPlayer player = this.irongolem.field_70170_p.func_152378_a(uuid);
                    queue.add((Object)player, player.func_70068_e((Entity)this.irongolem));
                }
                if (queue.isEmpty()) {
                    return false;
                }
                this.villageAgressorTarget = (EntityLivingBase)queue.poll();
                while (this.villageAgressorTarget != null && !this.isSuitableTarget(this.villageAgressorTarget)) {
                    this.villageAgressorTarget = (EntityLivingBase)queue.poll();
                }
            }
            catch (IllegalAccessException e) {
                MCTools.crash((Exception)e, (int)136, (boolean)false);
            }
            return this.villageAgressorTarget != null;
        }
        return false;
    }

    public void func_75249_e() {
        if (this.villageAgressorTarget == null) {
            Compat.clearAttackTargetAndCancelBadTasks((EntityLiving)this.irongolem);
        } else {
            this.irongolem.func_70624_b(this.villageAgressorTarget);
        }
        super.func_75249_e();
    }
}

