/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.ai.edited;

import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.mctools.MCTools;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public abstract class AITargetEdit
extends EntityAIBase {
    public final EntityCreature attacker;
    public final boolean nearbyOnly;
    public EntityLivingBase target;

    public AITargetEdit(EntityAITarget oldAI) {
        this.attacker = oldAI.field_75299_d;
        this.nearbyOnly = oldAI.field_75303_a;
    }

    public static boolean isSuitableTarget(EntityLiving attacker, @Nullable EntityLivingBase target) {
        Entity attackerOwner;
        if (target == null || target == attacker || !target.func_70089_S() || !attacker.func_70686_a(target.getClass()) || attacker.func_184191_r((Entity)target)) {
            return false;
        }
        if (EntityThreatData.isPassive((EntityLivingBase)attacker)) {
            return false;
        }
        if (attacker.func_184191_r((Entity)target)) {
            return false;
        }
        if (attacker instanceof IEntityOwnable && (attackerOwner = ((IEntityOwnable)attacker).func_70902_q()) != null) {
            if (target == attackerOwner) {
                return false;
            }
            if (target instanceof IEntityOwnable && attackerOwner == ((IEntityOwnable)target).func_70902_q()) {
                return false;
            }
        }
        if (target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75102_a) {
            return false;
        }
        return Sight.canSee((EntityLivingBase)attacker, (Entity)target, true);
    }

    protected boolean isSuitableTarget(@Nullable EntityLivingBase target) {
        if (target instanceof EntityPlayerMP && ((EntityPlayerMP)target).field_71075_bZ.field_75102_a) {
            return false;
        }
        if (target == null || this.nearbyOnly && !this.canEasilyReach(target)) {
            return false;
        }
        return AITargetEdit.isSuitableTarget((EntityLiving)this.attacker, target) && this.attacker.func_180485_d(new BlockPos((Entity)target));
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target == null) {
            target = this.target;
        }
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        Team attackerTeam = this.attacker.func_96124_cp();
        Team targetTeam = target.func_96124_cp();
        if (attackerTeam != null && targetTeam == attackerTeam) {
            return false;
        }
        if (target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75102_a) {
            return false;
        }
        if (!Sight.canSee((EntityLivingBase)this.attacker, (Entity)target, true)) {
            return false;
        }
        this.attacker.func_70624_b(target);
        return true;
    }

    protected double getFollowDistance() {
        return MCTools.getAttribute((EntityLivingBase)this.attacker, (IAttribute)SharedMonsterAttributes.field_111265_b, (double)0.0);
    }

    public void func_75251_c() {
        Compat.clearAttackTargetAndCancelBadTasks((EntityLiving)this.attacker);
        this.target = null;
    }

    private boolean canEasilyReach(EntityLivingBase target) {
        int j;
        Path path = this.attacker.func_70661_as().func_75494_a((Entity)target);
        if (path == null) {
            return false;
        }
        PathPoint pathpoint = path.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76128_c((double)target.field_70165_t);
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76128_c((double)target.field_70161_v)) * j) <= 2.25;
    }
}

