/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.ai.edited;

import com.fantasticsource.dynamicstealth.server.ai.EntityAIData;
import com.fantasticsource.tools.ReflectionTool;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class AIWanderEdit
extends EntityAIWander {
    protected static final Field ENTITY_AI_WANDER_EXECUTION_CHANCE_FIELD = ReflectionTool.getField(EntityAIWander.class, (String[])new String[]{"field_179481_f", "executionChance"});
    protected static final Method PATH_NAVIGATE_IS_DIRECT_PATH_BETWEEN_POINTS_METHOD = ReflectionTool.getMethod(PathNavigate.class, (String[])new String[]{"func_75493_a", "isDirectPathBetweenPoints"});
    protected final EntityCreature field_75457_a;
    public double field_75454_e;
    protected int field_179481_f;
    protected boolean field_179482_g;
    protected Path path;
    protected boolean looked;
    protected int lookIndex = -1;
    protected Vec3d lookVec = null;
    protected float prevYaw;

    public AIWanderEdit(EntityCreature entity, EntityAIWander oldAI) {
        super(entity, 1.0);
        this.func_75248_a(3);
        this.field_75457_a = entity;
        this.field_75454_e = oldAI.field_75454_e;
        try {
            this.field_179481_f = (Integer)ENTITY_AI_WANDER_EXECUTION_CHANCE_FIELD.get(oldAI);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (entity instanceof EntityElderGuardian) {
            this.field_179481_f = 400;
        }
    }

    public boolean func_75250_a() {
        if (this.field_75457_a.func_70638_az() != null) {
            return false;
        }
        if (!(this.field_179482_g || this.field_75457_a.func_70654_ax() < 100 && this.field_75457_a.func_70681_au().nextInt(this.field_179481_f) == 0)) {
            return false;
        }
        Vec3d vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.field_75457_a, (int)10, (int)7);
        if (vec3d == null) {
            return false;
        }
        this.field_179482_g = false;
        this.path = this.field_75457_a.func_70661_as().func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        this.lookIndex = -1;
        this.lookVec = null;
        this.looked = false;
        this.prevYaw = Float.MAX_VALUE;
        this.updateLookVec();
        return this.lookVec != null;
    }

    public boolean func_75253_b() {
        if (this.field_75457_a.func_70638_az() != null) {
            return false;
        }
        return !this.looked || !this.field_75457_a.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.field_75457_a.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        this.updateLookVec();
        this.field_75457_a.func_70671_ap().func_75650_a(this.lookVec.field_72450_a, this.lookVec.field_72448_b, this.lookVec.field_72449_c, (float)EntityAIData.headTurnSpeed((EntityLivingBase)this.field_75457_a), (float)EntityAIData.headTurnSpeed((EntityLivingBase)this.field_75457_a));
        if (!this.looked) {
            if (this.field_75457_a.func_70079_am() == this.prevYaw) {
                this.looked = true;
                this.field_75457_a.func_70661_as().func_75484_a(this.path, this.field_75454_e);
            } else {
                this.prevYaw = this.field_75457_a.func_70079_am();
            }
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.path = null;
        this.lookIndex = -1;
        this.lookVec = null;
        this.looked = false;
        this.prevYaw = Float.MAX_VALUE;
    }

    protected void updateLookVec() {
        if (this.path != null) {
            int pathLength = this.path.func_75874_d();
            if (!this.looked) {
                for (int i = pathLength - 1; i >= 0; --i) {
                    Vec3d vec = this.path.func_75881_a((Entity)this.field_75457_a, i);
                    if (!this.isDirect(vec)) continue;
                    this.lookIndex = i;
                    this.lookVec = vec;
                    break;
                }
                if (this.lookVec == null) {
                    this.lookIndex = 0;
                    this.lookVec = this.path.func_75881_a((Entity)this.field_75457_a, 0);
                }
            } else {
                this.lookIndex = this.path.func_75873_e();
                if (this.lookIndex + 1 < pathLength) {
                    ++this.lookIndex;
                }
                if (this.lookIndex + 1 < pathLength) {
                    ++this.lookIndex;
                }
                this.lookVec = this.path.func_75881_a((Entity)this.field_75457_a, this.lookIndex);
            }
            while (this.lookVec.func_72436_e(this.field_75457_a.func_174791_d()) < 1.0 && this.lookIndex + 1 < pathLength) {
                this.lookVec = this.path.func_75881_a((Entity)this.field_75457_a, ++this.lookIndex);
            }
        }
    }

    protected boolean isDirect(Vec3d vec) {
        int w = MathHelper.func_76123_f((float)this.field_75457_a.field_70130_N);
        int h = MathHelper.func_76123_f((float)this.field_75457_a.field_70131_O);
        try {
            return (Boolean)PATH_NAVIGATE_IS_DIRECT_PATH_BETWEEN_POINTS_METHOD.invoke((Object)this.field_75457_a.func_70661_as(), this.field_75457_a.func_174791_d(), vec, w, h, w);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }
}

