/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.entitytracker;

import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntity;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import net.minecraft.network.play.server.SPacketEntityHeadLook;
import net.minecraft.network.play.server.SPacketEntityMetadata;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.network.play.server.SPacketSpawnMob;
import net.minecraft.network.play.server.SPacketSpawnObject;
import net.minecraft.network.play.server.SPacketSpawnPlayer;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LivingBaseEntityTrackerEntry
extends EntityTrackerEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Set<EntityPlayerMP> field_73134_o = Sets.newHashSet();
    private final EntityLivingBase livingBase;
    private final boolean isPlayer;
    private final EntityPlayerMP player;
    private final int updateFrequency;
    private final boolean sendVelocityUpdates;
    public int field_73136_m;
    private int ticksSinceLastForcedTeleport;
    private boolean onGround;
    private boolean ridingEntity;
    private boolean updatedPlayerVisibility;
    private long encodedPosX;
    private long encodedPosY;
    private long encodedPosZ;
    private int encodedRotationYaw;
    private int encodedRotationPitch;
    private int lastHeadMotion;
    private double lastMotionX;
    private double lastMotionY;
    private double lastMotionZ;
    private double lastX;
    private double lastY;
    private double lastZ;
    private List<Entity> passengers = Collections.emptyList();

    public LivingBaseEntityTrackerEntry(Entity entity, int maxRange, int currentRange, int updateFrequency, boolean sendVelocityUpdates) {
        super(entity, maxRange, currentRange, updateFrequency, sendVelocityUpdates);
        this.livingBase = (EntityLivingBase)entity;
        this.isPlayer = this.livingBase instanceof EntityPlayerMP;
        this.player = this.isPlayer ? (EntityPlayerMP)this.livingBase : null;
        this.updateFrequency = updateFrequency;
        this.sendVelocityUpdates = sendVelocityUpdates;
        this.onGround = entity.field_70122_E;
        this.encodedPosX = EntityTracker.func_187253_a((double)entity.field_70165_t);
        this.encodedPosY = EntityTracker.func_187253_a((double)entity.field_70163_u);
        this.encodedPosZ = EntityTracker.func_187253_a((double)entity.field_70161_v);
        this.encodedRotationYaw = MathHelper.func_76141_d((float)(entity.field_70177_z * 256.0f / 360.0f));
        this.encodedRotationPitch = MathHelper.func_76141_d((float)(entity.field_70125_A * 256.0f / 360.0f));
        this.lastHeadMotion = MathHelper.func_76141_d((float)(entity.func_70079_am() * 256.0f / 360.0f));
    }

    public boolean equals(Object entityTrackerEntry) {
        return entityTrackerEntry instanceof LivingBaseEntityTrackerEntry && ((LivingBaseEntityTrackerEntry)((Object)entityTrackerEntry)).livingBase.func_145782_y() == this.livingBase.func_145782_y();
    }

    public int hashCode() {
        return this.livingBase.func_145782_y();
    }

    public void func_73122_a(List<EntityPlayer> players) {
        List list;
        if (!this.updatedPlayerVisibility || this.livingBase.func_70092_e(this.lastX, this.lastY, this.lastZ) > 16.0) {
            this.lastX = this.livingBase.field_70165_t;
            this.lastY = this.livingBase.field_70163_u;
            this.lastZ = this.livingBase.field_70161_v;
            this.updatedPlayerVisibility = true;
        }
        if (!(list = this.livingBase.func_184188_bt()).equals(this.passengers)) {
            this.passengers = list;
            this.func_151259_a((Packet<?>)new SPacketSetPassengers((Entity)this.livingBase));
        }
        if (this.field_73136_m % this.updateFrequency == 0 || this.livingBase.field_70160_al || this.livingBase.func_184212_Q().func_187223_a()) {
            if (this.livingBase.func_184218_aH()) {
                boolean flag3;
                int j1 = MathHelper.func_76141_d((float)(this.livingBase.field_70177_z * 256.0f / 360.0f));
                int l1 = MathHelper.func_76141_d((float)(this.livingBase.field_70125_A * 256.0f / 360.0f));
                boolean bl = flag3 = Math.abs(j1 - this.encodedRotationYaw) >= 1 || Math.abs(l1 - this.encodedRotationPitch) >= 1;
                if (flag3) {
                    this.func_151259_a((Packet<?>)new SPacketEntity.S16PacketEntityLook(this.livingBase.func_145782_y(), (byte)j1, (byte)l1, this.livingBase.field_70122_E));
                    this.encodedRotationYaw = j1;
                    this.encodedRotationPitch = l1;
                }
                this.encodedPosX = EntityTracker.func_187253_a((double)this.livingBase.field_70165_t);
                this.encodedPosY = EntityTracker.func_187253_a((double)this.livingBase.field_70163_u);
                this.encodedPosZ = EntityTracker.func_187253_a((double)this.livingBase.field_70161_v);
                this.sendMetadata();
                this.ridingEntity = true;
            } else {
                boolean flag1;
                ++this.ticksSinceLastForcedTeleport;
                long i1 = EntityTracker.func_187253_a((double)this.livingBase.field_70165_t);
                long i2 = EntityTracker.func_187253_a((double)this.livingBase.field_70163_u);
                long j2 = EntityTracker.func_187253_a((double)this.livingBase.field_70161_v);
                int k2 = MathHelper.func_76141_d((float)(this.livingBase.field_70177_z * 256.0f / 360.0f));
                int i = MathHelper.func_76141_d((float)(this.livingBase.field_70125_A * 256.0f / 360.0f));
                long j = i1 - this.encodedPosX;
                long k = i2 - this.encodedPosY;
                long l = j2 - this.encodedPosZ;
                SPacketEntityTeleport packet1 = null;
                boolean flag = j * j + k * k + l * l >= 128L || this.field_73136_m % 60 == 0;
                boolean bl = flag1 = Math.abs(k2 - this.encodedRotationYaw) >= 1 || Math.abs(i - this.encodedRotationPitch) >= 1;
                if (this.field_73136_m > 0) {
                    if (j >= -32768L && j < 32768L && k >= -32768L && k < 32768L && l >= -32768L && l < 32768L && this.ticksSinceLastForcedTeleport <= 400 && !this.ridingEntity && this.onGround == this.livingBase.field_70122_E) {
                        if (!flag || !flag1) {
                            if (flag) {
                                packet1 = new SPacketEntity.S15PacketEntityRelMove(this.livingBase.func_145782_y(), j, k, l, this.livingBase.field_70122_E);
                            } else if (flag1) {
                                packet1 = new SPacketEntity.S16PacketEntityLook(this.livingBase.func_145782_y(), (byte)k2, (byte)i, this.livingBase.field_70122_E);
                            }
                        } else {
                            packet1 = new SPacketEntity.S17PacketEntityLookMove(this.livingBase.func_145782_y(), j, k, l, (byte)k2, (byte)i, this.livingBase.field_70122_E);
                        }
                    } else {
                        this.onGround = this.livingBase.field_70122_E;
                        this.ticksSinceLastForcedTeleport = 0;
                        this.func_187261_c();
                        packet1 = new SPacketEntityTeleport((Entity)this.livingBase);
                    }
                }
                if (this.field_73136_m > 0 && (this.sendVelocityUpdates || this.livingBase.func_184613_cA()) && (this.lastMotionX != this.livingBase.field_70159_w || this.lastMotionY != this.livingBase.field_70181_x || this.lastMotionZ != this.livingBase.field_70179_y)) {
                    this.lastMotionX = this.livingBase.field_70159_w;
                    this.lastMotionY = this.livingBase.field_70181_x;
                    this.lastMotionZ = this.livingBase.field_70179_y;
                    this.func_151259_a((Packet<?>)new SPacketEntityVelocity(this.livingBase.func_145782_y(), this.livingBase.field_70159_w, this.livingBase.field_70181_x, this.livingBase.field_70179_y));
                }
                if (packet1 != null) {
                    this.func_151259_a((Packet<?>)packet1);
                }
                this.sendMetadata();
                if (flag) {
                    this.encodedPosX = i1;
                    this.encodedPosY = i2;
                    this.encodedPosZ = j2;
                }
                if (flag1) {
                    this.encodedRotationYaw = k2;
                    this.encodedRotationPitch = i;
                }
                this.ridingEntity = false;
            }
            int k1 = MathHelper.func_76141_d((float)(this.livingBase.func_70079_am() * 256.0f / 360.0f));
            if (Math.abs(k1 - this.lastHeadMotion) >= 1) {
                this.func_151259_a((Packet<?>)new SPacketEntityHeadLook((Entity)this.livingBase, (byte)k1));
                this.lastHeadMotion = k1;
            }
            this.livingBase.field_70160_al = false;
        }
        ++this.field_73136_m;
        if (this.livingBase.field_70133_I) {
            this.func_151261_b((Packet<?>)new SPacketEntityVelocity((Entity)this.livingBase));
            this.livingBase.field_70133_I = false;
        }
    }

    private void sendMetadata() {
        AttributeMap attributemap;
        Set set;
        EntityDataManager entitydatamanager = this.livingBase.func_184212_Q();
        if (entitydatamanager.func_187223_a()) {
            this.func_151261_b((Packet<?>)new SPacketEntityMetadata(this.livingBase.func_145782_y(), entitydatamanager, false));
        }
        if (!(set = (attributemap = (AttributeMap)this.livingBase.func_110140_aT()).func_111161_b()).isEmpty()) {
            this.func_151261_b((Packet<?>)new SPacketEntityProperties(this.livingBase.func_145782_y(), (Collection)set));
        }
        set.clear();
    }

    public void func_151259_a(Packet<?> packetIn) {
        for (EntityPlayerMP entityplayermp : this.field_73134_o) {
            entityplayermp.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_151261_b(Packet<?> packetIn) {
        this.func_151259_a(packetIn);
        if (this.isPlayer) {
            this.player.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_73119_a() {
        for (EntityPlayerMP entityplayermp : this.field_73134_o) {
            this.livingBase.func_184203_c(entityplayermp);
            entityplayermp.func_152339_d((Entity)this.livingBase);
        }
    }

    public void func_73118_a(EntityPlayerMP playerMP) {
        if (this.field_73134_o.contains(playerMP)) {
            this.livingBase.func_184203_c(playerMP);
            playerMP.func_152339_d((Entity)this.livingBase);
            this.field_73134_o.remove(playerMP);
        }
    }

    public void func_73117_b(EntityPlayerMP player) {
        if (player != this.livingBase) {
            if (this.func_180233_c(player)) {
                if (!this.field_73134_o.contains(player)) {
                    AttributeMap attributemap;
                    Collection collection;
                    this.field_73134_o.add(player);
                    Packet<?> packet = this.createSpawnPacket();
                    player.field_71135_a.func_147359_a(packet);
                    if (!this.livingBase.func_184212_Q().func_187228_d()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityMetadata(this.livingBase.func_145782_y(), this.livingBase.func_184212_Q(), true));
                    }
                    if (!(collection = (attributemap = (AttributeMap)this.livingBase.func_110140_aT()).func_111160_c()).isEmpty()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(this.livingBase.func_145782_y(), collection));
                    }
                    this.lastMotionX = this.livingBase.field_70159_w;
                    this.lastMotionY = this.livingBase.field_70181_x;
                    this.lastMotionZ = this.livingBase.field_70179_y;
                    if (!(packet instanceof SPacketSpawnMob) && (this.sendVelocityUpdates || this.livingBase.func_184613_cA())) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(this.livingBase.func_145782_y(), this.livingBase.field_70159_w, this.livingBase.field_70181_x, this.livingBase.field_70179_y));
                    }
                    for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                        ItemStack itemstack = this.livingBase.func_184582_a(entityequipmentslot);
                        if (itemstack.func_190926_b()) continue;
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityEquipment(this.livingBase.func_145782_y(), entityequipmentslot, itemstack));
                    }
                    if (this.isPlayer && this.player.func_70608_bn()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketUseBed((EntityPlayer)this.player, new BlockPos((Entity)this.livingBase)));
                    }
                    for (PotionEffect potioneffect : this.livingBase.func_70651_bq()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(this.livingBase.func_145782_y(), potioneffect));
                    }
                    if (!this.livingBase.func_184188_bt().isEmpty()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketSetPassengers((Entity)this.livingBase));
                    }
                    if (this.livingBase.func_184218_aH()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(this.livingBase.func_184187_bx()));
                    }
                    this.livingBase.func_184178_b(player);
                    player.func_184848_d((Entity)this.livingBase);
                    ForgeEventFactory.onStartEntityTracking((Entity)this.livingBase, (EntityPlayer)player);
                }
            } else if (this.field_73134_o.contains(player)) {
                this.field_73134_o.remove(player);
                this.livingBase.func_184203_c(player);
                player.func_152339_d((Entity)this.livingBase);
                ForgeEventFactory.onStopEntityTracking((Entity)this.livingBase, (EntityPlayer)player);
            }
        }
    }

    public boolean func_180233_c(EntityPlayerMP playerMP) {
        return Sight.canSee((EntityLivingBase)playerMP, (Entity)this.livingBase, true);
    }

    public void func_73125_b(List<EntityPlayer> players) {
        for (EntityPlayer player : players) {
            this.func_73117_b((EntityPlayerMP)player);
        }
    }

    private Packet<?> createSpawnPacket() {
        Packet pkt;
        if (this.livingBase.field_70128_L) {
            LOGGER.warn("Fetching addPacket for removed entity");
        }
        if ((pkt = FMLNetworkHandler.getEntitySpawningPacket((Entity)this.livingBase)) != null) {
            return pkt;
        }
        if (this.isPlayer) {
            return new SPacketSpawnPlayer((EntityPlayer)this.player);
        }
        if (this.livingBase instanceof EntityArmorStand) {
            return new SPacketSpawnObject((Entity)this.livingBase, 78);
        }
        if (this.livingBase instanceof IAnimals) {
            this.lastHeadMotion = MathHelper.func_76141_d((float)(this.livingBase.func_70079_am() * 256.0f / 360.0f));
            return new SPacketSpawnMob(this.livingBase);
        }
        throw new IllegalArgumentException("Don't know how to send packet for " + this.livingBase.getClass() + "!");
    }

    public void func_73123_c(EntityPlayerMP playerMP) {
        if (this.field_73134_o.contains(playerMP)) {
            this.field_73134_o.remove(playerMP);
            this.livingBase.func_184203_c(playerMP);
            playerMP.func_152339_d((Entity)this.livingBase);
        }
    }

    public Entity func_187260_b() {
        return this.livingBase;
    }

    public void func_187259_a(int maxRangeIn) {
    }

    public void func_187261_c() {
        this.updatedPlayerVisibility = false;
    }
}

