/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.event.attacks;

import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.AssassinationConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.NormalAttackBlockedConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.NormalAttackConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.RangedAssassinationConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.RangedAttackConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.RangedStealthAttackConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.StealthAttackBlockedConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.StealthAttackConfig;
import com.fantasticsource.dynamicstealth.server.event.attacks.WeaponEntry;
import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import com.fantasticsource.mctools.potions.Potions;
import com.fantasticsource.tools.ReflectionTool;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;

public class AttackData {
    protected static final Method ENTITY_LIVING_BASE_CAN_BLOCK_DAMAGE_SOURCE_METHOD = ReflectionTool.getMethod(EntityLivingBase.class, (String[])new String[]{"func_184583_d", "canBlockDamageSource"});
    public static ArrayList<FantasticPotionEffect> normalAttackerEffects;
    public static ArrayList<FantasticPotionEffect> normalVictimEffects;
    public static ArrayList<WeaponEntry> normalWeaponSpecific;
    public static ArrayList<FantasticPotionEffect> rangedAttackerEffects;
    public static ArrayList<FantasticPotionEffect> rangedVictimEffects;
    public static ArrayList<FantasticPotionEffect> stealthAttackerEffects;
    public static ArrayList<FantasticPotionEffect> stealthVictimEffects;
    public static ArrayList<WeaponEntry> stealthWeaponSpecific;
    public static ArrayList<FantasticPotionEffect> rangedStealthAttackerEffects;
    public static ArrayList<FantasticPotionEffect> rangedStealthVictimEffects;
    public static ArrayList<FantasticPotionEffect> normalBlockedAttackerEffects;
    public static ArrayList<FantasticPotionEffect> normalBlockedVictimEffects;
    public static ArrayList<WeaponEntry> normalBlockedWeaponSpecific;
    public static ArrayList<FantasticPotionEffect> rangedBlockedAttackerEffects;
    public static ArrayList<FantasticPotionEffect> rangedBlockedVictimEffects;
    public static ArrayList<FantasticPotionEffect> stealthBlockedAttackerEffects;
    public static ArrayList<FantasticPotionEffect> stealthBlockedVictimEffects;
    public static ArrayList<WeaponEntry> stealthBlockedWeaponSpecific;
    public static ArrayList<FantasticPotionEffect> rangedStealthBlockedAttackerEffects;
    public static ArrayList<FantasticPotionEffect> rangedStealthBlockedVictimEffects;
    public static ArrayList<FantasticPotionEffect> assassinationAttackerEffects;
    public static ArrayList<WeaponEntry> assassinationWeaponSpecific;
    public static ArrayList<FantasticPotionEffect> rangedAssassinationAttackerEffects;

    public static void update() {
        NormalAttackConfig normalConfig = DynamicStealthConfig.serverSettings.interactions.attack;
        normalAttackerEffects = Potions.parsePotions((String[])normalConfig.attackerEffects);
        normalVictimEffects = Potions.parsePotions((String[])normalConfig.victimEffects);
        normalWeaponSpecific = new ArrayList();
        for (String string : normalConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.getInstance(string, 0, false);
            if (entry == null) continue;
            normalWeaponSpecific.add(entry);
        }
        NormalAttackBlockedConfig normalBlockedConfig = DynamicStealthConfig.serverSettings.interactions.attackBlocked;
        normalBlockedAttackerEffects = Potions.parsePotions((String[])normalBlockedConfig.attackerEffects);
        normalBlockedVictimEffects = Potions.parsePotions((String[])normalBlockedConfig.victimEffects);
        normalBlockedWeaponSpecific = new ArrayList();
        for (String string : normalBlockedConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.getInstance(string, 0, true);
            if (entry == null) continue;
            normalBlockedWeaponSpecific.add(entry);
        }
        RangedAttackConfig rangedConfig = DynamicStealthConfig.serverSettings.interactions.rangedAttack;
        rangedAttackerEffects = Potions.parsePotions((String[])rangedConfig.attackerEffects);
        rangedVictimEffects = Potions.parsePotions((String[])rangedConfig.victimEffects);
        rangedConfig = DynamicStealthConfig.serverSettings.interactions.rangedAttackBlocked;
        rangedBlockedAttackerEffects = Potions.parsePotions((String[])rangedConfig.attackerEffects);
        rangedBlockedVictimEffects = Potions.parsePotions((String[])rangedConfig.victimEffects);
        StealthAttackConfig stealthConfig = DynamicStealthConfig.serverSettings.interactions.stealthAttack;
        stealthAttackerEffects = Potions.parsePotions((String[])stealthConfig.attackerEffects);
        stealthVictimEffects = Potions.parsePotions((String[])stealthConfig.victimEffects);
        stealthWeaponSpecific = new ArrayList();
        for (String string : stealthConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.getInstance(string, 1, false);
            if (entry == null) continue;
            stealthWeaponSpecific.add(entry);
        }
        StealthAttackBlockedConfig stealthBlockedConfig = DynamicStealthConfig.serverSettings.interactions.stealthAttackBlocked;
        stealthBlockedAttackerEffects = Potions.parsePotions((String[])stealthBlockedConfig.attackerEffects);
        stealthBlockedVictimEffects = Potions.parsePotions((String[])stealthBlockedConfig.victimEffects);
        stealthBlockedWeaponSpecific = new ArrayList();
        for (String string : stealthBlockedConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.getInstance(string, 1, true);
            if (entry == null) continue;
            stealthBlockedWeaponSpecific.add(entry);
        }
        RangedStealthAttackConfig rangedStealthConfig = DynamicStealthConfig.serverSettings.interactions.rangedStealthAttack;
        rangedStealthAttackerEffects = Potions.parsePotions((String[])rangedStealthConfig.attackerEffects);
        rangedStealthVictimEffects = Potions.parsePotions((String[])rangedStealthConfig.victimEffects);
        rangedStealthConfig = DynamicStealthConfig.serverSettings.interactions.rangedStealthAttackBlocked;
        rangedStealthBlockedAttackerEffects = Potions.parsePotions((String[])rangedStealthConfig.attackerEffects);
        rangedStealthBlockedVictimEffects = Potions.parsePotions((String[])rangedStealthConfig.victimEffects);
        AssassinationConfig assassinationConfig = DynamicStealthConfig.serverSettings.interactions.assassination;
        assassinationAttackerEffects = Potions.parsePotions((String[])assassinationConfig.attackerEffects);
        assassinationWeaponSpecific = new ArrayList();
        for (String string : assassinationConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.getInstance(string, 2, false);
            if (entry == null) continue;
            assassinationWeaponSpecific.add(entry);
        }
        RangedAssassinationConfig rangedAssassinationConfig = DynamicStealthConfig.serverSettings.interactions.rangedAssassination;
        rangedAssassinationAttackerEffects = Potions.parsePotions((String[])rangedAssassinationConfig.attackerEffects);
    }

    public static boolean isBlocked(EntityLivingBase victim, DamageSource damageSource) {
        return (Boolean)ReflectionTool.invoke((Method)ENTITY_LIVING_BASE_CAN_BLOCK_DAMAGE_SOURCE_METHOD, (Object)victim, (Object[])new Object[]{damageSource});
    }
}

