/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.event.attacks;

import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.event.attacks.AttackData;
import com.fantasticsource.dynamicstealth.server.event.attacks.AttackDefaults;
import com.fantasticsource.mctools.items.ItemFilter;
import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import com.fantasticsource.mctools.potions.Potions;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;

public class WeaponEntry {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_STEALTH = 1;
    public static final int TYPE_ASSASSINATION = 2;
    public boolean armorPenetration = false;
    public double damageMultiplier = 1.0;
    public ArrayList<FantasticPotionEffect> attackerEffects = new ArrayList();
    public ArrayList<FantasticPotionEffect> victimEffects = new ArrayList();
    public boolean consumeItem = false;
    public ItemFilter filter;

    private WeaponEntry(int type, boolean isMelee, boolean isBlocked) {
        if (type == 0) {
            if (isMelee) {
                if (isBlocked) {
                    this.armorPenetration = DynamicStealthConfig.serverSettings.interactions.attackBlocked.armorPenetration;
                    this.damageMultiplier = DynamicStealthConfig.serverSettings.interactions.attackBlocked.damageMultiplier;
                    this.attackerEffects = AttackData.normalBlockedAttackerEffects;
                    this.victimEffects = AttackData.normalBlockedVictimEffects;
                } else {
                    this.armorPenetration = DynamicStealthConfig.serverSettings.interactions.attack.armorPenetration;
                    this.damageMultiplier = DynamicStealthConfig.serverSettings.interactions.attack.damageMultiplier;
                    this.attackerEffects = AttackData.normalAttackerEffects;
                    this.victimEffects = AttackData.normalVictimEffects;
                }
            } else if (isBlocked) {
                this.armorPenetration = DynamicStealthConfig.serverSettings.interactions.rangedAttackBlocked.armorPenetration;
                this.damageMultiplier = DynamicStealthConfig.serverSettings.interactions.rangedAttackBlocked.damageMultiplier;
                this.attackerEffects = AttackData.rangedBlockedAttackerEffects;
                this.victimEffects = AttackData.rangedBlockedVictimEffects;
            } else {
                this.armorPenetration = DynamicStealthConfig.serverSettings.interactions.rangedAttack.armorPenetration;
                this.damageMultiplier = DynamicStealthConfig.serverSettings.interactions.rangedAttack.damageMultiplier;
                this.attackerEffects = AttackData.rangedAttackerEffects;
                this.victimEffects = AttackData.rangedVictimEffects;
            }
        } else if (type == 1) {
            if (isMelee) {
                if (isBlocked) {
                    this.armorPenetration = DynamicStealthConfig.serverSettings.interactions.stealthAttackBlocked.armorPenetration;
                    this.damageMultiplier = DynamicStealthConfig.serverSettings.interactions.stealthAttackBlocked.damageMultiplier;
                    this.attackerEffects = AttackData.stealthBlockedAttackerEffects;
                    this.victimEffects = AttackData.stealthBlockedVictimEffects;
                } else {
                    this.armorPenetration = DynamicStealthConfig.serverSettings.interactions.stealthAttack.armorPenetration;
                    this.damageMultiplier = DynamicStealthConfig.serverSettings.interactions.stealthAttack.damageMultiplier;
                    this.attackerEffects = AttackData.stealthAttackerEffects;
                    this.victimEffects = AttackData.stealthVictimEffects;
                }
            } else if (isBlocked) {
                this.armorPenetration = DynamicStealthConfig.serverSettings.interactions.rangedStealthAttackBlocked.armorPenetration;
                this.damageMultiplier = DynamicStealthConfig.serverSettings.interactions.rangedStealthAttackBlocked.damageMultiplier;
                this.attackerEffects = AttackData.rangedStealthBlockedAttackerEffects;
                this.victimEffects = AttackData.rangedStealthBlockedVictimEffects;
            } else {
                this.armorPenetration = DynamicStealthConfig.serverSettings.interactions.rangedStealthAttack.armorPenetration;
                this.damageMultiplier = DynamicStealthConfig.serverSettings.interactions.rangedStealthAttack.damageMultiplier;
                this.attackerEffects = AttackData.rangedStealthAttackerEffects;
                this.victimEffects = AttackData.rangedStealthVictimEffects;
            }
        } else if (type == 2) {
            this.attackerEffects = isMelee ? AttackData.assassinationAttackerEffects : AttackData.rangedAssassinationAttackerEffects;
        }
    }

    public static WeaponEntry getInstance(String configEntry, int type, boolean isBlocked) {
        WeaponEntry result = new WeaponEntry(type, true, isBlocked);
        String[] tokens = configEntry.split(Pattern.quote(","));
        if (tokens.length < 2) {
            System.err.println("Not enough arguments for weapon entry: " + configEntry);
            return null;
        }
        if ((type == 0 || type == 1) && tokens.length > 6 || type == 2 && tokens.length > 2) {
            System.err.println("Too many arguments for weapon entry: " + configEntry);
            return null;
        }
        String nameAndNBT = tokens[0].trim();
        boolean suppressMissingItemError = false;
        ArrayList<String> list = null;
        if (type == 0) {
            list = isBlocked ? AttackDefaults.normalAttackBlockedDefaults : AttackDefaults.normalAttackDefaults;
        } else if (type == 1) {
            list = isBlocked ? AttackDefaults.stealthAttackBlockedDefaults : AttackDefaults.stealthAttackDefaults;
        } else if (type == 2) {
            list = AttackDefaults.assassinationDefaults;
        }
        for (String entry : list) {
            if (!entry.split(",")[0].trim().equals(nameAndNBT)) continue;
            suppressMissingItemError = true;
            break;
        }
        result.filter = ItemFilter.getInstance((String)nameAndNBT, (boolean)suppressMissingItemError);
        if (result.filter == null) {
            return null;
        }
        if (type == 0 || type == 1) {
            result.armorPenetration = Boolean.parseBoolean(tokens[1]);
            if (tokens.length > 2) {
                result.damageMultiplier = Double.parseDouble(tokens[2]);
            }
        }
        if (type == 2) {
            result.attackerEffects = Potions.parsePotions((String)tokens[1]);
        } else if (tokens.length > 3) {
            result.attackerEffects = Potions.parsePotions((String)tokens[3]);
            if (tokens.length > 4) {
                result.victimEffects = Potions.parsePotions((String)tokens[4]);
            }
        }
        if (tokens.length > 5) {
            result.consumeItem = Boolean.parseBoolean(tokens[5].trim());
        }
        if (result.attackerEffects == null) {
            result.attackerEffects = new ArrayList();
        }
        if (result.victimEffects == null) {
            result.victimEffects = new ArrayList();
        }
        return result;
    }

    public static WeaponEntry get(ItemStack itemStack, int type, boolean isBlocked) {
        if (itemStack == null) {
            return new WeaponEntry(type, false, isBlocked);
        }
        ArrayList<WeaponEntry> list = null;
        if (type == 0) {
            list = isBlocked ? AttackData.normalBlockedWeaponSpecific : AttackData.normalWeaponSpecific;
        } else if (type == 1) {
            list = isBlocked ? AttackData.stealthBlockedWeaponSpecific : AttackData.stealthWeaponSpecific;
        } else if (type == 2) {
            list = AttackData.assassinationWeaponSpecific;
        }
        for (WeaponEntry weaponEntry : list) {
            if (!weaponEntry.filter.matches(itemStack)) continue;
            return weaponEntry;
        }
        return new WeaponEntry(type, true, isBlocked);
    }
}

