/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.senses;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.PlayerData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class HidingData {
    public static LinkedHashMap<UUID, HidingData> hidingData = new LinkedHashMap();
    private static boolean save = true;
    public EntityPlayer player;
    public HashSet<UUID> notHidingFrom = new HashSet();

    public HidingData(EntityPlayer player, UUID ... notHidingFrom) {
        this.player = player;
        this.notHidingFrom.addAll(Arrays.asList(notHidingFrom));
    }

    public static void save(EntityPlayer player) {
        String filename = MCTools.getDataDir((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance());
        File file = new File(filename);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(filename = filename + File.separator + "dynamicstealth")).exists()) {
            file.mkdir();
        }
        if (!(file = new File(filename = filename + File.separator + player.getPersistentID())).exists()) {
            file.mkdir();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(filename + File.separator + "not hiding from.txt")));
            for (UUID id : HidingData.hidingData.computeIfAbsent((UUID)player.getPersistentID(), (Function<UUID, HidingData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$save$0(net.minecraft.entity.player.EntityPlayer java.util.UUID ), (Ljava/util/UUID;)Lcom/fantasticsource/dynamicstealth/server/senses/HidingData;)((EntityPlayer)player)).notHidingFrom) {
                writer.write(id.toString() + "\r\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load(EntityPlayer player) {
        String filename = MCTools.getDataDir((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance());
        File file = new File(filename);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(filename = filename + File.separator + "dynamicstealth")).exists()) {
            file.mkdir();
        }
        if (!(file = new File(filename = filename + File.separator + player.getPersistentID())).exists()) {
            file.mkdir();
        }
        file = new File(filename + File.separator + "not hiding from.txt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else {
                save = false;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null && !line.trim().equals("")) {
                    HidingData.hideFrom(player, UUID.fromString(line), false);
                    line = reader.readLine();
                }
                HidingData.save(player);
                save = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isHidingFrom(EntityPlayer player, String targetName) {
        return HidingData.isHidingFrom(player, PlayerData.getID((String)targetName));
    }

    public static boolean isHidingFrom(EntityPlayer player, UUID id) {
        if (id == null) {
            return true;
        }
        if (id.equals(player.getPersistentID())) {
            return false;
        }
        HidingData data = hidingData.get(player.getPersistentID());
        if (data == null) {
            return true;
        }
        return !data.notHidingFrom.contains(id);
    }

    public static void hideFrom(EntityPlayer player, String targetName, boolean hide) {
        UUID id = PlayerData.getID((String)targetName);
        if (id != null) {
            HidingData.hideFrom(player, PlayerData.getID((String)targetName), hide);
        } else {
            System.out.println(player.func_70005_c_() + " tried to hide from " + targetName + " but " + targetName + " was not found in PlayerData!");
        }
    }

    public static void hideFrom(EntityPlayer player, UUID id, boolean hide) {
        if (hide == HidingData.isHidingFrom(player, id)) {
            return;
        }
        HidingData data = hidingData.computeIfAbsent(player.getPersistentID(), k -> new HidingData(player, new UUID[0]));
        if (hide) {
            data.notHidingFrom.remove(id);
        } else {
            data.notHidingFrom.add(id);
        }
        if (save) {
            HidingData.save(player);
        }
    }

    private static /* synthetic */ HidingData lambda$save$0(EntityPlayer player, UUID k) {
        return new HidingData(player, new UUID[0]);
    }
}

