/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.senses.hearing;

import com.fantasticsource.dynamicstealth.DynamicStealth;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.GlobalDefaultsAndData;
import com.fantasticsource.dynamicstealth.server.HelperSystem;
import com.fantasticsource.dynamicstealth.server.ai.AIDynamicStealth;
import com.fantasticsource.dynamicstealth.server.senses.hearing.Hearing;
import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.dynamicstealth.server.threat.Threat;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Communication {
    private static ArrayList<WarnData> warners = new ArrayList();

    public static void notifyDead(EntityLivingBase notifier, EntityLivingBase dead) {
        if (notifier instanceof EntityLiving && notifier.field_70170_p == dead.field_70170_p && notifier.func_70089_S()) {
            EntityLiving livingNotifier = (EntityLiving)notifier;
            World world = notifier.field_70170_p;
            for (Entity entity : world.field_72996_f.toArray(new Entity[0])) {
                EntityLivingBase listener;
                if (!(entity instanceof EntityLivingBase) || Threat.getTarget(listener = (EntityLivingBase)entity) != dead || !HelperSystem.isAlly(listener, (EntityLivingBase)livingNotifier) || !Hearing.canHear(listener, (EntityLivingBase)livingNotifier, DynamicStealthConfig.serverSettings.senses.hearing.notificationRange)) continue;
                if (MCTools.isOwned((Entity)listener)) {
                    Threat.set(listener, null, 0.0f);
                } else {
                    Threat.clearTarget(listener);
                }
                Communication.notifyDead(listener, dead);
            }
        }
    }

    public static void warn(EntityLivingBase warner, EntityLivingBase danger, BlockPos dangerPos, boolean sawDanger) {
        if (GlobalDefaultsAndData.isFullBypass(warner)) {
            return;
        }
        warners.add(new WarnData(warner, danger, dangerPos, sawDanger));
    }

    public static void update(TickEvent.ServerTickEvent event) {
        warners.removeIf(Communication::processAndRemove);
    }

    private static boolean processAndRemove(WarnData warnData) {
        EntityLivingBase warner = warnData.warner;
        EntityLivingBase danger = warnData.danger;
        World world = warner.field_70170_p;
        if (warner.func_70089_S() && (danger == null || danger.field_70170_p == world)) {
            for (Entity helper : world.field_72996_f.toArray(new Entity[0])) {
                Communication.tryWarn(warner, helper, danger, warnData.dangerPos, warnData.sawDanger);
            }
        }
        return true;
    }

    private static void tryWarn(EntityLivingBase warner, Entity helper, EntityLivingBase danger, BlockPos dangerPos, boolean sawDanger) {
        EntityLiving livingHelper;
        if (helper != warner && helper != danger && helper instanceof EntityLiving && helper.func_70089_S() && !EntityThreatData.bypassesThreat((EntityLivingBase)(livingHelper = (EntityLiving)helper)) && HelperSystem.rep((EntityLivingBase)livingHelper, warner) > HelperSystem.rep((EntityLivingBase)livingHelper, danger)) {
            Threat.ThreatData helperThreat = Threat.get((EntityLivingBase)livingHelper);
            if (Hearing.canHear((EntityLivingBase)livingHelper, warner, DynamicStealthConfig.serverSettings.senses.hearing.warningRange)) {
                AIDynamicStealth helperAI;
                boolean canSee = sawDanger && Sight.canSee((EntityLivingBase)livingHelper, (Entity)danger, true, false, true, MCTools.getYawDeg((Vec3d)livingHelper.func_174791_d().func_178787_e(new Vec3d(0.0, (double)livingHelper.func_70047_e(), 0.0)), (Vec3d)danger.func_174791_d().func_178787_e(new Vec3d(0.0, (double)danger.field_70131_O * 0.5, 0.0)), (TrigLookupTable)DynamicStealth.TRIG_TABLE), MCTools.getPitchDeg((Vec3d)livingHelper.func_174791_d(), (Vec3d)danger.func_174791_d(), (TrigLookupTable)DynamicStealth.TRIG_TABLE));
                Threat.apply((EntityLivingBase)livingHelper, danger, DynamicStealthConfig.serverSettings.threat.warnedThreat, Threat.THREAT_TYPE.GEN_WARNED, canSee);
                if ((helperThreat.target == null || helperThreat.target == danger) && (helperAI = AIDynamicStealth.getStealthAI(livingHelper)) != null) {
                    helperAI.fleeIfYouShould(0.0f);
                    if (canSee) {
                        helperAI.lastKnownPosition = danger.func_180425_c();
                    } else {
                        int distance = (int)helper.func_70011_f((double)dangerPos.func_177958_n(), (double)dangerPos.func_177956_o(), (double)dangerPos.func_177952_p());
                        helperAI.lastKnownPosition = MCTools.randomPos((BlockPos)dangerPos, (int)Tools.min((int[])new int[]{3 + (distance >> 1), 7}), (int)Tools.min((int[])new int[]{1 + (distance >> 2), 4}));
                    }
                }
            }
        }
    }

    public static class WarnData {
        EntityLivingBase warner;
        EntityLivingBase danger;
        BlockPos dangerPos;
        boolean sawDanger;

        public WarnData(EntityLivingBase warner, EntityLivingBase danger, BlockPos dangerPos, boolean sawDanger) {
            this.warner = warner;
            this.danger = danger;
            this.dangerPos = dangerPos;
            this.sawDanger = sawDanger;
        }
    }
}

