/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.senses.sight;

import com.fantasticsource.dynamicstealth.common.DSTools;
import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.compat.CompatDissolution;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.config.server.senses.sight.SightConfig;
import com.fantasticsource.dynamicstealth.server.Attributes;
import com.fantasticsource.dynamicstealth.server.HUDData;
import com.fantasticsource.dynamicstealth.server.senses.HidingData;
import com.fantasticsource.dynamicstealth.server.senses.sight.EntitySightData;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.mctools.ImprovedRayTracing;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.ExplicitPriorityQueue;
import com.fantasticsource.tools.datastructures.Pair;
import com.fantasticsource.tools.datastructures.WrappingQueue;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Sight {
    private static final int SEEN_RECENT_TIMER = 60;
    private static final int GLOBAL_STEALTH_SMOOTHING = 3;
    private static Map<EntityPlayer, Pair<WrappingQueue<Double>, Long>> globalPlayerStealthHistory = new LinkedHashMap<EntityPlayer, Pair<WrappingQueue<Double>, Long>>();
    private static Map<EntityLivingBase, Map<Entity, SeenData>> recentlySeenMap = new LinkedHashMap<EntityLivingBase, Map<Entity, SeenData>>();
    private static Map<Pair<EntityPlayerMP, Boolean>, LinkedHashMap<EntityLivingBase, Double>> playerSeenThisTickMap = new LinkedHashMap<Pair<EntityPlayerMP, Boolean>, LinkedHashMap<EntityLivingBase, Double>>();

    public static void update(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            playerSeenThisTickMap.clear();
            recentlySeenMap.entrySet().removeIf(Sight::updateRecentlySeen);
            globalPlayerStealthHistory.entrySet().removeIf(Sight::updateStealthHistory);
        }
    }

    private static boolean updateStealthHistory(Map.Entry<EntityPlayer, Pair<WrappingQueue<Double>, Long>> entry) {
        EntityPlayer player = entry.getKey();
        if (!player.func_70089_S() || !player.field_70170_p.field_73010_i.contains(player)) {
            return true;
        }
        Pair<WrappingQueue<Double>, Long> pair = entry.getValue();
        long tick = ServerTickTimer.currentTick();
        if ((Long)pair.getValue() != tick) {
            ((WrappingQueue)pair.getKey()).add((Object)1.0);
            pair.setValue((Object)tick);
        }
        return false;
    }

    private static boolean updateRecentlySeen(Map.Entry<EntityLivingBase, Map<Entity, SeenData>> entry) {
        EntityLivingBase livingBase = entry.getKey();
        if (!livingBase.func_70089_S() || !livingBase.field_70170_p.field_72996_f.contains(livingBase)) {
            return true;
        }
        entry.getValue().entrySet().removeIf(e -> {
            Entity entity = (Entity)e.getKey();
            return !entity.func_70089_S() || !entity.field_70170_p.field_72996_f.contains(entity);
        });
        return false;
    }

    public static boolean recentlySeen(EntityLivingBase searcher, Entity target) {
        if (searcher == null || target == null) {
            return false;
        }
        Map<Entity, SeenData> map = recentlySeenMap.get(searcher);
        if (map == null) {
            return false;
        }
        SeenData data = map.get(target);
        if (data == null) {
            return false;
        }
        return data.seen && ServerTickTimer.currentTick() - data.lastSeenTime < 60L;
    }

    public static boolean canSee(EntityLivingBase searcher, Entity target, boolean isAggressive) {
        return Sight.visualStealthLevel(searcher, target, isAggressive, true, true, searcher.field_70759_as, searcher.field_70125_A) <= 1.0;
    }

    public static boolean canSee(EntityLivingBase searcher, Entity target, boolean isAggressive, boolean useCache, boolean saveCache) {
        return Sight.visualStealthLevel(searcher, target, isAggressive, useCache, saveCache, searcher.field_70759_as, searcher.field_70125_A) <= 1.0;
    }

    public static boolean canSee(EntityLivingBase searcher, Entity target, boolean isAggressive, boolean useCache, boolean saveCache, double yaw, double pitch) {
        return Sight.visualStealthLevel(searcher, target, isAggressive, useCache, saveCache, yaw, pitch) <= 1.0;
    }

    public static double visualStealthLevel(EntityLivingBase searcher, Entity target, boolean isAggressive) {
        return Sight.visualStealthLevel(searcher, target, isAggressive, true, true, searcher.field_70759_as, searcher.field_70125_A);
    }

    public static double visualStealthLevel(EntityLivingBase searcher, Entity target, boolean isAggressive, boolean useCache, boolean saveCache, double yaw, double pitch) {
        SeenData data;
        if (searcher == null || target == null || !searcher.field_70170_p.func_175667_e(searcher.func_180425_c()) || !target.field_70170_p.func_175667_e(target.func_180425_c())) {
            return 777.0;
        }
        searcher.field_70170_p.field_72984_F.func_76320_a("DStealth: Visual Stealth");
        Map<Entity, SeenData> map = recentlySeenMap.get(searcher);
        long tick = ServerTickTimer.currentTick();
        if (map != null && useCache && (data = map.get(target)) != null && data.lastUpdateTime == tick) {
            searcher.field_70170_p.field_72984_F.func_76319_b();
            return data.lastStealthLevel;
        }
        double result = Sight.visualStealthLevelInternal(searcher, target, isAggressive, yaw, pitch);
        if (saveCache) {
            if (isAggressive && target instanceof EntityPlayer && HUDData.isGauged(searcher) && (searcher instanceof EntityPlayer || searcher instanceof EntityLiving && (((EntityLiving)searcher).func_70638_az() == target || !EntityThreatData.isPassive(searcher) && !EntityThreatData.bypassesThreat(searcher)))) {
                EntityPlayer player = (EntityPlayer)target;
                Pair pair = globalPlayerStealthHistory.computeIfAbsent(player, k -> new Pair((Object)new WrappingQueue(5), (Object)(tick - 1L)));
                WrappingQueue queue = (WrappingQueue)pair.getKey();
                double clampedResult = Tools.min((double[])new double[]{Tools.max((double[])new double[]{-1.0, result - 1.0}), 1.0});
                if (queue.size() != 0 && (Long)pair.getValue() == tick) {
                    queue.setNewestToOldest(0, (Object)Tools.min((double[])new double[]{clampedResult, (Double)queue.getNewestToOldest(0)}));
                } else {
                    queue.add((Object)clampedResult);
                }
                pair.setValue((Object)tick);
            }
            if (map == null) {
                map = new LinkedHashMap<Entity, SeenData>();
                recentlySeenMap.put(searcher, map);
                map.put(target, new SeenData(result));
            } else {
                SeenData data2 = map.get(target);
                if (data2 == null) {
                    map.put(target, new SeenData(result));
                } else {
                    data2.lastUpdateTime = tick;
                    data2.lastStealthLevel = result;
                    if (result <= 1.0) {
                        data2.seen = true;
                        data2.lastSeenTime = tick;
                    }
                }
            }
        }
        searcher.field_70170_p.field_72984_F.func_76319_b();
        return result;
    }

    public static LinkedHashMap<EntityLivingBase, Double> seenEntities(EntityPlayerMP player) {
        player.field_70170_p.field_72984_F.func_76320_a("DStealth: Seen Entities");
        LinkedHashMap<EntityLivingBase, Double> map = playerSeenThisTickMap.get(new Pair((Object)player, (Object)false));
        if (map != null) {
            player.field_70170_p.field_72984_F.func_76319_b();
            return (LinkedHashMap)map.clone();
        }
        map = Sight.seenEntitiesInternal(player);
        playerSeenThisTickMap.put((Pair<EntityPlayerMP, Boolean>)new Pair((Object)player, (Object)false), (LinkedHashMap)map.clone());
        player.field_70170_p.field_72984_F.func_76319_b();
        return map;
    }

    private static LinkedHashMap<EntityLivingBase, Double> seenEntitiesInternal(EntityPlayerMP player) {
        LinkedHashMap<EntityLivingBase, Double> result = new LinkedHashMap<EntityLivingBase, Double>();
        Entity[] loadedEntities = player.field_70170_p.field_72996_f.toArray(new Entity[0]);
        if (DynamicStealthConfig.serverSettings.senses.usePlayerSenses) {
            for (Entity entity : loadedEntities) {
                double stealthLevel;
                if (!(entity instanceof EntityLivingBase) || entity == player || !((stealthLevel = Sight.visualStealthLevel((EntityLivingBase)player, entity, true)) <= 1.0)) continue;
                result.put((EntityLivingBase)entity, stealthLevel);
            }
        } else {
            for (Entity entity : loadedEntities) {
                if (!(entity instanceof EntityLivingBase) || entity == player) continue;
                result.put((EntityLivingBase)entity, -888.0);
            }
        }
        return result;
    }

    private static double visualStealthLevelInternal(EntityLivingBase searcher, Entity target, boolean isAggressive, double yaw, double pitch) {
        double distanceThreshold;
        if (searcher.field_70170_p != target.field_70170_p || target.field_70128_L || target instanceof FakePlayer) {
            return 777.0;
        }
        if (searcher instanceof EntityPlayerMP && target == ((EntityPlayerMP)searcher).func_175398_C()) {
            return -777.0;
        }
        if (target instanceof EntityPlayer) {
            if (searcher instanceof EntityPlayer) {
                if (!HidingData.isHidingFrom((EntityPlayer)target, searcher.func_70005_c_())) {
                    return -777.0;
                }
            } else if (searcher instanceof EntityLiving && isAggressive && (((EntityPlayer)target).field_71075_bZ.field_75098_d || ((EntityPlayer)target).func_175149_v())) {
                return 777.0;
            }
        }
        if (target instanceof EntityDragon || target instanceof EntityWither) {
            return -777.0;
        }
        if (searcher instanceof EntityPlayer && CompatDissolution.isPossessing((EntityPlayer)searcher, target)) {
            return -777.0;
        }
        if (MCTools.isRidingOrRiddenBy((Entity)searcher, (Entity)target)) {
            return -777.0;
        }
        double distSquared = searcher.func_70068_e(target);
        int distanceFar = EntitySightData.distanceFar(searcher);
        if (EntitySightData.hasSoulSight(searcher)) {
            if (distSquared > 10000.0) {
                return 777.0;
            }
            return -777.0;
        }
        if (distSquared > Math.pow(distanceFar, 2.0)) {
            return 777.0;
        }
        int angleLarge = EntitySightData.angleLarge(searcher);
        if (angleLarge == 0) {
            return 777.0;
        }
        int angleSmall = EntitySightData.angleSmall(searcher);
        if (angleSmall == 180) {
            distanceThreshold = distanceFar;
        } else {
            double angleDif = MCTools.angleDifDeg((Vec3d)searcher.func_174791_d(), (float)((float)yaw), (float)((float)pitch), (Vec3d)target.func_174791_d());
            if (angleDif > (double)angleLarge) {
                return 777.0;
            }
            if (angleDif < (double)angleSmall) {
                distanceThreshold = distanceFar;
            } else {
                int distanceNear = EntitySightData.distanceNear(searcher);
                distanceThreshold = (double)distanceNear + (double)(distanceFar - distanceNear) * ((double)angleLarge - angleDif) / (double)(angleLarge - angleSmall);
            }
        }
        boolean isLivingBase = target instanceof EntityLivingBase;
        EntityLivingBase targetLivingBase = isLivingBase ? (EntityLivingBase)target : null;
        SightConfig sight = DynamicStealthConfig.serverSettings.senses.sight;
        if (sight.g_absolutes.seeGlowing && isLivingBase && targetLivingBase.func_70660_b(MobEffects.field_188423_x) != null) {
            return -777.0;
        }
        double sightAttrib = searcher.func_110148_a((IAttribute)Attributes.SIGHT).func_111126_e();
        if (sightAttrib <= 0.0) {
            return 777.0;
        }
        double visReductionAttrib = !isLivingBase ? 0.0 : targetLivingBase.func_110148_a((IAttribute)Attributes.VISIBILITY_REDUCTION).func_111126_e();
        double attributeMultipliers = visReductionAttrib <= 0.0 ? 777.0 : sightAttrib / visReductionAttrib;
        double lightFactor = Sight.bestLightingAtLOSHit((Entity)searcher, target, isLivingBase && EntitySightData.isBright(targetLivingBase));
        if (lightFactor == -777.0) {
            return 777.0;
        }
        if (EntitySightData.hasNightvision(searcher)) {
            lightFactor = Math.min(15.0, lightFactor + (double)sight.c_lighting.nightvisionBonus);
        }
        int lightLevelLow = EntitySightData.lightLevelLow(searcher);
        double lightMultLow = EntitySightData.lightMultLow(searcher);
        if (lightFactor <= (double)lightLevelLow) {
            lightFactor = lightMultLow;
        } else {
            int lightLevelHigh = EntitySightData.lightLevelHigh(searcher);
            double lightMultHigh = EntitySightData.lightMultHigh(searcher);
            lightFactor = lightFactor >= (double)lightLevelHigh ? lightMultHigh : (lightFactor - (double)lightLevelLow) / (double)(lightLevelHigh - lightLevelLow) * (lightMultHigh - lightMultLow) + lightMultLow;
        }
        double blindnessMultiplier = searcher.func_70660_b(MobEffects.field_76440_q) != null ? sight.a_stealthMultipliers.blindnessMultiplier : 1.0;
        double invisibilityMultiplier = isLivingBase && targetLivingBase.func_70660_b(MobEffects.field_76441_p) != null ? sight.a_stealthMultipliers.invisibilityMultiplier : 1.0;
        double crouchingMultiplier = target.func_70093_af() ? sight.a_stealthMultipliers.crouchingMultiplier : 1.0;
        double mobHeadMultiplier = 1.0;
        if (isLivingBase) {
            ItemStack helmet = targetLivingBase.func_184582_a(EntityEquipmentSlot.HEAD);
            if (helmet.func_77973_b() == Items.field_151144_bL) {
                int damage = helmet.func_77952_i();
                if (target instanceof EntitySkeleton && damage == 0 || target instanceof EntityWitherSkeleton && damage == 1 || target instanceof EntityZombie && damage == 2 || target instanceof EntityCreeper && damage == 4) {
                    mobHeadMultiplier = sight.a_stealthMultipliers.mobHeadMultiplier;
                }
            } else if (helmet.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK) && helmet.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150428_aP) && target instanceof EntitySnowman) {
                mobHeadMultiplier = sight.a_stealthMultipliers.mobHeadMultiplier;
            }
        }
        double armorMultiplier = 1.0;
        if (isLivingBase) {
            double unnaturalArmor = 0.0;
            for (EntityEquipmentSlot slot : new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET}) {
                ItemStack stack = targetLivingBase.func_184582_a(slot);
                Item item = stack.func_77973_b();
                if (item instanceof ISpecialArmor) {
                    unnaturalArmor = Compat.conarm && item.getClass().getName().contains("conarm.common.items.armor") ? (unnaturalArmor += Math.abs(((ISpecialArmor)item).getProperties((EntityLivingBase)targetLivingBase, (ItemStack)stack, (DamageSource)new DamageSource((String)"generic"), (double)1.0, (int)Integer.MIN_VALUE).Armor)) : (unnaturalArmor += ((ISpecialArmor)item).getProperties((EntityLivingBase)targetLivingBase, (ItemStack)stack, (DamageSource)new DamageSource((String)"generic"), (double)1.0, (int)Integer.MIN_VALUE).Armor);
                }
                if (!(item instanceof ItemArmor)) continue;
                unnaturalArmor += (double)((ItemArmor)item).field_77879_b;
            }
            armorMultiplier += DynamicStealthConfig.serverSettings.senses.sight.b_visibilityMultipliers.armorMultiplierCumulative * unnaturalArmor;
        }
        double stealthMultiplier = Tools.min((double[])new double[]{mobHeadMultiplier, blindnessMultiplier * invisibilityMultiplier * crouchingMultiplier});
        double visibilityMultiplier = armorMultiplier;
        double configMultipliers = Tools.min((double[])new double[]{Tools.max((double[])new double[]{stealthMultiplier * visibilityMultiplier, 0.0}), 1.0});
        return Math.sqrt(distSquared) / (distanceThreshold * lightFactor * configMultipliers * attributeMultipliers);
    }

    private static double bestLightingAtLOSHit(Entity searcher, Entity target, boolean forceMaxLight) {
        World world = searcher.field_70170_p;
        if (world != target.field_70170_p) {
            return -777.0;
        }
        ExplicitPriorityQueue queue = new ExplicitPriorityQueue();
        if (forceMaxLight) {
            for (Vec3d vec : DSTools.entityCheckVectors(target)) {
                queue.add((Object)vec, 0.0);
            }
        } else {
            for (Vec3d vec : DSTools.entityCheckVectors(target)) {
                queue.add((Object)vec, (double)(15 - DSTools.lightLevelTotal(world, vec)));
            }
        }
        while (queue.size() > 0) {
            double result = queue.peekPriority();
            Vec3d testVec = (Vec3d)queue.poll();
            if (!ImprovedRayTracing.isUnobstructed((World)searcher.field_70170_p, (Vec3d)new Vec3d(searcher.field_70165_t, searcher.field_70163_u + (double)searcher.func_70047_e(), searcher.field_70161_v), (Vec3d)testVec, (boolean)false)) continue;
            return 15.0 - result;
        }
        return -777.0;
    }

    public static double globalPlayerStealthLevel(EntityPlayer player) {
        int size;
        long tick = ServerTickTimer.currentTick();
        Pair<WrappingQueue<Double>, Long> pair = globalPlayerStealthHistory.get(player);
        if (pair == null) {
            WrappingQueue queue = new WrappingQueue(5);
            queue.add((Object)1.0);
            globalPlayerStealthHistory.put(player, (Pair<WrappingQueue<Double>, Long>)new Pair((Object)queue, (Object)tick));
            return 1.0;
        }
        WrappingQueue queue = (WrappingQueue)pair.getKey();
        if ((Long)pair.getValue() != tick) {
            queue.add((Object)1.0);
            pair.setValue((Object)tick);
        }
        if ((size = queue.size()) == 1) {
            return 1.0;
        }
        if (size == 2) {
            return (Double)queue.getOldestToNewest(0);
        }
        if (size < 5) {
            double result = 1.0;
            for (int i = size - 2; i >= 0; --i) {
                result = Tools.min((double[])new double[]{result, (Double)queue.getOldestToNewest(i)});
            }
            return result;
        }
        double first = (Double)queue.getOldestToNewest(0);
        double result = 1.0;
        for (int i = 1; i < size - 1; ++i) {
            if ((result = Tools.min((double[])new double[]{result, (Double)queue.getOldestToNewest(i)})) < first) break;
        }
        return result;
    }

    private static class SeenData {
        boolean seen = false;
        long lastSeenTime;
        long lastUpdateTime = ServerTickTimer.currentTick();
        double lastStealthLevel;

        SeenData(double stealthLevel) {
            this(stealthLevel, false);
        }

        SeenData(double stealthLevel, boolean forceSeen) {
            this.lastStealthLevel = stealthLevel;
            if (forceSeen || stealthLevel <= 1.0) {
                this.seen = true;
                this.lastSeenTime = ServerTickTimer.currentTick();
            }
        }
    }
}

