/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.dissolution.api.corporeality;

import java.util.UUID;
import javax.annotation.Nonnull;
import ladysnake.dissolution.api.IDialogueStats;
import ladysnake.dissolution.api.corporeality.ICorporealityStatus;
import ladysnake.dissolution.api.corporeality.IDeathStats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;

public interface IIncorporealHandler {
    public boolean isStrongSoul();

    public void setStrongSoul(boolean var1);

    @Nonnull
    public ICorporealityStatus getCorporealityStatus();

    public void setCorporealityStatus(ICorporealityStatus var1);

    default public boolean isIncorporeal() {
        return this.getCorporealityStatus().isIncorporeal() && !this.isPossessionActive();
    }

    default public <T extends EntityLivingBase> boolean setPossessed(T possessable) {
        return this.setPossessed(possessable, false);
    }

    public <T extends EntityLivingBase> boolean setPossessed(T var1, boolean var2);

    public <T extends EntityLivingBase> T getPossessed();

    public UUID getPossessedUUID();

    default public boolean isPossessionActive() {
        return this.getPossessedUUID() != null;
    }

    @Nonnull
    public IDialogueStats getDialogueStats();

    public IDeathStats getDeathStats();

    public boolean isSynced();

    public void setSynced(boolean var1);

    public NBTTagCompound getSerializedPossessedEntity();

    public void setSerializedPossessedEntity(NBTTagCompound var1);

    public void tick();
}

