/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.dissolution.api.possession;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class DissolutionPossessionApi {
    private static final Map<Class<? extends EntityLivingBase>, Class<? extends EntityLivingBase>> POSSESSABLES = new HashMap<Class<? extends EntityLivingBase>, Class<? extends EntityLivingBase>>();

    @SafeVarargs
    public static void excludeEntitiesFromPossession(Class<? extends EntityLivingBase> ... entityClasses) {
        for (Class<? extends EntityLivingBase> entityClass : entityClasses) {
            DissolutionPossessionApi.registerPossessedVersion(entityClass, null);
        }
    }

    public static <T extends EntityLivingBase, P extends EntityLivingBase> void registerPossessedVersion(Class<T> baseEntityClass, Class<P> possessedEntityClass) {
        POSSESSABLES.put(baseEntityClass, possessedEntityClass);
    }

    @Nullable
    public static <T extends EntityLivingBase, P extends EntityLivingBase> Class<P> getPossessable(Class<T> base) {
        return POSSESSABLES.get(base);
    }

    public static boolean isEntityRegistered(Class<? extends Entity> entityClass) {
        return EntityLivingBase.class.isAssignableFrom(entityClass) && POSSESSABLES.containsKey(entityClass);
    }
}

