/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.dissolution.api.possession;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

public class PossessionEvent
extends PlayerEvent {
    protected EntityLivingBase possessed;

    public <T extends EntityLivingBase> PossessionEvent(EntityPlayer player, T possessed) {
        super(player);
        this.possessed = possessed;
    }

    @Nullable
    public <T extends EntityLivingBase> T getPossessed() {
        return (T)this.possessed;
    }

    @Cancelable
    public static class Stop
    extends PossessionEvent {
        private final boolean forced;

        public <T extends EntityLivingBase> Stop(EntityPlayer player, T possessed, boolean forced) {
            super(player, possessed);
            this.forced = forced;
        }

        public boolean isCancelable() {
            return !this.isForced();
        }

        public boolean isForced() {
            return this.forced;
        }
    }

    @Cancelable
    public static class Start
    extends PossessionEvent {
        private final boolean forced;

        public <T extends EntityLivingBase> Start(EntityPlayer player, @Nonnull T possessed, boolean forced) {
            super(player, possessed);
            this.forced = forced;
        }

        public boolean isCancelable() {
            return !this.isForced();
        }

        public boolean isForced() {
            return this.forced;
        }

        @Override
        @Nonnull
        public <T extends EntityLivingBase> T getPossessed() {
            return (T)this.possessed;
        }
    }

    public static class Setup
    extends PossessionEvent {
        private final EntityLivingBase original;

        public <T extends EntityLivingBase> Setup(EntityPlayer player, @Nonnull EntityLivingBase original, @Nullable T possessed) {
            super(player, possessed);
            this.original = original;
        }

        public EntityLivingBase getOriginal() {
            return this.original;
        }

        public <T extends EntityLivingBase> void setPossessed(T possessed) {
            this.possessed = possessed;
        }
    }
}

