/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.fantasticlib;

import com.fantasticsource.fantasticlib.Commands;
import com.fantasticsource.fantasticlib.Compat;
import com.fantasticsource.fantasticlib.api.INBTCap;
import com.fantasticsource.fantasticlib.config.FantasticConfig;
import com.fantasticsource.mctools.DataFiles;
import com.fantasticsource.mctools.EntityRenderFixer;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.Network;
import com.fantasticsource.mctools.PlayerData;
import com.fantasticsource.mctools.Render;
import com.fantasticsource.mctools.TooltipFixer;
import com.fantasticsource.mctools.aw.ForcedAWSkinOverrides;
import com.fantasticsource.mctools.aw.RenderModes;
import com.fantasticsource.mctools.aw.TransientAWSkinHandler;
import com.fantasticsource.mctools.data.CModpackDataHandler;
import com.fantasticsource.mctools.data.CWorldDataHandler;
import com.fantasticsource.mctools.gui.screen.TestGUI;
import com.fantasticsource.mctools.nbtcap.NBTCap;
import com.fantasticsource.mctools.nbtcap.NBTCapStorage;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.datastructures.ColorImmutable;
import net.minecraft.command.ICommand;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="fantasticlib", name="Fantastic Lib", version="1.12.2.037", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class FantasticLib {
    public static final String MODID = "fantasticlib";
    public static final String DOMAIN = "flib";
    public static final String NAME = "Fantastic Lib";
    public static final String VERSION = "1.12.2.037";
    public static boolean isClient = false;
    public static final boolean DEV_ENV = ReflectionTool.getField(ItemStack.class, "stackSize") != null;

    public FantasticLib() {
        MinecraftForge.EVENT_BUS.register(FantasticLib.class);
        MinecraftForge.EVENT_BUS.register(NBTCap.class);
        Network.init();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            isClient = true;
            if (FantasticConfig.entityRenderFixer) {
                MinecraftForge.EVENT_BUS.register(EntityRenderFixer.class);
            }
            MinecraftForge.EVENT_BUS.register(TooltipFixer.class);
            if (DEV_ENV) {
                MinecraftForge.EVENT_BUS.register(TestGUI.class);
            }
        }
        MinecraftForge.EVENT_BUS.register(PlayerData.class);
    }

    @SubscribeEvent
    public static void saveConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PlayerData.load();
        CapabilityManager.INSTANCE.register(INBTCap.class, (Capability.IStorage)new NBTCapStorage(), () -> null);
        if (event.getSide() == Side.CLIENT) {
            Render.init();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CModpackDataHandler.load(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws IllegalAccessException {
        DataFiles.output();
        Compat.betterportals = Loader.isModLoaded((String)"betterportals");
        Compat.smoothfont = Loader.isModLoaded((String)"smoothfont");
        Compat.baubles = Loader.isModLoaded((String)"baubles");
        Compat.tiamatinventory = Loader.isModLoaded((String)"tiamatinventory");
        if (Loader.isModLoaded((String)"armourers_workshop")) {
            RenderModes.init();
            MinecraftForge.EVENT_BUS.register(TransientAWSkinHandler.class);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                ForcedAWSkinOverrides.clientInit();
            }
        }
    }

    @Mod.EventHandler
    public static void serverPreInit(FMLServerAboutToStartEvent event) {
        MCTools.serverStart(event);
    }

    @Mod.EventHandler
    public static void serverInit(FMLServerStartingEvent event) {
        CWorldDataHandler.load(event);
        event.registerServerCommand((ICommand)new Commands());
    }

    @Mod.EventHandler
    public static void serverStop(FMLServerStoppedEvent event) {
        MCTools.serverStop(event);
        CWorldDataHandler.clear(event);
    }

    static {
        ColorImmutable.init();
    }
}

