/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.ImprovedRayTracing;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import com.fantasticsource.tools.datastructures.ExplicitPriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.NotImplementedException;
import org.lwjgl.util.vector.Quaternion;

public class EntityFilters {
    public static final LinkedHashMap<Integer, String> INLUSION_MODES = new LinkedHashMap();
    public static final int INCLUSION_MODE_ENTITY_POSITION = 0;
    public static final int INCLUSION_MODE_GEOMETRIC_CENTER = 1;
    public static final int INCLUSION_MODE_RECTANGULAR_PRISM_ANY = 2;
    public static final int INCLUSION_MODE_RECTANGULAR_PRISM_FULL = 3;
    public static final int INCLUSION_MODE_CYLINDER_ANY = 4;
    public static final int INCLUSION_MODE_CYLINDER_FULL = 5;
    private static final double DEFAULT_DISTRIBUTED_RAYTRACE_SPACING = 0.5;

    public static ArrayList<Entity> inWorld(World world, ArrayList<Entity> entitiesToCheck) {
        entitiesToCheck.removeIf(entity -> entity.field_70170_p != world);
        return entitiesToCheck;
    }

    public static ArrayList<Entity> inCube(Vec3d origin, double halfSize, int inclusionMode, ArrayList<Entity> entitiesToCheck) {
        double top = origin.field_72448_b + halfSize;
        double bottom = origin.field_72448_b - halfSize;
        double west = origin.field_72450_a - halfSize;
        double east = origin.field_72450_a + halfSize;
        double north = origin.field_72449_c - halfSize;
        double south = origin.field_72449_c + halfSize;
        switch (inclusionMode) {
            case 0: {
                entitiesToCheck.removeIf(entity -> entity.field_70165_t < west || entity.field_70165_t > east || entity.field_70161_v < north || entity.field_70161_v > south || entity.field_70163_u > top || entity.field_70163_u < bottom);
                break;
            }
            case 1: {
                entitiesToCheck.removeIf(entity -> {
                    if (entity.field_70165_t < west || entity.field_70165_t > east || entity.field_70161_v < north || entity.field_70161_v > south) {
                        return true;
                    }
                    double centerY = entity.field_70163_u + (double)entity.field_70131_O * 0.5;
                    return centerY > top || centerY < bottom;
                });
                break;
            }
            case 2: {
                entitiesToCheck.removeIf(entity -> {
                    double halfW = (double)entity.field_70130_N * 0.5;
                    double eWest = entity.field_70165_t - halfW;
                    double eEast = entity.field_70165_t + halfW;
                    if (eWest > east || eEast < west) {
                        return true;
                    }
                    double eNorth = entity.field_70161_v - halfW;
                    double eSouth = entity.field_70161_v + halfW;
                    if (eNorth > south || eSouth < north) {
                        return true;
                    }
                    double halfH = (double)entity.field_70131_O * 0.5;
                    double eTop = entity.field_70163_u + halfH;
                    double eBottom = entity.field_70163_u - halfH;
                    return eTop < bottom || eBottom > top;
                });
                break;
            }
            case 3: 
            case 5: {
                entitiesToCheck.removeIf(entity -> {
                    double halfW = (double)entity.field_70130_N * 0.5;
                    double eWest = entity.field_70165_t - halfW;
                    double eEast = entity.field_70165_t + halfW;
                    if (eWest < west || eEast > east) {
                        return true;
                    }
                    double eNorth = entity.field_70161_v - halfW;
                    double eSouth = entity.field_70161_v + halfW;
                    if (eNorth < north || eSouth > south) {
                        return true;
                    }
                    double halfH = (double)entity.field_70131_O * 0.5;
                    double eTop = entity.field_70163_u + halfH;
                    double eBottom = entity.field_70163_u - halfH;
                    return eTop > top || eBottom < bottom;
                });
                break;
            }
            default: {
                throw new NotImplementedException("Mode not implemented for this method: " + inclusionMode);
            }
        }
        return entitiesToCheck;
    }

    public static ArrayList<Entity> inSphere(Vec3d origin, double radius, int inclusionMode, ArrayList<Entity> entitiesToCheck) {
        double squareRadius = radius * radius;
        switch (inclusionMode) {
            case 0: {
                entitiesToCheck.removeIf(entity -> origin.func_72436_e(entity.func_174791_d()) > squareRadius);
                break;
            }
            case 1: {
                entitiesToCheck.removeIf(entity -> origin.func_72436_e(entity.func_174791_d().func_72441_c(0.0, (double)entity.field_70131_O * 0.5, 0.0)) > squareRadius);
                break;
            }
            case 3: {
                entitiesToCheck.removeIf(entity -> {
                    double halfW = (double)entity.field_70130_N * 0.5;
                    double halfH = (double)entity.field_70131_O * 0.5;
                    Vec3d geoCenter = entity.func_174791_d().func_72441_c(0.0, halfH, 0.0);
                    return origin.func_72436_e(geoCenter.func_72441_c(origin.field_72450_a < geoCenter.field_72450_a ? halfW : -halfW, origin.field_72448_b < geoCenter.field_72448_b ? halfH : -halfH, origin.field_72449_c < geoCenter.field_72449_c ? halfW : -halfW)) > squareRadius;
                });
                break;
            }
            default: {
                throw new NotImplementedException("Mode not implemented for this method: " + inclusionMode);
            }
        }
        return entitiesToCheck;
    }

    public static ArrayList<Entity> inCone(Vec3d origin, Vec3d direction, double range, double angle, boolean LOS2, ArrayList<Entity> entitiesToCheck) {
        return EntityFilters.inCone(origin, direction, range, angle, LOS2, entitiesToCheck, 0.5);
    }

    public static ArrayList<Entity> inCone(Vec3d origin, Vec3d direction, double range, double angle, boolean LOS2, ArrayList<Entity> entitiesToCheck, double distributedRaytraceSpacing) {
        Vec3d pos2 = origin.func_178787_e(direction);
        float yaw = (float)MCTools.getYawDeg(origin, pos2, TrigLookupTable.TRIG_TABLE_1024);
        float pitch = (float)MCTools.getPitchDeg(origin, pos2, TrigLookupTable.TRIG_TABLE_1024);
        return EntityFilters.inCone(origin, yaw, pitch, range, angle, LOS2, entitiesToCheck, distributedRaytraceSpacing);
    }

    public static ArrayList<Entity> inCone(Vec3d origin, float yaw, float pitch, double range, double angle, boolean LOS2, ArrayList<Entity> entitiesToCheck) {
        return EntityFilters.inCone(origin, yaw, pitch, range, angle, LOS2, entitiesToCheck, 0.5);
    }

    public static ArrayList<Entity> inCone(Vec3d origin, float yaw, float pitch, double range, double angle, boolean LOS2, ArrayList<Entity> entitiesToCheck, double distributedRaytraceSpacing) {
        Vec3d coneAxisEnd = origin.func_178787_e(Vec3d.func_189986_a((float)pitch, (float)yaw).func_72432_b().func_186678_a(range));
        double squareRange = origin.func_72436_e(coneAxisEnd);
        double halfAngle = angle / 2.0;
        ExplicitPriorityQueue<Entity> queue = new ExplicitPriorityQueue<Entity>(entitiesToCheck.size());
        if (!LOS2) {
            for (Entity target : entitiesToCheck) {
                Vec3d targetCenter = target.func_174791_d().func_72441_c(0.0, (double)target.field_70131_O * 0.5, 0.0);
                double squareDist = origin.func_72436_e(targetCenter);
                if (squareDist > squareRange || MCTools.angleDifDeg(origin, coneAxisEnd, targetCenter) > halfAngle) continue;
                queue.add(target, squareDist);
            }
        } else {
            block1: for (Entity target : entitiesToCheck) {
                Vec3d targetCenter = target.func_174791_d().func_72441_c(0.0, (double)target.field_70131_O * 0.5, 0.0);
                double squareDist = origin.func_72436_e(targetCenter);
                if (squareDist > squareRange) continue;
                if (squareDist < Math.pow(target.field_70130_N / 2.0f, 2.0)) {
                    queue.add(target, squareDist);
                    continue;
                }
                if (ImprovedRayTracing.entityPenetration(target, origin, coneAxisEnd, true) >= 0.0) {
                    queue.add(target, squareDist);
                    continue;
                }
                if (halfAngle == 0.0) continue;
                double angleDif = MCTools.angleDifDeg(origin, coneAxisEnd, targetCenter);
                if (angleDif <= halfAngle && ImprovedRayTracing.entityPenetration(target, origin, targetCenter, true) >= 0.0) {
                    queue.add(target, squareDist);
                    continue;
                }
                double distance = Math.sqrt(squareDist);
                double subConeStep = Tools.radtodeg(MCTools.TRIG_TABLE.arctan(distributedRaytraceSpacing / distance));
                int subConeCount = (int)(halfAngle / subConeStep);
                double subConeAngle = subConeStep = halfAngle / (double)subConeCount;
                Vec3d pitchYaw = Vec3d.func_189986_a((float)0.0f, (float)(yaw + 90.0f));
                Quaternion qPitchAxis = new Quaternion((float)pitchYaw.field_72450_a, (float)pitchYaw.field_72448_b, (float)pitchYaw.field_72449_c, 0.0f);
                pitchYaw = Vec3d.func_189986_a((float)pitch, (float)yaw);
                Quaternion qPitchYaw = new Quaternion((float)pitchYaw.field_72450_a, (float)pitchYaw.field_72448_b, (float)pitchYaw.field_72449_c, 0.0f);
                boolean stop = false;
                for (int cone = 0; cone < subConeCount; ++cone) {
                    double radius = distance * MCTools.TRIG_TABLE.sin(Tools.degtorad(subConeAngle));
                    double rollStep = Math.PI * radius * 2.0 / distributedRaytraceSpacing;
                    int thetaStepCount = Tools.max((int)rollStep + 1, 4);
                    double roll = rollStep = Math.PI * 2 / (double)thetaStepCount;
                    Quaternion theta0 = MCTools.rotatedQuaternion(qPitchYaw, qPitchAxis, Tools.degtorad(subConeAngle));
                    for (int thetaStepI = 0; thetaStepI < thetaStepCount; ++thetaStepI) {
                        Quaternion qRotated = MCTools.rotatedQuaternion(theta0, qPitchYaw, roll);
                        qRotated.scale((float)distance);
                        Vec3d pos = new Vec3d((double)qRotated.x, (double)qRotated.y, (double)qRotated.z).func_178787_e(origin);
                        if (ImprovedRayTracing.entityPenetration(target, origin, pos, true) > 0.0) {
                            queue.add(target, squareDist);
                            stop = true;
                            break;
                        }
                        roll += rollStep;
                    }
                    if (stop) continue block1;
                    subConeAngle += subConeStep;
                }
            }
        }
        ArrayList<Entity> result = new ArrayList<Entity>();
        Collections.addAll(result, queue.toArray(new Entity[0]));
        return result;
    }

    static {
        INLUSION_MODES.put(0, "Entity Position");
        INLUSION_MODES.put(1, "Geometric Center");
        INLUSION_MODES.put(2, "Any Rectangular Prism Point");
        INLUSION_MODES.put(3, "Full Rectangular Prism");
        INLUSION_MODES.put(4, "Any Cylinder Point");
        INLUSION_MODES.put(5, "Full Cylinder");
    }
}

