/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.fantasticsource.fantasticlib.Compat;
import com.fantasticsource.mctools.Slottings;
import com.fantasticsource.mctools.aw.RenderModes;
import com.fantasticsource.tiamatinventory.api.ITiamatPlayerInventory;
import com.fantasticsource.tiamatinventory.api.TiamatInventoryAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.ArmourersWorkshopApi;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinTypeRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GlobalInventory {
    public static ISkinTypeRegistry skinTypeRegistry = ArmourersWorkshopApi.skinTypeRegistry;

    public static ArrayList<ItemStack> getAllItems(Entity entity) {
        ArrayList<ItemStack> result = GlobalInventory.getAllNonSkinItems(entity);
        result.addAll(GlobalInventory.getAWSkins(entity));
        return result;
    }

    public static ArrayList<ItemStack> getAllNonSkinItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            result.add(stack);
        }
        result.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        result.addAll(GlobalInventory.getVanillaArmorItems(entity));
        result.addAll(GlobalInventory.getVanillaOtherInventoryItems(entity));
        result.addAll(GlobalInventory.getBaubles(entity));
        ITiamatPlayerInventory inventory = GlobalInventory.getTiamatInventory(entity);
        if (inventory != null) {
            result.addAll(inventory.getAllItems());
        }
        return result;
    }

    public static ArrayList<ItemStack> getAllEquippedItems(Entity entity) {
        ArrayList<ItemStack> result = GlobalInventory.getAllEquippedNonSkinItems(entity);
        result.addAll(GlobalInventory.getAWSkins(entity));
        return result;
    }

    public static ArrayList<ItemStack> getAllEquippedNonSkinItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ITiamatPlayerInventory tiamatInventory = GlobalInventory.getTiamatInventory(entity);
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            result.add(stack);
        }
        result.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        result.addAll(GlobalInventory.getVanillaArmorItems(entity));
        result.addAll(GlobalInventory.getBaubles(entity));
        tiamatInventory = GlobalInventory.getTiamatInventory(entity);
        if (tiamatInventory != null) {
            result.addAll(tiamatInventory.getAllEquippedItems());
        }
        return result;
    }

    public static LinkedHashMap<String, ArrayList<ItemStack>> getAllItemsCategorized(Entity entity) {
        ITiamatPlayerInventory inventory;
        LinkedHashMap<String, ArrayList<ItemStack>> result = new LinkedHashMap<String, ArrayList<ItemStack>>();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            list.add(stack);
            result.put("Vanilla Mainhand", list);
            list = new ArrayList();
        }
        list.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        if (list.size() > 0) {
            result.put("Vanilla Offhands", list);
            list = new ArrayList();
        }
        list.addAll(GlobalInventory.getVanillaArmorItems(entity));
        if (list.size() > 0) {
            result.put("Vanilla Armor", list);
            list = new ArrayList();
        }
        list.addAll(GlobalInventory.getVanillaOtherInventoryItems(entity));
        if (list.size() > 0) {
            result.put("Vanilla Other Inventory", list);
            list = new ArrayList();
        }
        list.addAll(GlobalInventory.getBaubles(entity));
        if (list.size() > 0) {
            result.put("Baubles Inventory", list);
            list = new ArrayList();
        }
        if ((inventory = GlobalInventory.getTiamatInventory(entity)) != null) {
            stack = GlobalInventory.getTiamatSheathedMainhand1(inventory);
            if (stack != null) {
                list.add(stack);
                result.put("Tiamat Sheathed Mainhand 1", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatSheathedOffhand1(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Sheathed Offhand 1", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatSheathedMainhand2(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Sheathed Mainhand 2", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatSheathedOffhand2(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Sheathed Offhand 2", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatArmor(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Armor", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatQuickslots(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Quickslots", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatBackpack(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Backpack", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatPet(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Pet", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatDeck(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Deck", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatClasses(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Classes", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatOffensiveSkills(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Offensive Skills", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatUtilitySkills(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Utility Skills", list);
                list = new ArrayList();
            }
            if ((stack = GlobalInventory.getTiamatUltimateSkill(inventory)) != null) {
                list.add(stack);
                result.put("Tiamat Ultimate Skill", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatPassiveSkills(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Passive Skills", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatGatheringProfessions(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Gathering Professions", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatCraftingProfessions(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Crafting Professions", list);
                list = new ArrayList();
            }
            list.addAll(GlobalInventory.getTiamatRecipes(inventory));
            if (list.size() > 0) {
                result.put("Tiamat Recipes", list);
                list = new ArrayList();
            }
        }
        list.addAll(GlobalInventory.getAWSkins(entity));
        if (list.size() > 0) {
            result.put("Armourer's Workshop Skins", list);
            list = new ArrayList();
        }
        return result;
    }

    public static ArrayList<ItemStack> getValidEquippedItems(EntityPlayer player) {
        int slot;
        ArrayList<ItemStack> result = GlobalInventory.getAllEquippedNonSkinItems((Entity)player);
        for (slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (!Slottings.slotValidForSlotting(GlobalInventory.getItemSlotting(stack), slot, player)) continue;
            result.add(stack);
        }
        if (Compat.baubles) {
            IBaublesItemHandler inventory = BaublesApi.getBaublesHandler(player);
            for (int slot2 = 0; slot2 < inventory.getSlots(); ++slot2) {
                ItemStack stack = inventory.getStackInSlot(slot2);
                if (!Slottings.slotValidForSlotting(GlobalInventory.getItemSlotting(stack), slot2 + Integer.MIN_VALUE, player)) continue;
                result.add(stack);
            }
        }
        if (Compat.tiamatinventory) {
            slot = 0;
            for (ItemStack stack : GlobalInventory.getAllTiamatItems((Entity)player)) {
                if (!Slottings.slotValidForSlotting(GlobalInventory.getItemSlotting(stack), slot + -500, player)) continue;
                result.add(stack);
            }
        }
        return result;
    }

    public static String getItemSlotting(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return "None";
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("tiamatinventory")) {
            return "None";
        }
        if (!(compound = compound.func_74775_l("tiamatinventory")).func_74764_b("slotting")) {
            return "None";
        }
        return compound.func_74779_i("slotting");
    }

    public static ItemStack getVanillaMainhandItem(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            return ((EntityLivingBase)entity).func_184614_ca();
        }
        Iterator iterator = entity.func_184214_aD().iterator();
        if (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            return stack;
        }
        return null;
    }

    public static void setVanillaMainhandItem(Entity entity, ItemStack stack) {
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
    }

    public static ArrayList<ItemStack> getVanillaOffhandItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack mainhand = GlobalInventory.getVanillaMainhandItem(entity);
        for (ItemStack stack : entity.func_184214_aD()) {
            if (stack == mainhand || result.contains(stack)) continue;
            result.add(stack);
        }
        return result;
    }

    public static void setVanillaOffhandItem(Entity entity, ItemStack stack) {
        entity.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
    }

    public static ArrayList<ItemStack> getVanillaArmorItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : entity.func_184193_aE()) {
            if (result.contains(stack)) continue;
            result.add(stack);
        }
        return result;
    }

    public static ItemStack getVanillaHeadItem(Entity entity) {
        ArrayList<ItemStack> armor = GlobalInventory.getVanillaArmorItems(entity);
        if (armor == null || armor.size() != 4) {
            return null;
        }
        return armor.get(EntityEquipmentSlot.HEAD.func_188454_b());
    }

    public static void setVanillaHeadItem(Entity entity, ItemStack stack) {
        entity.func_184201_a(EntityEquipmentSlot.HEAD, stack);
    }

    public static ItemStack getVanillaChestItem(Entity entity) {
        ArrayList<ItemStack> armor = GlobalInventory.getVanillaArmorItems(entity);
        if (armor == null || armor.size() != 4) {
            return null;
        }
        return armor.get(EntityEquipmentSlot.CHEST.func_188454_b());
    }

    public static void setVanillaChestItem(Entity entity, ItemStack stack) {
        entity.func_184201_a(EntityEquipmentSlot.CHEST, stack);
    }

    public static ItemStack getVanillaLegItem(Entity entity) {
        ArrayList<ItemStack> armor = GlobalInventory.getVanillaArmorItems(entity);
        if (armor == null || armor.size() != 4) {
            return null;
        }
        return armor.get(EntityEquipmentSlot.LEGS.func_188454_b());
    }

    public static void setVanillaLegItem(Entity entity, ItemStack stack) {
        entity.func_184201_a(EntityEquipmentSlot.LEGS, stack);
    }

    public static ItemStack getVanillaFootItem(Entity entity) {
        ArrayList<ItemStack> armor = GlobalInventory.getVanillaArmorItems(entity);
        if (armor == null || armor.size() != 4) {
            return null;
        }
        return armor.get(EntityEquipmentSlot.FEET.func_188454_b());
    }

    public static void setVanillaFootItem(Entity entity, ItemStack stack) {
        entity.func_184201_a(EntityEquipmentSlot.FEET, stack);
    }

    public static ArrayList<ItemStack> getVanillaOtherInventoryItems(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!(entity instanceof EntityPlayer)) {
            return result;
        }
        ArrayList<ItemStack> ignore = new ArrayList<ItemStack>();
        ItemStack stack = GlobalInventory.getVanillaMainhandItem(entity);
        if (stack != null) {
            ignore.add(stack);
        }
        ignore.addAll(GlobalInventory.getVanillaOffhandItems(entity));
        ignore.addAll(GlobalInventory.getVanillaArmorItems(entity));
        InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stack = inventory.func_70301_a(i);
            if (result.contains(stack) || ignore.contains(stack)) continue;
            result.add(stack);
        }
        return result;
    }

    public static ArrayList<ItemStack> getBaubles(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!Compat.baubles || !(entity instanceof EntityPlayer)) {
            return result;
        }
        IBaublesItemHandler inventory = BaublesApi.getBaublesHandler((EntityPlayer)entity);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            result.add(inventory.getStackInSlot(i));
        }
        return result;
    }

    public static ITiamatPlayerInventory getTiamatInventory(Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return null;
        }
        return TiamatInventoryAPI.getTiamatPlayerInventory((EntityPlayer)entity);
    }

    public static ItemStack getTiamatSheathedMainhand1(Entity entity) {
        return GlobalInventory.getTiamatSheathedMainhand1(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatSheathedMainhand1(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getSheathedMainhand1();
    }

    public static void setTiamatSheathedMainhand1(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setSheathedMainhand1(stack);
        }
    }

    public static ItemStack getTiamatSheathedOffhand1(Entity entity) {
        return GlobalInventory.getTiamatSheathedOffhand1(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatSheathedOffhand1(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getSheathedOffhand1();
    }

    public static void setTiamatSheathedOffhand1(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setSheathedOffhand1(stack);
        }
    }

    public static ItemStack getTiamatSheathedMainhand2(Entity entity) {
        return GlobalInventory.getTiamatSheathedMainhand2(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatSheathedMainhand2(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getSheathedMainhand2();
    }

    public static void setTiamatSheathedMainhand2(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setSheathedMainhand2(stack);
        }
    }

    public static ItemStack getTiamatSheathedOffhand2(Entity entity) {
        return GlobalInventory.getTiamatSheathedOffhand2(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatSheathedOffhand2(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getSheathedOffhand2();
    }

    public static void setTiamatSheathedOffhand2(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setSheathedOffhand2(stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatArmor(Entity entity) {
        return GlobalInventory.getTiamatArmor(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatArmor(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getTiamatArmor());
    }

    public static ItemStack getTiamatShoulderItem(Entity entity) {
        return GlobalInventory.getTiamatShoulderItem(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatShoulderItem(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getTiamatArmor().get(0);
    }

    public static void setTiamatShoulderItem(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setShoulders(stack);
        }
    }

    public static ItemStack getTiamatCapeItem(Entity entity) {
        return GlobalInventory.getTiamatCapeItem(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatCapeItem(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getTiamatArmor().get(1);
    }

    public static void setTiamatCapeItem(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setCape(stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatQuickslots(Entity entity) {
        return GlobalInventory.getTiamatQuickslots(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatQuickslots(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getQuickSlots());
    }

    public static void setTiamatQuickslot(Entity entity, int index, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setQuickSlot(index, stack);
        }
    }

    public static ItemStack getTiamatBackpack(Entity entity) {
        return GlobalInventory.getTiamatBackpack(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatBackpack(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getBackpack();
    }

    public static void setTiamatBackpack(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setBackpack(stack);
        }
    }

    public static ItemStack getTiamatPet(Entity entity) {
        return GlobalInventory.getTiamatPet(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatPet(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getPet();
    }

    public static void setTiamatPet(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setPet(stack);
        }
    }

    public static ItemStack getTiamatDeck(Entity entity) {
        return GlobalInventory.getTiamatDeck(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatDeck(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getDeck();
    }

    public static void setTiamatDeck(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setDeck(stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatClasses(Entity entity) {
        return GlobalInventory.getTiamatClasses(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatClasses(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getPlayerClasses());
    }

    public static void setTiamatClass(Entity entity, int index, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setPlayerClass(index, stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatOffensiveSkills(Entity entity) {
        return GlobalInventory.getTiamatOffensiveSkills(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatOffensiveSkills(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getOffensiveSkills());
    }

    public static void setTiamatOffensiveSkill(Entity entity, int index, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setOffensiveSkill(index, stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatUtilitySkills(Entity entity) {
        return GlobalInventory.getTiamatUtilitySkills(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatUtilitySkills(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getUtilitySkills());
    }

    public static void setTiamatUtilitySkill(Entity entity, int index, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setUtilitySkill(index, stack);
        }
    }

    public static ItemStack getTiamatUltimateSkill(Entity entity) {
        return GlobalInventory.getTiamatUltimateSkill(GlobalInventory.getTiamatInventory(entity));
    }

    public static ItemStack getTiamatUltimateSkill(ITiamatPlayerInventory inventory) {
        return inventory == null ? null : inventory.getUltimateSkill();
    }

    public static void setTiamatUltimateSkill(Entity entity, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setUltimateSkill(stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatPassiveSkills(Entity entity) {
        return GlobalInventory.getTiamatPassiveSkills(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatPassiveSkills(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getPassiveSkills());
    }

    public static void setTiamatPassiveSkill(Entity entity, int index, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setPassiveSkill(index, stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatGatheringProfessions(Entity entity) {
        return GlobalInventory.getTiamatGatheringProfessions(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatGatheringProfessions(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getGatheringProfessions());
    }

    public static void setTiamatGatheringProfession(Entity entity, int index, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setGatheringProfession(index, stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatCraftingProfessions(Entity entity) {
        return GlobalInventory.getTiamatCraftingProfessions(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatCraftingProfessions(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getCraftingProfessions());
    }

    public static void setTiamatCraftingProfession(Entity entity, int index, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setCraftingProfession(index, stack);
        }
    }

    public static ArrayList<ItemStack> getTiamatRecipes(Entity entity) {
        return GlobalInventory.getTiamatRecipes(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getTiamatRecipes(ITiamatPlayerInventory inventory) {
        return inventory == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(inventory.getCraftingRecipes());
    }

    public static void setTiamatRecipe(Entity entity, int index, ItemStack stack) {
        ITiamatPlayerInventory inv = GlobalInventory.getTiamatInventory(entity);
        if (inv != null) {
            inv.setCraftingRecipe(index, stack);
        }
    }

    public static ArrayList<ItemStack> getAllTiamatItems(Entity entity) {
        return GlobalInventory.getAllTiamatItems(GlobalInventory.getTiamatInventory(entity));
    }

    public static ArrayList<ItemStack> getAllTiamatItems(ITiamatPlayerInventory inventory) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (inventory == null) {
            return result;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            result.add(inventory.func_70301_a(i));
        }
        return result;
    }

    public static ISkinType getSkinType(String skinTypeName) {
        if (skinTypeRegistry == null) {
            return null;
        }
        return skinTypeRegistry.getSkinTypeFromRegistryName(skinTypeName);
    }

    public static int getAWSkinSlotCount(Entity entity, String skinTypeName) {
        return GlobalInventory.getAWSkinSlotCount(entity, GlobalInventory.getSkinType(skinTypeName));
    }

    public static int getAWSkinSlotCount(Entity entity, ISkinType skinType) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return 0;
        }
        return wardrobeSkinHandler.getSlotCountForSkinType(skinType);
    }

    public static ItemStack getAWSkin(Entity entity, String skinTypeName, int index) {
        return GlobalInventory.getAWSkin(entity, GlobalInventory.getSkinType(skinTypeName), index);
    }

    public static ItemStack getAWSkin(Entity entity, ISkinType skinType, int index) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return null;
        }
        return wardrobeSkinHandler.getSkinStack(skinType, index);
    }

    public static ArrayList<ItemStack> getAWSkinsOfType(Entity entity, String skinTypeName) {
        return GlobalInventory.getAWSkinsOfType(entity, GlobalInventory.getSkinType(skinTypeName));
    }

    public static ArrayList<ItemStack> getAWSkinsOfType(Entity entity, ISkinType skinType) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int size = GlobalInventory.getAWSkinSlotCount(entity, skinType);
        for (int i = 0; i < size; ++i) {
            result.add(GlobalInventory.getAWSkin(entity, skinType, i));
        }
        return result;
    }

    public static ArrayList<ItemStack> getAWSkins(Entity entity) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return result;
        }
        for (ISkinType skinTypeObject : wardrobeSkinHandler.getValidSkinTypes()) {
            result.addAll(GlobalInventory.getAWSkinsOfType(entity, skinTypeObject));
        }
        return result;
    }

    public static ItemStack setAWSkin(Entity entity, String skinTypeName, int index, ItemStack newSkin) {
        return GlobalInventory.setAWSkin(entity, GlobalInventory.getSkinType(skinTypeName), index, newSkin);
    }

    public static ItemStack setAWSkin(Entity entity, ISkinType skinType, int index, ItemStack newSkin) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return null;
        }
        ItemStack result = wardrobeSkinHandler.setSkinStack(skinType, index, newSkin);
        RenderModes.refresh(entity);
        return result;
    }

    public static ISkinType[] getValidSkinTypes(Entity entity) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return null;
        }
        return wardrobeSkinHandler.getValidSkinTypes();
    }

    public static ArrayList<String> getValidSkinTypeNames(Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        for (ISkinType skinTypeObject : GlobalInventory.getValidSkinTypes(entity)) {
            result.add(skinTypeObject.getName());
        }
        return result;
    }

    public static void syncAWWardrobeSkins(Entity entity, boolean syncToSelf, boolean syncToOthers) {
        IEntitySkinCapability wardrobeSkinHandler = ArmourersWorkshopApi.getEntitySkinCapability(entity);
        if (wardrobeSkinHandler == null) {
            return;
        }
        if (syncToSelf && entity instanceof EntityPlayerMP) {
            wardrobeSkinHandler.syncToPlayer((EntityPlayerMP)entity);
        }
        if (syncToOthers) {
            wardrobeSkinHandler.syncToAllTracking();
        }
    }

    public static ItemStack getItem(Entity entity, String slot) {
        if ((slot = slot.toLowerCase()).contains("bauble")) {
            try {
                return GlobalInventory.getBaubles(entity).get(Integer.parseInt(slot.replace("bauble", "")) - 1);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        switch (slot) {
            case "mainhand": {
                return GlobalInventory.getVanillaMainhandItem(entity);
            }
            case "offhand": {
                return GlobalInventory.getVanillaOffhandItems(entity).get(0);
            }
            case "head": {
                return GlobalInventory.getVanillaHeadItem(entity);
            }
            case "chest": {
                return GlobalInventory.getVanillaChestItem(entity);
            }
            case "leg": {
                return GlobalInventory.getVanillaLegItem(entity);
            }
            case "feet": {
                return GlobalInventory.getVanillaFootItem(entity);
            }
            case "hotbar1": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(0);
                }
                return null;
            }
            case "hotbar2": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(1);
                }
                return null;
            }
            case "hotbar3": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(2);
                }
                return null;
            }
            case "hotbar4": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(3);
                }
                return null;
            }
            case "hotbar5": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(4);
                }
                return null;
            }
            case "hotbar6": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(5);
                }
                return null;
            }
            case "hotbar7": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(6);
                }
                return null;
            }
            case "hotbar8": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(7);
                }
                return null;
            }
            case "hotbar9": {
                if (entity instanceof EntityPlayer) {
                    return ((EntityPlayer)entity).field_71071_by.func_70301_a(8);
                }
                return null;
            }
            case "mainhand1": {
                return GlobalInventory.getTiamatSheathedMainhand1(entity);
            }
            case "offhand1": {
                return GlobalInventory.getTiamatSheathedOffhand1(entity);
            }
            case "mainhand2": {
                return GlobalInventory.getTiamatSheathedMainhand2(entity);
            }
            case "offhand2": {
                return GlobalInventory.getTiamatSheathedOffhand2(entity);
            }
            case "shoulder": {
                return GlobalInventory.getTiamatShoulderItem(entity);
            }
            case "cape": {
                return GlobalInventory.getTiamatCapeItem(entity);
            }
            case "quickslot1": {
                return GlobalInventory.getTiamatQuickslots(entity).get(0);
            }
            case "quickslot2": {
                return GlobalInventory.getTiamatQuickslots(entity).get(1);
            }
            case "quickslot3": {
                return GlobalInventory.getTiamatQuickslots(entity).get(2);
            }
            case "backpack": {
                return GlobalInventory.getTiamatBackpack(entity);
            }
            case "pet": {
                return GlobalInventory.getTiamatPet(entity);
            }
            case "deck": {
                return GlobalInventory.getTiamatDeck(entity);
            }
            case "class1": {
                return GlobalInventory.getTiamatClasses(entity).get(0);
            }
            case "class2": {
                return GlobalInventory.getTiamatClasses(entity).get(1);
            }
            case "offensive1": {
                return GlobalInventory.getTiamatOffensiveSkills(entity).get(0);
            }
            case "offensive2": {
                return GlobalInventory.getTiamatOffensiveSkills(entity).get(1);
            }
            case "utility1": {
                return GlobalInventory.getTiamatUtilitySkills(entity).get(0);
            }
            case "utility2": {
                return GlobalInventory.getTiamatUtilitySkills(entity).get(1);
            }
            case "ultimate": {
                return GlobalInventory.getTiamatUltimateSkill(entity);
            }
            case "passive1": {
                return GlobalInventory.getTiamatPassiveSkills(entity).get(0);
            }
            case "passive2": {
                return GlobalInventory.getTiamatPassiveSkills(entity).get(1);
            }
            case "gathering1": {
                return GlobalInventory.getTiamatGatheringProfessions(entity).get(0);
            }
            case "gathering2": {
                return GlobalInventory.getTiamatGatheringProfessions(entity).get(1);
            }
            case "crafting1": {
                return GlobalInventory.getTiamatCraftingProfessions(entity).get(0);
            }
            case "crafting2": {
                return GlobalInventory.getTiamatCraftingProfessions(entity).get(1);
            }
            case "recipe1": {
                return GlobalInventory.getTiamatRecipes(entity).get(0);
            }
            case "recipe2": {
                return GlobalInventory.getTiamatRecipes(entity).get(1);
            }
            case "recipe3": {
                return GlobalInventory.getTiamatRecipes(entity).get(2);
            }
            case "recipe4": {
                return GlobalInventory.getTiamatRecipes(entity).get(3);
            }
            case "recipe5": {
                return GlobalInventory.getTiamatRecipes(entity).get(4);
            }
            case "recipe6": {
                return GlobalInventory.getTiamatRecipes(entity).get(5);
            }
            case "recipe7": {
                return GlobalInventory.getTiamatRecipes(entity).get(6);
            }
            case "recipe8": {
                return GlobalInventory.getTiamatRecipes(entity).get(7);
            }
            case "recipe9": {
                return GlobalInventory.getTiamatRecipes(entity).get(8);
            }
            case "recipe10": {
                return GlobalInventory.getTiamatRecipes(entity).get(9);
            }
            case "recipe11": {
                return GlobalInventory.getTiamatRecipes(entity).get(10);
            }
            case "recipe12": {
                return GlobalInventory.getTiamatRecipes(entity).get(11);
            }
            case "recipe13": {
                return GlobalInventory.getTiamatRecipes(entity).get(12);
            }
            case "recipe14": {
                return GlobalInventory.getTiamatRecipes(entity).get(13);
            }
            case "recipe15": {
                return GlobalInventory.getTiamatRecipes(entity).get(14);
            }
        }
        return null;
    }
}

