/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.fantasticlib.Compat;
import com.fantasticsource.tools.Tools;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ImprovedRayTracing {
    private static final int ITERATION_WARNING_THRESHOLD = 200;
    private static long lastWarning = -1L;
    private static int errorCount = 0;

    public static double entityPenetration(Entity fromEyesOf, double maxDistance, Entity target, boolean collideOnAllSolids) {
        if (fromEyesOf.field_70170_p != target.field_70170_p) {
            return Double.NaN;
        }
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.entityPenetration(target, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)), collideOnAllSolids);
    }

    public static double entityPenetration(Entity target, Vec3d vecStart, Vec3d vecEnd, double maxDistance, boolean collideOnAllSolids) {
        return ImprovedRayTracing.entityPenetration(target, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)), collideOnAllSolids);
    }

    public static double entityPenetration(Entity target, Vec3d vecStart, Vec3d vecEnd, boolean collideOnAllSolids) {
        RayTraceResult entityEnd = ImprovedRayTracing.rayTraceEntity(target, vecEnd, vecStart);
        if (entityEnd == null || entityEnd.field_72313_a == RayTraceResult.Type.MISS) {
            return Double.NaN;
        }
        RayTraceResult entityStart = ImprovedRayTracing.rayTraceEntity(target, vecStart, vecEnd);
        RayTraceResult blockHit = ImprovedRayTracing.rayTraceBlocks(target.field_70170_p, vecStart, entityEnd.field_72307_f, collideOnAllSolids);
        if (blockHit.field_72313_a == RayTraceResult.Type.MISS) {
            return entityStart.field_72307_f.func_72438_d(entityEnd.field_72307_f);
        }
        if (blockHit.field_72307_f == null) {
            return -vecStart.func_72438_d(entityStart.field_72307_f);
        }
        return vecStart.func_72438_d(blockHit.field_72307_f) - vecStart.func_72438_d(entityStart.field_72307_f);
    }

    public static RayTraceResult rayTraceEntity(Entity fromEyesOf, double maxDistance, Entity target) {
        if (fromEyesOf.field_70170_p != target.field_70170_p) {
            return null;
        }
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.rayTraceEntity(target, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)));
    }

    public static RayTraceResult rayTraceEntity(Entity target, Vec3d vecStart, Vec3d vecEnd, double maxDistance) {
        return ImprovedRayTracing.rayTraceEntity(target, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)));
    }

    public static RayTraceResult rayTraceEntity(Entity target, Vec3d vecStart, Vec3d vecEnd) {
        return target.func_174813_aQ().func_72327_a(vecStart, vecEnd);
    }

    public static boolean isUnobstructed(Entity fromEyesOf, double maxDistance, boolean collideOnAllSolids) {
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.isUnobstructed(fromEyesOf.field_70170_p, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)), collideOnAllSolids);
    }

    public static boolean isUnobstructed(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, boolean collideOnAllSolids) {
        return ImprovedRayTracing.isUnobstructed(world, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)), collideOnAllSolids);
    }

    public static boolean isUnobstructed(World world, Vec3d vecStart, Vec3d vecEnd, boolean collideOnAllSolids) {
        return ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)vecStart, (Vec3d)vecEnd, (boolean)collideOnAllSolids).field_72313_a == RayTraceResult.Type.MISS;
    }

    @Nonnull
    public static BlockPos[] blocksInRay(Entity fromEyesOf, double maxDistance, boolean collideOnAllSolids) {
        return ImprovedRayTracing.blocksInRay(fromEyesOf, maxDistance, 200, collideOnAllSolids);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(Entity fromEyesOf, double maxDistance, int maxBlocks, boolean collideOnAllSolids) {
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.blocksInRay(fromEyesOf.field_70170_p, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)), maxBlocks, collideOnAllSolids);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, boolean collideOnAllSolids) {
        return ImprovedRayTracing.blocksInRay(world, vecStart, vecEnd, maxDistance, 200, collideOnAllSolids);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, int maxBlocks, boolean collideOnAllSolids) {
        return ImprovedRayTracing.blocksInRay(world, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)), maxBlocks, collideOnAllSolids);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(World world, Vec3d vecStart, Vec3d vecEnd, boolean collideOnAllSolids) {
        return ImprovedRayTracing.blocksInRay(world, vecStart, vecEnd, 200, collideOnAllSolids);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(World world, Vec3d vecStart, Vec3d vecEnd, int maxBlocks, boolean collideOnAllSolids) {
        int nextZStop;
        int nextYStop;
        int nextXStop;
        int yDir;
        int xDir;
        RayTraceResult result;
        world.field_72984_F.func_76320_a("Fantastic Lib: Blocks In Ray");
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        BlockPos pos = new BlockPos(vecStart);
        BlockPos endPos = new BlockPos(vecEnd);
        if (vecEnd.field_72450_a > vecStart.field_72450_a && vecEnd.field_72450_a == (double)((int)vecEnd.field_72450_a)) {
            endPos = new BlockPos(endPos.func_177958_n() - 1, endPos.func_177956_o(), endPos.func_177952_p());
        }
        if (vecEnd.field_72448_b > vecStart.field_72448_b && vecEnd.field_72448_b == (double)((int)vecEnd.field_72448_b)) {
            endPos = new BlockPos(endPos.func_177958_n(), endPos.func_177956_o() - 1, endPos.func_177952_p());
        }
        if (vecEnd.field_72449_c > vecStart.field_72449_c && vecEnd.field_72449_c == (double)((int)vecEnd.field_72449_c)) {
            endPos = new BlockPos(endPos.func_177958_n(), endPos.func_177956_o(), endPos.func_177952_p() - 1);
        }
        if (!world.func_175667_e(pos)) {
            world.field_72984_F.func_76319_b();
            return new BlockPos[0];
        }
        IBlockState state = world.func_180495_p(pos);
        if ((collideOnAllSolids || !ImprovedRayTracing.canSeeThrough(state)) && state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k && (result = state.func_185910_a(world, pos, vecStart, vecEnd)) != null) {
            world.field_72984_F.func_76319_b();
            return new BlockPos[]{pos};
        }
        blocks.add(pos);
        if (pos.func_177958_n() == endPos.func_177958_n() && pos.func_177956_o() == endPos.func_177956_o() && pos.func_177952_p() == endPos.func_177952_p()) {
            world.field_72984_F.func_76319_b();
            return blocks.toArray(new BlockPos[0]);
        }
        double xStart = vecStart.field_72450_a;
        double yStart = vecStart.field_72448_b;
        double zStart = vecStart.field_72449_c;
        double xRange = vecEnd.field_72450_a - xStart;
        double yRange = vecEnd.field_72448_b - yStart;
        double zRange = vecEnd.field_72449_c - zStart;
        int n = xRange > 0.0 ? 1 : (xDir = xRange < 0.0 ? -1 : 0);
        int n2 = yRange > 0.0 ? 1 : (yDir = yRange < 0.0 ? -1 : 0);
        int zDir = zRange > 0.0 ? 1 : (zRange < 0.0 ? -1 : 0);
        double xInverseRange = xDir == 0 ? Double.NaN : 1.0 / xRange;
        double yInverseRange = yDir == 0 ? Double.NaN : 1.0 / yRange;
        double zInverseRange = zDir == 0 ? Double.NaN : 1.0 / zRange;
        int n3 = nextXStop = xDir == 0 ? Integer.MAX_VALUE : pos.func_177958_n();
        if (xDir == 1) {
            ++nextXStop;
        }
        int n4 = nextYStop = yDir == 0 ? Integer.MAX_VALUE : pos.func_177956_o();
        if (yDir == 1) {
            ++nextYStop;
        }
        int n5 = nextZStop = zDir == 0 ? Integer.MAX_VALUE : pos.func_177952_p();
        if (zDir == 1) {
            ++nextZStop;
        }
        double normalizedXDistToStop = 7777777.0;
        double normalizedYDistToStop = 7777777.0;
        for (int i = 1; i <= maxBlocks; ++i) {
            double zDistToStop;
            double normalizedZDistToStop;
            double yDistToStop;
            int mininumNormalizedDistance = 0;
            if (xDir != 0) {
                double xDistToStop = (double)nextXStop - xStart;
                normalizedXDistToStop = xDistToStop * xInverseRange;
                mininumNormalizedDistance = 1;
            }
            if (yDir != 0 && (normalizedYDistToStop = (yDistToStop = (double)nextYStop - yStart) * yInverseRange) < normalizedXDistToStop) {
                mininumNormalizedDistance = 2;
            }
            if (zDir != 0 && (normalizedZDistToStop = (zDistToStop = (double)nextZStop - zStart) * zInverseRange) < normalizedXDistToStop && normalizedZDistToStop < normalizedYDistToStop) {
                mininumNormalizedDistance = 3;
            }
            if (mininumNormalizedDistance == 1) {
                pos = pos.func_177965_g(xDir);
                nextXStop += xDir;
            } else if (mininumNormalizedDistance == 2) {
                pos = pos.func_177981_b(yDir);
                nextYStop += yDir;
            } else {
                pos = pos.func_177970_e(zDir);
                nextZStop += zDir;
            }
            blocks.add(pos);
            if (!world.func_175667_e(pos)) {
                world.field_72984_F.func_76319_b();
                return blocks.toArray(new BlockPos[0]);
            }
            state = world.func_180495_p(pos);
            if ((collideOnAllSolids || !ImprovedRayTracing.canSeeThrough(state)) && state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k && (result = state.func_185910_a(world, pos, vecStart, vecEnd)) != null) {
                world.field_72984_F.func_76319_b();
                return blocks.toArray(new BlockPos[0]);
            }
            if (pos.func_177958_n() != endPos.func_177958_n() || pos.func_177956_o() != endPos.func_177956_o() || pos.func_177952_p() != endPos.func_177952_p()) continue;
            world.field_72984_F.func_76319_b();
            return blocks.toArray(new BlockPos[0]);
        }
        if (maxBlocks >= 200 && (lastWarning == -1L || System.currentTimeMillis() - lastWarning > 300000L)) {
            System.err.println("WARNING: BEYOND-LIMIT RAYTRACING DETECTED!  This warning will not show more than once every 5 minutes.  This is usually due to inefficient raytrace calls from another mod");
            System.err.println("This type of error has occurred " + errorCount + " additional times since the last time this message was shown");
            System.err.println("From " + vecStart + " to " + vecEnd + " (distance: " + vecStart.func_72438_d(vecEnd) + ")");
            System.err.println("Limit: " + maxBlocks + " iterations (not synonymous to distance, but longer distances are generally more iterations)");
            System.err.println();
            Tools.printStackTrace();
            lastWarning = System.currentTimeMillis();
        } else {
            ++errorCount;
        }
        world.field_72984_F.func_76319_b();
        return blocks.toArray(new BlockPos[0]);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(Entity fromEyesOf, double maxDistance, boolean collideOnAllSolids) {
        return ImprovedRayTracing.rayTraceBlocks(fromEyesOf, maxDistance, 200, collideOnAllSolids);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(Entity fromEyesOf, double maxDistance, int maxBlocks, boolean collideOnAllSolids) {
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.rayTraceBlocks(fromEyesOf.field_70170_p, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)), maxBlocks, collideOnAllSolids);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, boolean collideOnAllSolids) {
        return ImprovedRayTracing.rayTraceBlocks(world, vecStart, vecEnd, maxDistance, 200, collideOnAllSolids);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, int maxBlocks, boolean collideOnAllSolids) {
        return ImprovedRayTracing.rayTraceBlocks(world, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)), maxBlocks, collideOnAllSolids);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, boolean collideOnAllSolids) {
        return ImprovedRayTracing.rayTraceBlocks(world, vecStart, vecEnd, 200, collideOnAllSolids);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, int maxBlocks, boolean collideOnAllSolids) {
        int nextZStop;
        int nextYStop;
        int nextXStop;
        int yDir;
        int xDir;
        RayTraceResult result;
        world.field_72984_F.func_76320_a("Fantastic Lib: Improved Raytrace");
        BlockPos pos = new BlockPos(vecStart);
        BlockPos endPos = new BlockPos(vecEnd);
        if (vecEnd.field_72450_a > vecStart.field_72450_a && vecEnd.field_72450_a == (double)((int)vecEnd.field_72450_a)) {
            endPos = new BlockPos(endPos.func_177958_n() - 1, endPos.func_177956_o(), endPos.func_177952_p());
        }
        if (vecEnd.field_72448_b > vecStart.field_72448_b && vecEnd.field_72448_b == (double)((int)vecEnd.field_72448_b)) {
            endPos = new BlockPos(endPos.func_177958_n(), endPos.func_177956_o() - 1, endPos.func_177952_p());
        }
        if (vecEnd.field_72449_c > vecStart.field_72449_c && vecEnd.field_72449_c == (double)((int)vecEnd.field_72449_c)) {
            endPos = new BlockPos(endPos.func_177958_n(), endPos.func_177956_o(), endPos.func_177952_p() - 1);
        }
        if (!world.func_175667_e(pos)) {
            world.field_72984_F.func_76319_b();
            return new FixedRayTraceResult(null, null, null, pos);
        }
        IBlockState state = world.func_180495_p(pos);
        if ((collideOnAllSolids || !ImprovedRayTracing.canSeeThrough(state)) && state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k && (result = state.func_185910_a(world, pos, vecStart, vecEnd)) != null) {
            world.field_72984_F.func_76319_b();
            return result;
        }
        if (pos.func_177958_n() == endPos.func_177958_n() && pos.func_177956_o() == endPos.func_177956_o() && pos.func_177952_p() == endPos.func_177952_p()) {
            world.field_72984_F.func_76319_b();
            return new FixedRayTraceResult(RayTraceResult.Type.MISS, vecEnd, null, pos);
        }
        double xStart = vecStart.field_72450_a;
        double yStart = vecStart.field_72448_b;
        double zStart = vecStart.field_72449_c;
        double xRange = vecEnd.field_72450_a - xStart;
        double yRange = vecEnd.field_72448_b - yStart;
        double zRange = vecEnd.field_72449_c - zStart;
        int n = xRange > 0.0 ? 1 : (xDir = xRange < 0.0 ? -1 : 0);
        int n2 = yRange > 0.0 ? 1 : (yDir = yRange < 0.0 ? -1 : 0);
        int zDir = zRange > 0.0 ? 1 : (zRange < 0.0 ? -1 : 0);
        double xInverseRange = xDir == 0 ? Double.NaN : 1.0 / xRange;
        double yInverseRange = yDir == 0 ? Double.NaN : 1.0 / yRange;
        double zInverseRange = zDir == 0 ? Double.NaN : 1.0 / zRange;
        int n3 = nextXStop = xDir == 0 ? Integer.MAX_VALUE : pos.func_177958_n();
        if (xDir == 1) {
            ++nextXStop;
        }
        int n4 = nextYStop = yDir == 0 ? Integer.MAX_VALUE : pos.func_177956_o();
        if (yDir == 1) {
            ++nextYStop;
        }
        int n5 = nextZStop = zDir == 0 ? Integer.MAX_VALUE : pos.func_177952_p();
        if (zDir == 1) {
            ++nextZStop;
        }
        double normalizedXDistToStop = 7777777.0;
        double normalizedYDistToStop = 7777777.0;
        for (int i = 1; i <= maxBlocks; ++i) {
            double zDistToStop;
            double normalizedZDistToStop;
            double yDistToStop;
            int mininumNormalizedDistance = 0;
            if (xDir != 0) {
                double xDistToStop = (double)nextXStop - xStart;
                normalizedXDistToStop = xDistToStop * xInverseRange;
                mininumNormalizedDistance = 1;
            }
            if (yDir != 0 && (normalizedYDistToStop = (yDistToStop = (double)nextYStop - yStart) * yInverseRange) < normalizedXDistToStop) {
                mininumNormalizedDistance = 2;
            }
            if (zDir != 0 && (normalizedZDistToStop = (zDistToStop = (double)nextZStop - zStart) * zInverseRange) < normalizedXDistToStop && normalizedZDistToStop < normalizedYDistToStop) {
                mininumNormalizedDistance = 3;
            }
            if (mininumNormalizedDistance == 1) {
                pos = pos.func_177965_g(xDir);
                nextXStop += xDir;
            } else if (mininumNormalizedDistance == 2) {
                pos = pos.func_177981_b(yDir);
                nextYStop += yDir;
            } else {
                pos = pos.func_177970_e(zDir);
                nextZStop += zDir;
            }
            if (!world.func_175667_e(pos)) {
                world.field_72984_F.func_76319_b();
                return new FixedRayTraceResult(null, null, null, pos);
            }
            state = world.func_180495_p(pos);
            if ((collideOnAllSolids || !ImprovedRayTracing.canSeeThrough(state)) && state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k && (result = state.func_185910_a(world, pos, vecStart, vecEnd)) != null) {
                world.field_72984_F.func_76319_b();
                return result;
            }
            if (pos.func_177958_n() != endPos.func_177958_n() || pos.func_177956_o() != endPos.func_177956_o() || pos.func_177952_p() != endPos.func_177952_p()) continue;
            world.field_72984_F.func_76319_b();
            return new FixedRayTraceResult(RayTraceResult.Type.MISS, vecEnd, null, pos);
        }
        if (maxBlocks >= 200 && (lastWarning == -1L || System.currentTimeMillis() - lastWarning > 300000L)) {
            System.err.println("WARNING: BEYOND-LIMIT RAYTRACING DETECTED!  This warning will not show more than once every 5 minutes.  This is usually due to inefficient raytrace calls from another mod");
            System.err.println("This type of error has occurred " + errorCount + " additional times since the last time this message was shown");
            System.err.println("From " + vecStart + " to " + vecEnd + " (distance: " + vecStart.func_72438_d(vecEnd) + ")");
            System.err.println("Limit: " + maxBlocks + " iterations (not synonymous to distance, but longer distances are generally more iterations)");
            System.err.println();
            Tools.printStackTrace();
            lastWarning = System.currentTimeMillis();
        } else {
            ++errorCount;
        }
        world.field_72984_F.func_76319_b();
        return new FixedRayTraceResult(null, null, null, null);
    }

    public static boolean canSeeThrough(IBlockState blockState) {
        Material material = blockState.func_185904_a();
        if (material == Material.field_151584_j) {
            return true;
        }
        if (material == Material.field_151592_s) {
            return true;
        }
        if (material == Material.field_151588_w) {
            return true;
        }
        if (material == Material.field_151579_a) {
            return true;
        }
        if (material == Material.field_151586_h) {
            return true;
        }
        if (material == Material.field_151581_o) {
            return true;
        }
        if (material == Material.field_151567_E) {
            return !Compat.betterportals;
        }
        if (material == Material.field_175972_I) {
            return true;
        }
        if (material == Material.field_151585_k) {
            return true;
        }
        if (material == Material.field_151569_G) {
            return true;
        }
        if (material == Material.field_151582_l) {
            return true;
        }
        Block block = blockState.func_177230_c();
        if (block instanceof BlockSlime) {
            return true;
        }
        if (block instanceof BlockTrapDoor) {
            return true;
        }
        if (block instanceof BlockFence) {
            return true;
        }
        if (block instanceof BlockFenceGate) {
            return true;
        }
        if (block == Blocks.field_180410_as) {
            return true;
        }
        if (block == Blocks.field_180411_ar) {
            return true;
        }
        if (block == Blocks.field_150411_aY) {
            return true;
        }
        return (block == Blocks.field_180413_ao || block == Blocks.field_150454_av) && (block.func_176201_c(blockState) & 8) != 0;
    }

    public static class FixedRayTraceResult
    extends RayTraceResult {
        public FixedRayTraceResult(RayTraceResult.Type typeIn, Vec3d hitVecIn, EnumFacing sideHitIn, BlockPos blockPosIn) {
            super(typeIn, new Vec3d(0.0, 0.0, 0.0), sideHitIn, blockPosIn);
            this.field_72307_f = hitVecIn == null ? null : new Vec3d(hitVecIn.field_72450_a, hitVecIn.field_72448_b, hitVecIn.field_72449_c);
        }
    }
}

