/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.fantasticlib.FantasticLib;
import com.fantasticsource.mctools.NPEAttackTargetTaskHolder;
import com.fantasticsource.mctools.Network;
import com.fantasticsource.tools.PNG;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import com.fantasticsource.tools.datastructures.ExplicitPriorityQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.Locale;
import net.minecraft.command.CommandResultStats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.NotImplementedException;
import org.lwjgl.util.vector.Quaternion;

public class MCTools {
    public static final TrigLookupTable TRIG_TABLE = new TrigLookupTable(1024);
    private static Field configManagerCONFIGSField;
    private static Field languageManagerCurrentLocaleField;
    private static Field localePropertiesField;
    private static boolean host;

    public static PNG getPNG(ResourceLocation rl) {
        try {
            return PNG.load(Minecraft.func_71410_x().func_110442_L().func_110536_a(rl).func_110527_b());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static GameType getGameType(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)player).field_71134_c.func_73081_b();
        }
        if (player instanceof AbstractClientPlayer) {
            NetworkPlayerInfo info = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_146103_bH().getId());
            if (info == null) {
                return null;
            }
            return info.func_178848_b();
        }
        throw new IllegalArgumentException("Unknown player class: " + player.getClass().getName());
    }

    public static boolean devEnv() {
        return FantasticLib.DEV_ENV;
    }

    public static BufferedReader getJarResourceReader(Class classInJar, String resourcePathAndName) {
        return new BufferedReader(new InputStreamReader(MCTools.getJarResourceStream(classInJar, resourcePathAndName)));
    }

    public static InputStream getJarResourceStream(Class classInJar, String resourcePathAndName) {
        return classInJar.getClassLoader().getResourceAsStream(resourcePathAndName);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getResourcePackDir() {
        return MCTools.getConfigDir() + ".." + File.separator + "resourcepacks" + File.separator;
    }

    public static boolean isWhitelisted(EntityPlayerMP player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return !server.func_71262_S() || server.func_184103_al().func_152599_k().func_152705_a(player.func_146103_bH());
    }

    public static String getSaveFolder(WorldProvider worldProvider) {
        String saveFolder = worldProvider.getSaveFolder();
        return saveFolder != null ? saveFolder : ".";
    }

    public static DimensionType getDimensionType(String name) {
        try {
            return DimensionType.func_193417_a((String)name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static NBTBase removeSubNBTAndClean(NBTTagCompound compound, String ... keys) {
        if (keys.length == 0) {
            return null;
        }
        String key = keys[0];
        if (keys.length == 1) {
            NBTBase result = compound.func_74781_a(key);
            compound.func_82580_o(key);
            return result;
        }
        if (!compound.func_74764_b(key)) {
            return null;
        }
        String[] newKeys = new String[keys.length - 1];
        System.arraycopy(keys, 1, newKeys, 0, newKeys.length);
        NBTTagCompound subCompound = compound.func_74775_l(key);
        NBTBase result = MCTools.removeSubNBTAndClean(subCompound, newKeys);
        if (subCompound.func_150296_c().size() == 0) {
            compound.func_82580_o(key);
        }
        return result;
    }

    public static NBTTagCompound getOrGenerateSubCompound(NBTTagCompound compound, String ... keys) {
        for (String key : keys) {
            if (!compound.func_74764_b(key)) {
                compound.func_74782_a(key, (NBTBase)new NBTTagCompound());
            }
            compound = compound.func_74775_l(key);
        }
        return compound;
    }

    public static NBTTagCompound getSubCompoundIfExists(NBTTagCompound compound, String ... keys) {
        for (String key : keys) {
            if (!compound.func_74764_b(key)) {
                return null;
            }
            compound = compound.func_74775_l(key);
        }
        return compound;
    }

    public static NBTTagCompound combineNBT(NBTTagCompound ... sources) {
        NBTTagCompound result = new NBTTagCompound();
        MCTools.mergeNBT(result, true, sources);
        return result;
    }

    public static void mergeNBT(NBTTagCompound destination, boolean overwrite, NBTTagCompound ... sources) {
        for (NBTTagCompound source : sources) {
            if (source == null) continue;
            for (String key : source.func_150296_c()) {
                NBTBase sourceTag = source.func_74781_a(key);
                NBTBase destinationTag = destination.func_74781_a(key);
                if (destinationTag == null) {
                    destination.func_74782_a(key, sourceTag.func_74737_b());
                    continue;
                }
                if (sourceTag instanceof NBTTagCompound && destinationTag instanceof NBTTagCompound) {
                    MCTools.mergeNBT((NBTTagCompound)destinationTag, overwrite, (NBTTagCompound)sourceTag);
                    continue;
                }
                if (sourceTag instanceof NBTTagList && destinationTag instanceof NBTTagList) {
                    MCTools.mergeNBT((NBTTagList)destinationTag, (NBTTagList)sourceTag);
                    continue;
                }
                if (sourceTag instanceof NBTTagByteArray && destinationTag instanceof NBTTagByteArray) {
                    destination.func_74782_a(key, (NBTBase)MCTools.combineNBT((NBTTagByteArray)destinationTag, (NBTTagByteArray)sourceTag));
                    continue;
                }
                if (sourceTag instanceof NBTTagIntArray && destinationTag instanceof NBTTagIntArray) {
                    destination.func_74782_a(key, (NBTBase)MCTools.combineNBT((NBTTagIntArray)destinationTag, (NBTTagIntArray)sourceTag));
                    continue;
                }
                if (sourceTag instanceof NBTTagLongArray && destinationTag instanceof NBTTagLongArray) {
                    throw new NotImplementedException("Didn't feel like doing the reflection at the time, and not sure this will ever come up.  Poke Laike Endaril if you see this.");
                }
                if (!overwrite) continue;
                destination.func_74782_a(key, sourceTag.func_74737_b());
            }
        }
    }

    public static NBTTagList combineNBT(NBTTagList ... sources) {
        NBTTagList result = new NBTTagList();
        MCTools.mergeNBT(result, sources);
        return result;
    }

    public static void mergeNBT(NBTTagList destination, NBTTagList ... sources) {
        for (NBTTagList source : sources) {
            int size = source.func_74745_c();
            for (int i = 0; i < size; ++i) {
                destination.func_74742_a(source.func_179238_g(i));
            }
        }
    }

    public static NBTTagByteArray combineNBT(NBTTagByteArray ... sources) {
        int size = 0;
        int offset = 0;
        for (NBTTagByteArray source : sources) {
            size += source.func_150292_c().length;
        }
        byte[] newArray = new byte[size];
        for (NBTTagByteArray source : sources) {
            byte[] sArray = source.func_150292_c();
            size = sArray.length;
            System.arraycopy(sArray, 0, newArray, offset, size);
            offset += size;
        }
        return new NBTTagByteArray(newArray);
    }

    public static NBTTagIntArray combineNBT(NBTTagIntArray ... sources) {
        int size = 0;
        int offset = 0;
        for (NBTTagIntArray source : sources) {
            size += source.func_150302_c().length;
        }
        int[] newArray = new int[size];
        for (NBTTagIntArray source : sources) {
            int[] sArray = source.func_150302_c();
            size = sArray.length;
            System.arraycopy(sArray, 0, newArray, offset, size);
            offset += size;
        }
        return new NBTTagIntArray(newArray);
    }

    public static ArrayList<String> legibleNBT(NBTBase nbt) {
        return MCTools.legibleNBT(nbt.toString());
    }

    public static ArrayList<String> legibleNBT(String nbtString) {
        ArrayList<String> result = new ArrayList<String>();
        char[] chars = nbtString.toCharArray();
        StringBuilder current = new StringBuilder();
        StringBuilder indent = new StringBuilder();
        block5: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '[': 
                case '{': {
                    if (!current.toString().equals("")) {
                        result.add(indent + current.toString());
                    }
                    result.add(indent.toString() + c);
                    current = new StringBuilder();
                    indent.append(" ");
                    continue block5;
                }
                case ']': 
                case '}': {
                    if (!current.toString().equals("")) {
                        result.add(indent + current.toString());
                    }
                    indent = new StringBuilder(indent.substring(0, indent.length() - 1));
                    result.add(indent.toString() + c + (i + 1 < chars.length && chars[i + 1] == ',' ? Character.valueOf(',') : ""));
                    current = new StringBuilder();
                    continue block5;
                }
                case ',': {
                    if (!current.toString().equals("")) {
                        result.add(indent + current.toString() + c);
                    }
                    current = new StringBuilder();
                    continue block5;
                }
                default: {
                    current.append(c);
                }
            }
        }
        return result;
    }

    public static ItemStack getItemStack(String itemID) {
        String name;
        String domain = "minecraft";
        int meta = 0;
        String[] tokens = Tools.fixedSplit("" + itemID, ":");
        if (tokens.length == 1) {
            name = tokens[0];
        } else if (tokens.length == 2) {
            try {
                meta = Integer.parseInt(tokens[1]);
                name = tokens[0];
            }
            catch (NumberFormatException e) {
                domain = tokens[0];
                name = tokens[1];
            }
        } else {
            domain = tokens[0];
            name = tokens[1];
            meta = Integer.parseInt(tokens[2]);
        }
        return MCTools.getItemStack(domain, name, meta);
    }

    public static ItemStack getItemStack(String domain, String name, int meta) {
        ResourceLocation rl = new ResourceLocation(domain, name);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (block != null) {
            return new ItemStack(block, 1, meta);
        }
        return null;
    }

    public static ItemStack cloneItemStack(ItemStack stack) {
        try {
            return new ItemStack(JsonToNBT.func_180713_a((String)stack.serializeNBT().toString()));
        }
        catch (NBTException e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public static void give(EntityPlayerMP player, ItemStack stack) {
        int count = stack.func_190916_E();
        boolean flag = player.field_71071_by.func_70441_a(stack);
        if (flag) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.field_71069_bz.func_75142_b();
        }
        if (flag && stack.func_190926_b()) {
            stack.func_190920_e(1);
            player.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, count);
            EntityItem entityitem1 = player.func_71019_a(stack, false);
            if (entityitem1 != null) {
                entityitem1.func_174870_v();
            }
        } else {
            player.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, count - stack.func_190916_E());
            EntityItem entityitem = player.func_71019_a(stack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(player.func_70005_c_());
            }
        }
    }

    public static void setLore(ItemStack stack, String lore) {
        if (lore == null || lore.equals("")) {
            MCTools.removeLore(stack);
            return;
        }
        MCTools.setLore(stack, Arrays.asList(Tools.fixedSplit(lore, "\n")));
    }

    public static void setLore(ItemStack stack, List<String> loreLines) {
        NBTTagCompound compound;
        if (loreLines == null || loreLines.size() == 0 || loreLines.size() == 1 && (loreLines.get(0) == null || loreLines.get(0).equals(""))) {
            MCTools.removeLore(stack);
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("display")) {
            compound.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        compound = compound.func_74775_l("display");
        compound.func_74782_a("Lore", (NBTBase)new NBTTagList());
        NBTTagList lore = compound.func_150295_c("Lore", 8);
        for (String line : loreLines) {
            lore.func_74742_a((NBTBase)new NBTTagString(line));
        }
    }

    public static void removeLore(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("display")) {
            return;
        }
        NBTTagCompound display = compound.func_74775_l("display");
        if (!display.func_74764_b("Lore")) {
            return;
        }
        display.func_82580_o("Lore");
        if (display.func_150296_c().size() == 0) {
            compound.func_82580_o("display");
        }
    }

    public static ArrayList<String> getLore(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("display")) {
            return null;
        }
        if (!(compound = compound.func_74775_l("display")).func_74764_b("Lore")) {
            return null;
        }
        NBTTagList lore = compound.func_150295_c("Lore", 8);
        ArrayList<String> loreLines = new ArrayList<String>();
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            loreLines.add(lore.func_150307_f(i));
        }
        return loreLines;
    }

    public static Quaternion rotatedQuaternion(Quaternion v, Quaternion axis, double theta) {
        double sinThetaDiv2 = TRIG_TABLE.sin(theta * 0.5);
        double cosThetaDiv2 = TRIG_TABLE.cos(theta * 0.5);
        Quaternion q = new Quaternion((float)(sinThetaDiv2 * (double)axis.x), (float)(sinThetaDiv2 * (double)axis.y), (float)(sinThetaDiv2 * (double)axis.z), (float)cosThetaDiv2);
        Quaternion qConjugate = new Quaternion((float)(-(sinThetaDiv2 * (double)axis.x)), (float)(-(sinThetaDiv2 * (double)axis.y)), (float)(-(sinThetaDiv2 * (double)axis.z)), (float)cosThetaDiv2);
        return Quaternion.mul((Quaternion)Quaternion.mul((Quaternion)q, (Quaternion)v, null), (Quaternion)qConjugate, null);
    }

    public static void spawnDebugSnowball(World world, double x, double y, double z) {
        EntitySnowball snowball = new EntitySnowball(world, x, y, z);
        snowball.func_70016_h(0.0, 0.0, 0.0);
        snowball.func_189654_d(true);
        world.func_72838_d((Entity)snowball);
    }

    public static double lookAngleDifDeg(EntityLivingBase searcher, Entity target) {
        return MCTools.angleDifDeg(searcher.func_174824_e(0.0f), searcher.field_70759_as, searcher.field_70125_A, target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0));
    }

    public static double angleDifDeg(Vec3d origin, float yaw, float pitch, Vec3d p2) {
        return MCTools.angleDifDeg(origin, origin.func_178787_e(Vec3d.func_189986_a((float)pitch, (float)yaw)), p2);
    }

    public static double angleDifDeg(Vec3d origin, Vec3d p1, Vec3d p2) {
        double angleDif = p1.func_178788_d(origin).func_72432_b().func_72430_b(p2.func_178788_d(origin).func_72432_b());
        if (angleDif < -1.0) {
            angleDif = -1.0;
        } else if (angleDif > 1.0) {
            angleDif = 1.0;
        }
        return Tools.radtodeg(TRIG_TABLE.arccos(angleDif));
    }

    public static void playSimpleSoundOnClient(EntityPlayerMP player, ResourceLocation rl) {
        Network.WRAPPER.sendTo((IMessage)new Network.PlaySimpleSoundPacket(rl), player);
    }

    public static void playSimpleSoundAtEntityPosition(ResourceLocation rl, Entity entity) {
        MCTools.playSimpleSoundAtEntityPosition(rl, entity, 16.0);
    }

    public static void playSimpleSoundAtEntityPosition(ResourceLocation rl, Entity entity, double maxDistance) {
        MCTools.playSimpleSoundAtEntityPosition(rl, entity, maxDistance, 2, 1.0f, 1.0f);
    }

    public static void playSimpleSoundAtEntityPosition(ResourceLocation rl, Entity entity, double maxDistance, int attenuationType, float volume, float pitch) {
        MCTools.playSimpleSoundAtEntityPosition(rl, entity, maxDistance, attenuationType, volume, pitch, SoundCategory.MASTER);
    }

    public static void playSimpleSoundAtEntityPosition(ResourceLocation rl, Entity entity, double maxDistance, int attenuationType, float volume, float pitch, SoundCategory soundCategory) {
        MCTools.playSimpleSoundAtPosition(rl, entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, maxDistance, attenuationType, volume, pitch, soundCategory);
    }

    public static void playSimpleSoundAtPosition(ResourceLocation rl, int dimension, double x, double y, double z) {
        MCTools.playSimpleSoundAtPosition(rl, dimension, x, y, z, 16.0);
    }

    public static void playSimpleSoundAtPosition(ResourceLocation rl, int dimension, double x, double y, double z, double maxDistance) {
        MCTools.playSimpleSoundAtPosition(rl, dimension, x, y, z, maxDistance, 2, 1.0f, 1.0f);
    }

    public static void playSimpleSoundAtPosition(ResourceLocation rl, int dimension, double x, double y, double z, double maxDistance, int attenuationType, float volume, float pitch) {
        MCTools.playSimpleSoundAtPosition(rl, dimension, x, y, z, maxDistance, attenuationType, volume, pitch, SoundCategory.MASTER);
    }

    public static void playSimpleSoundAtPosition(ResourceLocation rl, int dimension, double x, double y, double z, double maxDistance, int attenuationType, float volume, float pitch, SoundCategory soundCategory) {
        Network.WRAPPER.sendToAllAround((IMessage)new Network.PlaySimpleSoundPacket(rl, (float)x, (float)y, (float)z, attenuationType, volume, pitch, soundCategory), new NetworkRegistry.TargetPoint(dimension, x, y, z, maxDistance));
    }

    @SideOnly(value=Side.CLIENT)
    public static void removeLangKey(String key) throws IllegalAccessException {
        Locale locale = (Locale)languageManagerCurrentLocaleField.get(null);
        Map properties = (Map)localePropertiesField.get(locale);
        properties.remove(key);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addLangKey(String key, String value) throws IllegalAccessException {
        Locale locale = (Locale)languageManagerCurrentLocaleField.get(null);
        Map properties = (Map)localePropertiesField.get(locale);
        properties.put(key, value);
    }

    public static void populateEntityDoubleMap(String[] regexArray, LinkedHashMap<Class<? extends EntityLivingBase>, LinkedHashMap<String, Double>> mapToPopulate) {
        for (String regex : regexArray) {
            String name;
            String[] tokens = Tools.fixedSplit(regex, ",");
            double value = Double.parseDouble(tokens[1].trim());
            String[] tokens2 = Tools.fixedSplit(tokens[0].trim(), ":");
            String domain = "minecraft";
            String specificName = ".*";
            if (tokens2.length == 1) {
                name = tokens2[0];
            } else {
                domain = tokens2[0];
                name = tokens2[1];
                if (tokens2.length > 2) {
                    specificName = tokens2[2];
                }
            }
            if (name.toLowerCase().equals("player")) {
                mapToPopulate.computeIfAbsent(EntityPlayerMP.class, o -> new LinkedHashMap()).put(specificName, value);
                continue;
            }
            for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
                Class cls;
                if (!Pattern.matches(domain, ((ResourceLocation)entry.getKey()).func_110624_b()) || !Pattern.matches(name, ((ResourceLocation)entry.getKey()).func_110623_a()) || !EntityLivingBase.class.isAssignableFrom(cls = ((EntityEntry)entry.getValue()).getEntityClass())) continue;
                mapToPopulate.computeIfAbsent(cls, o -> new LinkedHashMap()).put(specificName, value);
            }
        }
    }

    public static double entityMatchesDoubleMapOrDefault(EntityLivingBase entity, LinkedHashMap<Class<? extends EntityLivingBase>, LinkedHashMap<String, Double>> populatedMap, double defaultValue) {
        HashMap map = populatedMap.get(entity.getClass());
        if (map == null) {
            return defaultValue;
        }
        String name = entity.func_70005_c_();
        for (Map.Entry entry : map.entrySet()) {
            if (!Pattern.matches((String)entry.getKey(), name)) continue;
            return (Double)entry.getValue();
        }
        return defaultValue;
    }

    public static void populateEntityIntMap(String[] regexArray, LinkedHashMap<Class<? extends EntityLivingBase>, LinkedHashMap<String, Integer>> mapToPopulate) {
        for (String regex : regexArray) {
            String name;
            String[] tokens = Tools.fixedSplit(regex, ",");
            int value = Integer.parseInt(tokens[1].trim());
            String[] tokens2 = Tools.fixedSplit(tokens[0].trim(), ":");
            String domain = "minecraft";
            String specificName = ".*";
            if (tokens2.length == 1) {
                name = tokens2[0];
            } else {
                domain = tokens2[0];
                name = tokens2[1];
                if (tokens2.length > 2) {
                    specificName = tokens2[2];
                }
            }
            if (name.toLowerCase().equals("player")) {
                mapToPopulate.computeIfAbsent(EntityPlayerMP.class, o -> new LinkedHashMap()).put(specificName, value);
                continue;
            }
            for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
                Class cls;
                if (!Pattern.matches(domain, ((ResourceLocation)entry.getKey()).func_110624_b()) || !Pattern.matches(name, ((ResourceLocation)entry.getKey()).func_110623_a()) || !EntityLivingBase.class.isAssignableFrom(cls = ((EntityEntry)entry.getValue()).getEntityClass())) continue;
                mapToPopulate.computeIfAbsent(cls, o -> new LinkedHashMap()).put(specificName, value);
            }
        }
    }

    public static int entityMatchesIntMapOrDefault(EntityLivingBase entity, LinkedHashMap<Class<? extends EntityLivingBase>, LinkedHashMap<String, Integer>> populatedMap, int defaultValue) {
        HashMap map = populatedMap.get(entity.getClass());
        if (map == null) {
            return defaultValue;
        }
        String name = entity.func_70005_c_();
        for (Map.Entry entry : map.entrySet()) {
            if (!Pattern.matches((String)entry.getKey(), name)) continue;
            return (Integer)entry.getValue();
        }
        return defaultValue;
    }

    public static void populateEntityMap(String[] regexArray, LinkedHashMap<Class<? extends EntityLivingBase>, HashSet<String>> mapToPopulate) {
        for (String regex : regexArray) {
            String name;
            String[] tokens = Tools.fixedSplit(regex, ":");
            String domain = "minecraft";
            String specificName = ".*";
            if (tokens.length == 1) {
                name = tokens[0];
            } else {
                domain = tokens[0];
                name = tokens[1];
                if (tokens.length > 2) {
                    specificName = tokens[2];
                }
            }
            if (name.toLowerCase().equals("player")) {
                mapToPopulate.computeIfAbsent(EntityPlayerMP.class, o -> new HashSet()).add(specificName);
                continue;
            }
            for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
                Class cls;
                if (!Pattern.matches(domain, ((ResourceLocation)entry.getKey()).func_110624_b()) || !Pattern.matches(name, ((ResourceLocation)entry.getKey()).func_110623_a()) || !EntityLivingBase.class.isAssignableFrom(cls = ((EntityEntry)entry.getValue()).getEntityClass())) continue;
                mapToPopulate.computeIfAbsent(cls, o -> new HashSet()).add(specificName);
            }
        }
    }

    public static boolean entityMatchesMap(EntityLivingBase entity, LinkedHashMap<Class<? extends EntityLivingBase>, HashSet<String>> populatedMap) {
        HashSet<String> set = populatedMap.get(entity.getClass());
        if (set == null) {
            return false;
        }
        String name = entity.func_70005_c_();
        for (String s : set) {
            if (!Pattern.matches(s, name)) continue;
            return true;
        }
        return false;
    }

    public static boolean hosting() {
        return host;
    }

    public static void serverStart(FMLServerAboutToStartEvent event) {
        host = true;
    }

    public static void serverStop(FMLServerStoppedEvent event) {
        host = false;
    }

    public static String getConfigDir() {
        return Loader.instance().getConfigDir().getAbsolutePath() + File.separator;
    }

    public static Configuration getConfig(String modid) throws IllegalAccessException {
        return (Configuration)((Map)configManagerCONFIGSField.get(null)).get(MCTools.getConfigDir() + modid + ".cfg");
    }

    public static void reloadConfig(String modid) throws IllegalAccessException {
        MCTools.reloadConfig(MCTools.getConfigDir() + modid + ".cfg", modid);
    }

    public static void reloadConfig(String configFilename, String modid) throws IllegalAccessException {
        ((Map)configManagerCONFIGSField.get(null)).remove(configFilename);
        ConfigManager.sync((String)modid, (Config.Type)Config.Type.INSTANCE);
    }

    public static String getWorldSaveDir(MinecraftServer server) {
        return server.field_71305_c[0].func_72860_G().func_75765_b().toString() + File.separator;
    }

    public static String getDataDir(MinecraftServer server) {
        return server.field_71305_c[0].func_72860_G().func_75765_b().toString() + File.separator + "data" + File.separator;
    }

    public static String getPlayerDataDir(MinecraftServer server) {
        return server.field_71305_c[0].func_72860_G().func_75765_b().toString() + File.separator + "playerdata" + File.separator;
    }

    public static void crash(Exception e, int code, boolean hardExit) {
        e.printStackTrace();
        FMLCommonHandler.instance().exitJava(code, hardExit);
    }

    public static boolean isRidingOrRiddenBy(Entity entity1, Entity entity2) {
        return entity1 != null && entity2 != null && (entity1.func_184187_bx() == entity2 || entity2.func_184187_bx() == entity1);
    }

    public static boolean isOwned(Entity entity) {
        return MCTools.getOwner(entity) != null;
    }

    public static Entity getOwner(Entity entity) {
        if (!(entity instanceof IEntityOwnable)) {
            return null;
        }
        return ((IEntityOwnable)entity).func_70902_q();
    }

    public static double getYawRad(Vec3d fromVec, Vec3d toVec, TrigLookupTable trigTable) {
        return trigTable.arctanFullcircle(fromVec.field_72449_c, fromVec.field_72450_a, toVec.field_72449_c, toVec.field_72450_a);
    }

    public static double getYawDeg(Vec3d fromVec, Vec3d toVec, TrigLookupTable trigTable) {
        return Tools.radtodeg(MCTools.getYawRad(fromVec, toVec, trigTable));
    }

    public static double getPitchRad(Vec3d fromVec, Vec3d toVec, TrigLookupTable trigTable) {
        double result = trigTable.arctanFullcircle(0.0, 0.0, Tools.distance(fromVec.field_72450_a, fromVec.field_72449_c, toVec.field_72450_a, toVec.field_72449_c), toVec.field_72448_b - fromVec.field_72448_b);
        return result >= Math.PI ? result - Math.PI * 2 : result;
    }

    public static double getPitchDeg(Vec3d fromVec, Vec3d toVec, TrigLookupTable trigTable) {
        return Tools.radtodeg(MCTools.getPitchRad(fromVec, toVec, trigTable));
    }

    public static Double getAttribute(EntityLivingBase entity, String attributeName) {
        for (IAttributeInstance instance : entity.func_110140_aT().func_111146_a()) {
            if (!instance.func_111123_a().func_111108_a().equals(attributeName)) continue;
            return instance.func_111126_e();
        }
        return null;
    }

    public static double getAttribute(EntityLivingBase entity, IAttribute attribute) {
        return MCTools.getAttribute(entity, attribute, attribute.func_111110_b());
    }

    public static double getAttribute(EntityLivingBase entity, IAttribute attribute, double defaultVal) {
        if (entity == null) {
            return defaultVal;
        }
        IAttributeInstance iAttributeInstance = entity.func_110148_a(attribute);
        return iAttributeInstance == null ? defaultVal : iAttributeInstance.func_111126_e();
    }

    public static void teleport(EntityLivingBase entity, BlockPos pos, boolean doEvent, float fallDamage) {
        MCTools.teleport(entity, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, doEvent, fallDamage);
    }

    public static void teleport(EntityLivingBase entity, double x, double y, double z, boolean doEvent, float fallDamage) {
        if (!doEvent) {
            entity.func_70634_a(x, y, z);
            entity.field_70143_R = 0.0f;
            if (fallDamage > 0.0f) {
                entity.func_70097_a(DamageSource.field_76379_h, fallDamage);
            }
        } else {
            EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, fallDamage);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                entity.field_70143_R = 0.0f;
                fallDamage = event.getAttackDamage();
                if (fallDamage > 0.0f) {
                    entity.func_70097_a(DamageSource.field_76379_h, fallDamage);
                }
            }
        }
    }

    public static BlockPos randomPos(BlockPos centerPos, int xzRange, int yRange) {
        return centerPos.func_177982_a(-xzRange + (int)(Math.random() * (double)xzRange * 2.0 + 1.0), -xzRange + (int)(Math.random() * (double)xzRange * 2.0 + 1.0), -yRange + (int)(Math.random() * (double)yRange * 2.0 + 1.0));
    }

    public static boolean isOP(EntityPlayerMP player) {
        if (MCTools.isServerOwner(player)) {
            return true;
        }
        for (String string : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152606_n()) {
            if (!string.equalsIgnoreCase(player.func_146103_bH().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isServerOwner(EntityPlayerMP player) {
        return player.func_70005_c_().equals(FMLCommonHandler.instance().getMinecraftServerInstance().func_71214_G());
    }

    public static boolean isPassive(EntityLivingBase livingBase) {
        if (livingBase == null) {
            return false;
        }
        if (livingBase instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)livingBase;
            for (EntityAITasks.EntityAITaskEntry task : living.field_70714_bg.field_75782_a) {
                EntityAIBase ai = task.field_75733_a;
                if (!(ai instanceof NPEAttackTargetTaskHolder) && !(ai instanceof EntityAIAttackMelee) && !(ai instanceof EntityAIAttackRanged) && !(ai instanceof EntityAIAttackRangedBow)) continue;
                return false;
            }
        }
        return MCTools.getAttribute(livingBase, SharedMonsterAttributes.field_111264_e, 0.0) <= 0.0;
    }

    public static void printAITasks(EntityLiving living) {
        for (String s : MCTools.getAITaskData(living)) {
            System.out.println(s);
        }
    }

    public static ArrayList<String> getAITaskData(EntityLiving living) {
        String str;
        EntityAIBase ai;
        double priority;
        ArrayList<String> result = new ArrayList<String>();
        ExplicitPriorityQueue<EntityAIBase> queue = new ExplicitPriorityQueue<EntityAIBase>();
        result.add("===================================");
        result.add(living.func_70005_c_());
        result.add("===================================");
        for (EntityAITasks.EntityAITaskEntry task : living.field_70715_bh.field_75782_a) {
            queue.add(task.field_75733_a, task.field_75731_b);
        }
        while (queue.size() > 0) {
            priority = queue.peekPriority();
            ai = (EntityAIBase)queue.poll();
            str = ai.getClass().getSimpleName();
            if (str.equals("")) {
                str = ai.getClass().getName();
            }
            if (str.equals("")) {
                str = ai.getClass().getPackage().getName() + ".???????";
            }
            result.add(priority + "\t" + str);
        }
        result.add("===================================");
        for (EntityAITasks.EntityAITaskEntry task : living.field_70714_bg.field_75782_a) {
            queue.add(task.field_75733_a, task.field_75731_b);
        }
        while (queue.size() > 0) {
            priority = queue.peekPriority();
            ai = (EntityAIBase)queue.poll();
            boolean isNPE = false;
            if (ai instanceof NPEAttackTargetTaskHolder) {
                isNPE = true;
                ai = ((NPEAttackTargetTaskHolder)ai).getBadAI();
            }
            if ((str = ai.getClass().getSimpleName()).equals("")) {
                str = ai.getClass().getName();
            }
            if (str.equals("")) {
                str = ai.getClass().getPackage().getName() + ".???????";
            }
            result.add(priority + "\t" + (isNPE ? "NpeAttackTargetTaskHolder (" + str + ")" : str));
        }
        result.add("===================================");
        result.add("");
        return result;
    }

    static {
        host = false;
        try {
            configManagerCONFIGSField = ReflectionTool.getField(ConfigManager.class, "CONFIGS");
            if (FantasticLib.isClient) {
                languageManagerCurrentLocaleField = ReflectionTool.getField(LanguageManager.class, "field_135049_a", "CURRENT_LOCALE");
                localePropertiesField = ReflectionTool.getField(Locale.class, "field_135032_a", "properties");
            }
        }
        catch (Exception e) {
            MCTools.crash(e, 700, false);
        }
    }
}

