/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.component.CResourceLocation;
import com.fantasticsource.mctools.controlintercept.ControlEvent;
import com.fantasticsource.mctools.sound.SimpleSound;
import com.fantasticsource.tools.component.Component;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Network {
    public static final SimpleNetworkWrapper WRAPPER = new SimpleNetworkWrapper("fantasticlib");
    private static int discriminator = 0;

    public static void init() {
        WRAPPER.registerMessage(PlaySimpleSoundPacketHandler.class, PlaySimpleSoundPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(ControlEventPacketHandler.class, ControlEventPacket.class, discriminator++, Side.SERVER);
        WRAPPER.registerMessage(GenericComponentPacketHandler.class, GenericComponentPacket.class, discriminator++, Side.CLIENT);
    }

    public static class GenericComponentPacketHandler
    implements IMessageHandler<GenericComponentPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(GenericComponentPacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> packet.component.onClientSync());
            return null;
        }
    }

    public static class GenericComponentPacket
    implements IMessage {
        public Component component;

        public GenericComponentPacket() {
        }

        public GenericComponentPacket(Component component) {
            this.component = component;
        }

        public void toBytes(ByteBuf buf) {
            Component.writeMarked(buf, this.component);
        }

        public void fromBytes(ByteBuf buf) {
            this.component = Component.readMarked(buf);
        }
    }

    public static class ControlEventPacketHandler
    implements IMessageHandler<ControlEventPacket, IMessage> {
        public IMessage onMessage(ControlEventPacket packet, MessageContext ctx) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            server.func_152344_a(() -> MinecraftForge.EVENT_BUS.post((Event)packet.event.setPlayer(ctx.getServerHandler().field_147369_b)));
            return null;
        }
    }

    public static class ControlEventPacket
    implements IMessage {
        public ControlEvent event;

        public ControlEventPacket() {
        }

        public ControlEventPacket(ControlEvent event) {
            this.event = event;
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.event.name);
            buf.writeBoolean(this.event.state);
            buf.writeBoolean(this.event.lastState != null);
            if (this.event.lastState != null) {
                buf.writeBoolean(this.event.lastState.booleanValue());
            }
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.event.identifier);
        }

        public void fromBytes(ByteBuf buf) {
            this.event = new ControlEvent(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readBoolean(), buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null, ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public static class PlaySimpleSoundPacketHandler
    implements IMessageHandler<PlaySimpleSoundPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PlaySimpleSoundPacket packet, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                SimpleSound simpleSound = null;
                if (packet.followingID != null) {
                    for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                        Entity following = world.func_73045_a(packet.followingID.intValue());
                        if (following == null) continue;
                        simpleSound = new SimpleSound(packet.rl.value, packet.soundCategory, following);
                        break;
                    }
                } else {
                    simpleSound = packet.x != null ? new SimpleSound(packet.rl.value, packet.soundCategory, packet.x.floatValue(), packet.y.floatValue(), packet.z.floatValue()) : new SimpleSound(packet.rl.value, packet.soundCategory);
                }
                if (simpleSound != null) {
                    simpleSound.attenuationType = packet.attenuationType == 0 ? ISound.AttenuationType.NONE : ISound.AttenuationType.LINEAR;
                    simpleSound.volume = packet.volume;
                    simpleSound.pitch = packet.pitch;
                    mc.func_147118_V().func_147682_a((ISound)simpleSound);
                }
            });
            return null;
        }
    }

    public static class PlaySimpleSoundPacket
    implements IMessage {
        public Integer followingID;
        public Float x;
        public Float y;
        public Float z;
        public CResourceLocation rl = new CResourceLocation();
        public int attenuationType;
        public float volume;
        public float pitch;
        public SoundCategory soundCategory;

        public PlaySimpleSoundPacket() {
        }

        public PlaySimpleSoundPacket(ResourceLocation rl) {
            this(rl, null);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, Entity following) {
            this(rl, following, 2, 1.0f, 1.0f);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, Entity following, int attenuationType, float volume, float pitch) {
            this(rl, following, attenuationType, volume, pitch, SoundCategory.MASTER);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, Entity following, int attenuationType, float volume, float pitch, SoundCategory soundCategory) {
            this.x = null;
            this.y = null;
            this.z = null;
            this.rl.set(rl);
            this.followingID = following.func_145782_y();
            this.attenuationType = attenuationType;
            this.volume = volume;
            this.pitch = pitch;
            this.soundCategory = soundCategory;
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, float x, float y, float z) {
            this(rl, x, y, z, 2, 1.0f, 1.0f);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, float x, float y, float z, int attenuationType, float volume, float pitch) {
            this(rl, x, y, z, attenuationType, volume, pitch, SoundCategory.MASTER);
        }

        public PlaySimpleSoundPacket(ResourceLocation rl, float x, float y, float z, int attenuationType, float volume, float pitch, SoundCategory soundCategory) {
            this.followingID = null;
            this.rl.set(rl);
            this.x = Float.valueOf(x);
            this.y = Float.valueOf(y);
            this.z = Float.valueOf(z);
            this.attenuationType = attenuationType;
            this.volume = volume;
            this.pitch = pitch;
            this.soundCategory = soundCategory;
        }

        public void toBytes(ByteBuf buf) {
            this.rl.write(buf);
            buf.writeBoolean(this.followingID != null);
            if (this.followingID != null) {
                buf.writeInt(this.followingID.intValue());
            }
            buf.writeBoolean(this.x != null);
            if (this.x != null) {
                buf.writeFloat(this.x.floatValue());
                buf.writeFloat(this.y.floatValue());
                buf.writeFloat(this.z.floatValue());
            }
            buf.writeInt(this.attenuationType);
            buf.writeFloat(this.volume);
            buf.writeFloat(this.pitch);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.soundCategory.func_187948_a());
        }

        public void fromBytes(ByteBuf buf) {
            this.rl.read(buf);
            if (buf.readBoolean()) {
                this.followingID = buf.readInt();
            }
            if (buf.readBoolean()) {
                this.x = Float.valueOf(buf.readFloat());
                this.y = Float.valueOf(buf.readFloat());
                this.z = Float.valueOf(buf.readFloat());
            }
            this.attenuationType = buf.readInt();
            this.volume = buf.readFloat();
            this.pitch = buf.readFloat();
            this.soundCategory = SoundCategory.func_187950_a((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }
}

