/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import com.fantasticsource.tools.datastructures.Pair;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Render {
    public static final byte SCALING_FULL = 0;
    public static final byte SCALING_MC_GUI = 1;
    private static Field activeRenderInfoViewportField;
    private static Field activeRenderInfoProjectionField;
    private static Field activeRenderInfoModelviewField;
    private static Field minecraftRenderPartialTicksPausedField;
    private static float fov;
    private static float fovMultiplier;

    public static void init() {
        try {
            activeRenderInfoViewportField = ReflectionTool.getField(ActiveRenderInfo.class, "field_178814_a", "VIEWPORT");
            activeRenderInfoProjectionField = ReflectionTool.getField(ActiveRenderInfo.class, "field_178813_c", "PROJECTION");
            activeRenderInfoModelviewField = ReflectionTool.getField(ActiveRenderInfo.class, "field_178812_b", "MODELVIEW");
            minecraftRenderPartialTicksPausedField = ReflectionTool.getField(Minecraft.class, "field_193996_ah", "renderPartialTicksPaused");
            MinecraftForge.EVENT_BUS.register(Render.class);
        }
        catch (Exception e) {
            MCTools.crash(e, 701, false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void drawHUD(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            GlStateManager.func_179094_E();
            MinecraftForge.EVENT_BUS.post((Event)new RenderHUDEvent(event));
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void updateFOV(EntityViewRenderEvent.FOVModifier event) {
        fov = event.getFOV();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void updateFOVMultiplier(FOVUpdateEvent event) {
        fovMultiplier = event.getNewfov();
    }

    public static int getPartialStringWidth(String beforePart, String part) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        return fr.func_78256_a(beforePart + part) - fr.func_78256_a(beforePart);
    }

    public static void startOrtho() {
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)Display.getWidth(), (double)Display.getHeight(), (double)0.0, (double)-1.0, (double)1.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
    }

    public static void endOrtho() {
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
    }

    public static float getStoredVFOV() {
        return fov * fovMultiplier;
    }

    public static double getStoredHFOV(TrigLookupTable trigLookupTable) throws IllegalAccessException {
        return Tools.radtodeg(trigLookupTable.arctan(Render.getStoredZNearWidth() * 0.5 / Render.getStoredZNearDist())) * 2.0;
    }

    public static double getPartialTick() throws IllegalAccessException {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.func_147113_T() ? (double)((Float)minecraftRenderPartialTicksPausedField.get(mc)).floatValue() : (double)mc.func_184121_ak();
    }

    public static Pair<Float, Float> getEntityXYInWindow(Entity entity) throws IllegalAccessException {
        return Render.getEntityXYInWindow(entity, 0.0, 0.0, 0.0);
    }

    public static Pair<Float, Float> getEntityXYInWindow(Entity entity, double xOffset, double yOffset, double zOffset) throws IllegalAccessException {
        double partialTick = Render.getPartialTick();
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * partialTick + xOffset;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * partialTick + yOffset;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * partialTick + zOffset;
        return Render.get2DWindowCoordsFrom3DWorldCoords(x, y, z, partialTick);
    }

    public static Pair<Float, Float> get2DWindowCoordsFrom3DWorldCoords(double x, double y, double z) throws IllegalAccessException {
        return Render.get2DWindowCoordsFrom3DWorldCoords(x, y, z, Render.getPartialTick());
    }

    private static Pair<Float, Float> get2DWindowCoordsFrom3DWorldCoords(double x, double y, double z, double partialTick) throws IllegalAccessException {
        float scaleFactor;
        boolean behind;
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            viewEntity = Minecraft.func_71410_x().field_71439_g;
        }
        double px = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTick;
        double py = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTick;
        double pz = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTick;
        FloatBuffer modelView = Render.getStoredModelViewMatrix();
        FloatBuffer projection = Render.getStoredProjectionMatrix();
        IntBuffer viewport = Render.getStoredViewportMatrix();
        float[] in = new float[4];
        float[] out = new float[4];
        in[0] = (float)(x - px);
        in[1] = (float)(y - py);
        in[2] = (float)(z - pz);
        in[3] = 1.0f;
        Render.multMatrix(modelView, in, out);
        Render.multMatrix(projection, out, in);
        if ((double)in[3] == 0.0) {
            return null;
        }
        in[3] = 1.0f / in[3] * 0.5f;
        boolean bl = behind = in[3] < 0.0f;
        if (behind) {
            in[0] = -in[0];
            in[1] = -in[1];
        }
        in[0] = in[0] * in[3];
        in[1] = in[1] * in[3];
        float f = scaleFactor = behind ? Math.abs(in[0] * 2.0f) : Tools.max(Math.abs(in[0] * 2.0f), Math.abs(in[1] * 2.0f));
        if (behind || scaleFactor > 1.0f) {
            in[0] = in[0] / scaleFactor;
            in[1] = in[1] / scaleFactor;
        }
        float xx = (0.5f + in[0]) * (float)viewport.get(2) + (float)viewport.get(0);
        float yy = (0.5f - in[1]) * (float)viewport.get(3) + (float)viewport.get(1);
        return new Pair<Float, Float>(Float.valueOf(xx), Float.valueOf(yy));
    }

    private static void multMatrix(FloatBuffer m, float[] in, float[] out) {
        for (int i = 0; i < 4; ++i) {
            out[i] = in[0] * m.get(i) + in[1] * m.get(i + 4) + in[2] * m.get(i + 8) + in[3] * m.get(i + 12);
        }
    }

    public static double getCurrentZNearDist() {
        FloatBuffer projection = Render.getCurrentProjectionMatrix();
        return 2.0f * projection.get(11) / (2.0f * projection.get(10) - 2.0f);
    }

    public static double getStoredZNearDist() throws IllegalAccessException {
        FloatBuffer projection = Render.getStoredProjectionMatrix();
        return 2.0f * projection.get(11) / (2.0f * projection.get(10) - 2.0f);
    }

    public static double getCurrentZNearWidth() {
        return Render.getCurrentZNearDist() * 2.0 / (double)Render.getCurrentProjectionMatrix().get(0);
    }

    public static double getStoredZNearWidth() throws IllegalAccessException {
        return Render.getStoredZNearDist() * 2.0 / (double)Render.getStoredProjectionMatrix().get(0);
    }

    public static double getCurrentZNearHeight() {
        return Render.getCurrentZNearDist() * 2.0 / (double)Render.getCurrentProjectionMatrix().get(5);
    }

    public static double getStoredZNearHeight() throws IllegalAccessException {
        return Render.getStoredZNearDist() * 2.0 / (double)Render.getStoredProjectionMatrix().get(5);
    }

    public static int getCurrentViewportWidth() {
        return Render.getCurrentViewportMatrix().get(2);
    }

    public static int getStoredViewportWidth() throws IllegalAccessException {
        return Render.getStoredViewportMatrix().get(2);
    }

    public static int getCurrentViewportHeight() {
        return Render.getCurrentViewportMatrix().get(3);
    }

    public static int getStoredViewportHeight() throws IllegalAccessException {
        return Render.getStoredViewportMatrix().get(3);
    }

    public static IntBuffer getCurrentViewportMatrix() {
        IntBuffer result = ByteBuffer.allocateDirect(64).asIntBuffer();
        GlStateManager.func_187445_a((int)2983, (IntBuffer)result);
        return result;
    }

    public static IntBuffer getStoredViewportMatrix() throws IllegalAccessException {
        return ((IntBuffer)activeRenderInfoViewportField.get(null)).duplicate();
    }

    public static FloatBuffer getCurrentProjectionMatrix() {
        FloatBuffer result = ByteBuffer.allocateDirect(64).asFloatBuffer();
        GlStateManager.func_179111_a((int)2983, (FloatBuffer)result);
        return result;
    }

    public static FloatBuffer getStoredProjectionMatrix() throws IllegalAccessException {
        return ((FloatBuffer)activeRenderInfoProjectionField.get(null)).duplicate();
    }

    public static void setProjectionMatrix(FloatBuffer matrix) {
        GlStateManager.func_179128_n((int)5889);
        GL11.glLoadMatrix((FloatBuffer)matrix);
    }

    public static FloatBuffer getCurrentModelViewMatrix() {
        FloatBuffer result = ByteBuffer.allocateDirect(64).asFloatBuffer();
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)result);
        return result;
    }

    public static FloatBuffer getStoredModelViewMatrix() throws IllegalAccessException {
        return ((FloatBuffer)activeRenderInfoModelviewField.get(null)).duplicate();
    }

    public static void setModelViewMatrix(FloatBuffer matrix) {
        GlStateManager.func_179128_n((int)5888);
        GL11.glLoadMatrix((FloatBuffer)matrix);
    }

    public static Vec3d getCameraPosition() {
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            viewEntity = Minecraft.func_71410_x().field_71439_g;
        }
        return viewEntity.func_174791_d().func_178787_e(ActiveRenderInfo.getCameraPosition());
    }

    public static class RenderHUDEvent
    extends Event {
        RenderGameOverlayEvent.Pre parentEvent;
        byte scalingMode = 1;
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int width = this.sr.func_78326_a();
        int height = this.sr.func_78328_b();

        public RenderHUDEvent(RenderGameOverlayEvent.Pre parentEvent) {
            this.parentEvent = parentEvent;
        }

        public RenderGameOverlayEvent.Pre getParentEvent() {
            return this.parentEvent;
        }

        public void setScalingMode(byte scalingMode) throws IllegalAccessException {
            if (this.scalingMode == scalingMode) {
                return;
            }
            double xRatio = this.width;
            double yRatio = this.height;
            switch (scalingMode) {
                case 0: {
                    this.width = Render.getStoredViewportWidth();
                    this.height = Render.getStoredViewportHeight();
                    break;
                }
                case 1: {
                    this.width = this.sr.func_78326_a();
                    this.height = this.sr.func_78328_b();
                    break;
                }
                default: {
                    return;
                }
            }
            this.scalingMode = scalingMode;
            GlStateManager.func_179139_a((double)(xRatio /= (double)this.width), (double)(yRatio /= (double)this.height), (double)1.0);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

