/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.aw;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.aw.RenderModes;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import com.fantasticsource.tools.datastructures.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class AWSkinGenerator {
    protected static final String LIB_DIR = MCTools.getConfigDir() + ".." + File.separator + "armourers_workshop" + File.separator + "skin-library" + File.separator;
    @GameRegistry.ObjectHolder(value="armourers_workshop:item.skin")
    public static Item awSkinItem;

    public static ItemStack generate(String libraryFile, String skinType) {
        return AWSkinGenerator.generate(libraryFile, skinType, new LinkedHashMap<Integer, Color>());
    }

    public static ItemStack generate(String libraryFile, String skinType, LinkedHashMap<Integer, Color> dyes) {
        File[] files;
        if (libraryFile == null || libraryFile.toLowerCase().equals("null")) {
            return ItemStack.field_190927_a;
        }
        ArrayList<String> otherFileNames = new ArrayList<String>();
        File file = new File(LIB_DIR + libraryFile);
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            boolean defaultFound = false;
            for (File file2 : files) {
                String name = file2.getAbsolutePath().replace(LIB_DIR, "").replace(".armour", "");
                if (name.contains("@")) {
                    otherFileNames.add(name);
                    continue;
                }
                if (defaultFound) continue;
                libraryFile = name;
                defaultFound = true;
            }
        }
        ItemStack result = new ItemStack(awSkinItem);
        NBTTagCompound compound = new NBTTagCompound();
        result.func_77982_d(compound);
        compound.func_74782_a("armourersWorkshop", (NBTBase)new NBTTagCompound());
        compound = compound.func_74775_l("armourersWorkshop");
        NBTTagCompound compound2 = new NBTTagCompound();
        compound2.func_74778_a("libraryFile", libraryFile);
        compound2.func_74778_a("skinType", skinType);
        compound.func_74782_a("identifier", (NBTBase)compound2);
        compound2 = new NBTTagCompound();
        for (Map.Entry<Integer, Color> entry : dyes.entrySet()) {
            int i = entry.getKey();
            Color dye = entry.getValue();
            compound2.func_74774_a("dye" + i + "r", (byte)dye.r());
            compound2.func_74774_a("dye" + i + "g", (byte)dye.g());
            compound2.func_74774_a("dye" + i + "b", (byte)dye.b());
            compound2.func_74774_a("dye" + i + "t", (byte)dye.a());
        }
        compound.func_74782_a("dyeData", (NBTBase)compound2);
        for (String name : otherFileNames) {
            String renderModeTags = name.substring(name.indexOf("@") + 1);
            ArrayList<Pair<String, String>> reqs = new ArrayList<Pair<String, String>>();
            for (String requirement : Tools.fixedSplit(renderModeTags, "@")) {
                String[] tokens = Tools.fixedSplit(requirement, "[.]");
                reqs.add(new Pair<String, String>(tokens[0], tokens[1]));
            }
            RenderModes.addRenderModeToSkin(result, reqs, skinType, name, dyes);
        }
        return result;
    }
}

