/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.aw;

import com.fantasticsource.fantasticlib.api.FLibAPI;
import com.fantasticsource.mctools.GlobalInventory;
import com.fantasticsource.mctools.event.InventoryChangedEvent;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import com.fantasticsource.tools.datastructures.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderModes {
    public static void init() {
        FLibAPI.attachNBTCapToEntityIf("fantasticlib", entity -> true);
        MinecraftForge.EVENT_BUS.register(RenderModes.class);
    }

    public static void setRenderMode(Entity entity, String renderModeChannel, String renderMode) {
        if (renderMode == null) {
            RenderModes.clearRenderMode(entity, renderModeChannel);
            return;
        }
        NBTTagCompound compound = FLibAPI.getNBTCap(entity).getCompound("fantasticlib");
        if (!compound.func_74764_b("renderModes")) {
            compound.func_74782_a("renderModes", (NBTBase)new NBTTagCompound());
        }
        compound = compound.func_74775_l("renderModes");
        compound.func_74778_a(renderModeChannel, renderMode);
        RenderModes.refresh(entity);
    }

    public static String getRenderMode(Entity entity, String renderModeChannel) {
        NBTTagCompound compound = FLibAPI.getNBTCap(entity).getCompound("fantasticlib");
        if (!compound.func_74764_b("renderModes")) {
            return null;
        }
        if (!(compound = compound.func_74775_l("renderModes")).func_74764_b(renderModeChannel)) {
            return null;
        }
        return compound.func_74779_i(renderModeChannel);
    }

    public static LinkedHashMap<String, String> getRenderModes(Entity entity) {
        NBTTagCompound compound = FLibAPI.getNBTCap(entity).getCompound("fantasticlib");
        if (!compound.func_74764_b("renderModes")) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        compound = compound.func_74775_l("renderModes");
        for (String key : compound.func_150296_c()) {
            result.put(key, compound.func_74779_i(key));
        }
        return result;
    }

    public static void clearRenderMode(Entity entity, String renderModeChannel) {
        NBTTagCompound compound = FLibAPI.getNBTCap(entity).getCompound("fantasticlib");
        if (!compound.func_74764_b("renderModes")) {
            return;
        }
        compound = compound.func_74775_l("renderModes");
        compound.func_82580_o(renderModeChannel);
    }

    public static void clearRenderModes(Entity entity) {
        NBTTagCompound compound = FLibAPI.getNBTCap(entity).getCompound("fantasticlib");
        compound.func_82580_o("renderModes");
    }

    public static ItemStack addRenderModeToSkin(ItemStack skinStack, ArrayList<Pair<String, String>> renderChannelAndModeRequirementPairs, String skinType, String libraryFile, LinkedHashMap<Integer, Color> dyes) {
        NBTTagCompound compound;
        NBTTagCompound identifier = new NBTTagCompound();
        identifier.func_74778_a("skinType", skinType);
        identifier.func_74778_a("libraryFile", libraryFile);
        NBTTagCompound dyeData = new NBTTagCompound();
        for (Map.Entry<Integer, Color> entry : dyes.entrySet()) {
            int i = entry.getKey();
            Color dye = entry.getValue();
            dyeData.func_74774_a("dye" + i + "r", (byte)dye.r());
            dyeData.func_74774_a("dye" + i + "g", (byte)dye.g());
            dyeData.func_74774_a("dye" + i + "b", (byte)dye.b());
            dyeData.func_74774_a("dye" + i + "t", (byte)dye.a());
        }
        if (!skinStack.func_77942_o()) {
            skinStack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = skinStack.func_77978_p()).func_74764_b("flib")) {
            compound.func_74782_a("flib", (NBTBase)new NBTTagCompound());
        }
        if (!(compound = compound.func_74775_l("flib")).func_74764_b("renderModes")) {
            compound.func_74782_a("renderModes", (NBTBase)new NBTTagCompound());
        }
        compound = compound.func_74775_l("renderModes");
        if (renderChannelAndModeRequirementPairs == null || renderChannelAndModeRequirementPairs.size() == 0) {
            compound.func_74782_a("default", (NBTBase)new NBTTagCompound());
            compound = compound.func_74775_l("default");
            compound.func_74782_a("identifier", (NBTBase)identifier);
            compound.func_74782_a("dyeData", (NBTBase)dyeData);
        } else {
            StringBuilder key = new StringBuilder();
            boolean start = true;
            for (Pair<String, String> requirement : renderChannelAndModeRequirementPairs) {
                key.append(start ? "" : ",").append(requirement.getKey()).append(":").append(requirement.getValue());
                start = false;
            }
            compound.func_74782_a(key.toString(), (NBTBase)new NBTTagCompound());
            compound = compound.func_74775_l(key.toString());
            compound.func_74782_a("identifier", (NBTBase)identifier);
            compound.func_74782_a("dyeData", (NBTBase)dyeData);
        }
        return skinStack;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void inventoryChanged(InventoryChangedEvent event) {
        RenderModes.refresh(event.getEntity());
    }

    public static void refresh(Entity entity) {
        boolean changed = false;
        for (ItemStack stack : GlobalInventory.getAWSkins(entity)) {
            changed |= RenderModes.tryTransformRenderMode(stack, entity);
        }
        if (changed) {
            GlobalInventory.syncAWWardrobeSkins(entity, true, true);
        }
    }

    protected static boolean tryTransformRenderMode(ItemStack stack, Entity target) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("flib")) {
            return false;
        }
        if (!(compound = compound.func_74775_l("flib")).func_74764_b("renderModes")) {
            return false;
        }
        compound = compound.func_74775_l("renderModes");
        int conditionsMet = 0;
        NBTTagCompound newCompound = null;
        for (String requirements : compound.func_150296_c()) {
            if (requirements.equals("default")) {
                if (conditionsMet != 0) continue;
                newCompound = compound.func_74775_l("default");
                continue;
            }
            boolean failed = false;
            String[] requirementArray = Tools.fixedSplit(requirements, ",");
            if (requirementArray.length <= conditionsMet) continue;
            for (String pair : requirementArray) {
                String[] tokens = Tools.fixedSplit(pair, ":");
                if (tokens[1].equals(RenderModes.getRenderMode(target, tokens[0]))) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            conditionsMet = requirementArray.length;
            newCompound = compound.func_74775_l(requirements);
        }
        if (newCompound == null) {
            return RenderModes.removeSkin(stack);
        }
        return RenderModes.setSkin(stack, newCompound);
    }

    protected static boolean removeSkin(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound.func_74764_b("armourersWorkshop")) {
            stack.func_77978_p().func_82580_o("armourersWorkshop");
            return true;
        }
        return false;
    }

    protected static boolean setSkin(ItemStack stack, NBTTagCompound skinInfo) {
        NBTTagCompound compound;
        if (skinInfo == null || !skinInfo.func_74764_b("identifier")) {
            return RenderModes.removeSkin(stack);
        }
        boolean changed = false;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            changed = true;
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("armourersWorkshop")) {
            compound.func_74782_a("armourersWorkshop", (NBTBase)new NBTTagCompound());
            changed = true;
        }
        compound = compound.func_74775_l("armourersWorkshop");
        NBTTagCompound infoCompound = skinInfo.func_74775_l("identifier");
        NBTTagCompound newCompound = new NBTTagCompound();
        newCompound.func_74778_a("skinType", infoCompound.func_74779_i("skinType"));
        newCompound.func_74778_a("libraryFile", infoCompound.func_74779_i("libraryFile"));
        if (!compound.func_74764_b("identifier") || !compound.func_74775_l("identifier").equals((Object)newCompound)) {
            changed = true;
        }
        compound.func_74782_a("identifier", (NBTBase)newCompound);
        infoCompound = skinInfo.func_74775_l("dyeData");
        newCompound = new NBTTagCompound();
        for (String key : infoCompound.func_150296_c()) {
            newCompound.func_74774_a(key, infoCompound.func_74771_c(key));
        }
        if (!compound.func_74764_b("dyeData") || !compound.func_74775_l("dyeData").equals((Object)newCompound)) {
            changed = true;
        }
        compound.func_74782_a("dyeData", (NBTBase)newCompound);
        return changed;
    }
}

