/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.aw;

import com.fantasticsource.mctools.GlobalInventory;
import com.fantasticsource.mctools.event.InventoryChangedEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TransientAWSkinHandler {
    @GameRegistry.ObjectHolder(value="armourers_workshop:item.skin")
    public static Item awSkinItem;

    public static void addTransientAWSkin(ItemStack equipmentStack, String skinType, int indexWithinSkinType, ItemStack skinStack) {
        NBTTagCompound compound;
        if (!equipmentStack.func_77942_o()) {
            equipmentStack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = equipmentStack.func_77978_p()).func_74764_b("flib")) {
            compound.func_74782_a("flib", (NBTBase)new NBTTagCompound());
        }
        if (!(compound = compound.func_74775_l("flib")).func_74764_b("AWSkins")) {
            compound.func_74782_a("AWSkins", (NBTBase)new NBTTagList());
        }
        NBTTagList list = compound.func_150295_c("AWSkins", 10);
        compound = new NBTTagCompound();
        compound.func_74778_a("type", skinType);
        compound.func_74768_a("index", indexWithinSkinType);
        compound.func_74782_a("skinCompound", (NBTBase)skinStack.serializeNBT());
        list.func_74742_a((NBTBase)compound);
    }

    public static void clearTransientAWSkins(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound mainTag = stack.func_77978_p();
        if (!mainTag.func_74764_b("flib")) {
            return;
        }
        NBTTagCompound compound = mainTag.func_74775_l("flib");
        compound.func_82580_o("AWSkins");
        if (compound.func_82582_d()) {
            mainTag.func_82580_o("flib");
            if (mainTag.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    protected static void applyTransientTag(ItemStack stack) {
        NBTTagCompound compound;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("flib")) {
            compound.func_74782_a("flib", (NBTBase)new NBTTagCompound());
        }
        compound = compound.func_74775_l("flib");
        compound.func_74757_a("AWTransient", true);
    }

    public static boolean isTransientSkin(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("flib")) {
            return false;
        }
        return compound.func_74775_l("flib").func_74767_n("AWTransient");
    }

    public static boolean tryApplyTransientSkinsFromStack(ItemStack stack, Entity target) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b("flib")) {
            return false;
        }
        if (!(compound = compound.func_74775_l("flib")).func_74764_b("AWSkins")) {
            return false;
        }
        NBTTagList list = compound.func_150295_c("AWSkins", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            int index;
            compound = list.func_150305_b(i);
            String skinType = compound.func_74779_i("type");
            ItemStack oldSkin = GlobalInventory.getAWSkin(target, skinType, index = compound.func_74762_e("index"));
            if (!oldSkin.func_190926_b() && !TransientAWSkinHandler.isTransientSkin(oldSkin)) {
                System.err.println(TextFormatting.RED + "Failed to place skin into slot: " + skinType + " (" + index + ")");
                System.err.println(TextFormatting.RED + "Skin: " + stack.func_82833_r());
                System.err.println(TextFormatting.RED + "Entity: " + target.func_145748_c_() + " in world " + target.field_71093_bK + " (" + target.func_180425_c() + ")");
                return false;
            }
            ItemStack newSkin = new ItemStack(compound.func_74775_l("skinCompound"));
            TransientAWSkinHandler.applyTransientTag(newSkin);
            GlobalInventory.setAWSkin(target, compound.func_74779_i("type"), compound.func_74762_e("index"), newSkin);
        }
        return list.func_74745_c() > 0;
    }

    public static boolean removeAllTransientSkins(Entity entity) {
        boolean changed = false;
        for (ItemStack skin : GlobalInventory.getAWSkins(entity)) {
            if (!TransientAWSkinHandler.isTransientSkin(skin)) continue;
            skin.func_77982_d(null);
            skin.func_190920_e(0);
            changed = true;
        }
        return changed;
    }

    @SubscribeEvent
    public static void inventoryChanged(InventoryChangedEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            TransientAWSkinHandler.refresh((EntityPlayer)entity);
        }
    }

    public static void refresh(EntityPlayer player) {
        boolean changed = TransientAWSkinHandler.removeAllTransientSkins((Entity)player);
        for (ItemStack stack : GlobalInventory.getValidEquippedItems(player)) {
            changed |= TransientAWSkinHandler.tryApplyTransientSkinsFromStack(stack, (Entity)player);
        }
        if (changed) {
            GlobalInventory.syncAWWardrobeSkins((Entity)player, true, true);
        }
    }
}

