/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.event;

import com.fantasticsource.mctools.GlobalInventory;
import com.fantasticsource.mctools.items.ItemMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class InventoryChangedEvent
extends EntityEvent {
    public static LinkedHashMap<Entity, ArrayList<ItemStack>> previousContents = new LinkedHashMap();
    private final ArrayList<ItemStack> oldInventory;

    public InventoryChangedEvent(Entity entity, ArrayList<ItemStack> oldInventory) {
        super(entity);
        this.oldInventory = oldInventory;
    }

    public ArrayList<ItemStack> getOldInventory() {
        return new ArrayList<ItemStack>(this.oldInventory);
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.END) {
            return;
        }
        previousContents.entrySet().removeIf(entry -> {
            Entity entity = (Entity)entry.getKey();
            if (!entity.isAddedToWorld()) {
                return true;
            }
            for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                if (world != event.world) continue;
                return false;
            }
            return true;
        });
        for (Entity entity : event.world.field_72996_f.toArray(new Entity[0])) {
            if (!entity.isAddedToWorld()) {
                previousContents.remove(entity);
                continue;
            }
            ArrayList<ItemStack> newInventory = GlobalInventory.getAllNonSkinItems(entity);
            ArrayList<ItemStack> oldInventory = previousContents.getOrDefault(entity, new ArrayList());
            if (newInventory.size() != oldInventory.size()) {
                MinecraftForge.EVENT_BUS.post((Event)new InventoryChangedEvent(entity, oldInventory));
                previousContents.put(entity, GlobalInventory.getAllNonSkinItems(entity));
                continue;
            }
            boolean match = true;
            for (int i = 0; i < newInventory.size(); ++i) {
                if (ItemMatcher.stacksMatch(oldInventory.get(i), newInventory.get(i))) continue;
                match = false;
                break;
            }
            if (match) continue;
            MinecraftForge.EVENT_BUS.post((Event)new InventoryChangedEvent(entity, oldInventory));
            previousContents.put(entity, GlobalInventory.getAllNonSkinItems(entity));
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(InventoryChangedEvent.class);
    }
}

