/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.items;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemFilter {
    private ItemStack itemStack = null;
    private LinkedHashMap<String, String> tagsRequired = new LinkedHashMap();
    private LinkedHashMap<String, String> tagsDisallowed = new LinkedHashMap();

    private ItemFilter() {
    }

    public static ItemFilter getInstance(String itemStackString) {
        return ItemFilter.getInstance(itemStackString, false);
    }

    public static ItemFilter getInstance(String itemStackString, boolean suppressItemMissingError) {
        ItemFilter result = new ItemFilter();
        String[] registryAndNBT = itemStackString.trim().split(Pattern.quote(">"));
        if (registryAndNBT.length == 0) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.notEnoughItemFilterArgs", (Object[])new Object[]{itemStackString}));
            return null;
        }
        if (registryAndNBT.length > 2) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.tooManyItemFilterArgs", (Object[])new Object[]{itemStackString}));
            return null;
        }
        String token = registryAndNBT[0].trim();
        if (!token.equals("")) {
            ResourceLocation resourceLocation;
            int meta = 0;
            String[] innerTokens = token.split(Pattern.quote(":"));
            if (innerTokens.length > 3) {
                System.err.println(I18n.func_74837_a((String)"fantasticlib.error.badItemName", (Object[])new Object[]{token}));
                return null;
            }
            if (innerTokens.length == 3) {
                resourceLocation = new ResourceLocation(innerTokens[0], innerTokens[1]);
                try {
                    meta = Integer.parseInt(innerTokens[2]);
                }
                catch (NumberFormatException e) {
                    System.err.println(I18n.func_74837_a((String)"fantasticlib.error.badItemMeta", (Object[])new Object[]{token}));
                    return null;
                }
            }
            if (innerTokens.length == 1) {
                resourceLocation = new ResourceLocation("minecraft", innerTokens[0]);
            } else {
                try {
                    meta = Integer.parseInt(innerTokens[1]);
                    resourceLocation = new ResourceLocation("minecraft", innerTokens[0]);
                }
                catch (NumberFormatException e) {
                    meta = 0;
                    resourceLocation = new ResourceLocation(innerTokens[0], innerTokens[1]);
                }
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            if (item != null) {
                result.itemStack = new ItemStack(item, 1, meta);
            } else {
                Block block;
                Block block2 = block = ForgeRegistries.BLOCKS.containsKey(resourceLocation) ? (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation) : null;
                if (block != null) {
                    result.itemStack = new ItemStack(block, 1, meta);
                }
            }
            if (result.itemStack == null) {
                if (!suppressItemMissingError) {
                    System.err.println(I18n.func_74837_a((String)"fantasticlib.error.itemForFilterNotFound", (Object[])new Object[]{token}));
                }
                return null;
            }
        }
        if (registryAndNBT.length > 1) {
            String[] tags;
            String nbt = registryAndNBT[1].trim();
            for (Map.Entry entry : ForgeRegistries.ENCHANTMENTS.getEntries()) {
                nbt = nbt.replaceAll(((ResourceLocation)entry.getKey()).toString(), "id:" + Enchantment.func_185258_b((Enchantment)((Enchantment)entry.getValue())) + "s");
            }
            for (String tag : tags = nbt.split(Pattern.quote("&"))) {
                LinkedHashMap<String, String> map;
                if ((tag = tag.trim()).equals("")) continue;
                String[] keyValue = tag.split(Pattern.quote("="));
                if (keyValue.length > 2) {
                    System.err.println(I18n.func_74837_a((String)"fantasticlib.error.tooManyNBTValues", (Object[])new Object[]{itemStackString}));
                    return null;
                }
                String key = keyValue[0].trim();
                if (key.equals("")) continue;
                if (key.charAt(0) == '!') {
                    key = key.substring(1);
                    map = result.tagsDisallowed;
                } else {
                    map = result.tagsRequired;
                }
                map.put(key, keyValue.length == 2 ? keyValue[1].trim() : null);
            }
        }
        return result;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean matches(ItemStack stack) {
        Set<Map.Entry<String, String>> entrySet;
        if (!this.itemStack.func_77973_b().equals(stack.func_77973_b()) || !stack.func_77984_f() && this.itemStack.func_77960_j() != stack.func_77960_j()) {
            return false;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            for (Map.Entry<String, String> entry : this.tagsDisallowed.entrySet()) {
                if (!this.checkNBT((NBTBase)compound, entry.getKey().split(":", -1), entry.getValue())) continue;
                return false;
            }
        }
        if ((entrySet = this.tagsRequired.entrySet()).size() > 0) {
            if (compound == null) {
                return false;
            }
            for (Map.Entry<String, String> entry : entrySet) {
                if (this.checkNBT((NBTBase)compound, entry.getKey().split(":", -1), entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkNBT(NBTBase base, String[] keymap, String value) {
        if (keymap == null || keymap.length == 0) {
            return this.checkValue(base, value);
        }
        String key = keymap[0].trim();
        if (key.equals("")) {
            if (base instanceof NBTTagList) {
                for (NBTBase base1 : (NBTTagList)base) {
                    if (!this.checkNBT(base1, Arrays.copyOfRange(keymap, 1, keymap.length), value)) continue;
                    return true;
                }
            }
            return false;
        }
        if (base instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)base;
            if (!compound.func_74764_b(key)) {
                return false;
            }
            return this.checkNBT(compound.func_74781_a(key), Arrays.copyOfRange(keymap, 1, keymap.length), value);
        }
        return false;
    }

    private boolean checkValue(NBTBase base, String value) {
        if (value == null || value.trim().equals(base.toString())) {
            return true;
        }
        if ((value = value.replace(";", ",")).equals(base.toString())) {
            return true;
        }
        String[] newValues = value.split(",");
        if (newValues.length < 2 && !value.contains(":")) {
            return false;
        }
        for (String newValue : newValues) {
            String[] tokens = newValue.split(":");
            if (this.checkNBT(base, Arrays.copyOf(tokens, tokens.length - 1), tokens[tokens.length - 1])) continue;
            return false;
        }
        return true;
    }
}

