/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools;

public class Collision {
    public static char ON = '\u0000';
    public static char LEFT = '\u0001';
    public static char RIGHT = (char)2;

    public static boolean within(double n, double limit1, double limit2) {
        return limit1 <= n && n <= limit2 || limit2 <= n && n <= limit1;
    }

    public static boolean pointPoint(double x1, double y1, double x2, double y2) {
        return x1 == x2 && y1 == y2;
    }

    public static boolean pointRectangle(double x, double y, double rx1, double ry1, double rx2, double ry2) {
        return Collision.within(x, rx1, rx2) && Collision.within(y, ry1, ry2);
    }

    public static boolean rectangleRectangle(double r1x1, double r1y1, double r1x2, double r1y2, double r2x1, double r2y1, double r2x2, double r2y2) {
        return Collision.pointRectangle(r1x1, r1y1, r2x1, r2y1, r2x2, r2y2) || Collision.pointRectangle(r1x1, r1y2, r2x1, r2y1, r2x2, r2y2) || Collision.pointRectangle(r1x2, r1y1, r2x1, r2y1, r2x2, r2y2) || Collision.pointRectangle(r1x2, r1y2, r2x1, r2y1, r2x2, r2y2) || Collision.pointRectangle(r2x1, r2y1, r1x1, r1y1, r1x2, r1y2) || Collision.pointRectangle(r2x1, r2y2, r1x1, r1y1, r1x2, r1y2) || Collision.pointRectangle(r2x2, r2y1, r1x1, r1y1, r1x2, r1y2) || Collision.pointRectangle(r2x2, r2y2, r1x1, r1y1, r1x2, r1y2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] rectangleRectangleExt(double r1x1, double r1y1, double r1x2, double r1y2, double r2x1, double r2y1, double r2x2, double r2y2) {
        double swap;
        if (r1x1 > r1x2) {
            swap = r1x1;
            r1x1 = r1x2;
            r1x2 = swap;
        }
        if (r1y1 > r1y2) {
            swap = r1y1;
            r1y1 = r1y2;
            r1y2 = swap;
        }
        if (r2x1 > r2x2) {
            swap = r2x1;
            r2x1 = r2x2;
            r2x2 = swap;
        }
        if (r2y1 > r2y2) {
            swap = r2y1;
            r2y1 = r2y2;
            r2y2 = swap;
        }
        if (Collision.within(r1x1, r2x1, r2x2)) {
            if (Collision.within(r1x2, r2x1, r2x2)) {
                if (Collision.within(r1y1, r2y1, r2y2)) {
                    if (!Collision.within(r1y2, r2y1, r2y2)) return new double[]{r1x1, r1y1, r1x2, r2y1};
                    return new double[]{r1x1, r1y1, r1x2, r1y2};
                }
                if (Collision.within(r1y2, r2y1, r2y2)) {
                    return new double[]{r1x1, r2y2, r1x2, r1y2};
                }
                if (!Collision.within(r2y1, r1y1, r1y2)) return null;
                return new double[]{r1x1, r2y1, r1x2, r2y2};
            }
            if (Collision.within(r1y1, r2y1, r2y2)) {
                if (!Collision.within(r1y2, r2y1, r2y2)) return new double[]{r1x1, r1y1, r2x2, r2y2};
                return new double[]{r1x1, r1y1, r2x2, r1y2};
            }
            if (!Collision.within(r1y2, r2y1, r2y2)) return new double[]{r1x1, r2y1, r2x2, r2y2};
            return new double[]{r1x1, r2y1, r2x2, r1y2};
        }
        if (Collision.within(r1x2, r2x1, r2x2)) {
            if (Collision.within(r1y1, r2y1, r2y2)) {
                if (!Collision.within(r1y2, r2y1, r2y2)) return new double[]{r2x1, r1y1, r1x2, r2y2};
                return new double[]{r2x1, r1y1, r1x2, r1y2};
            }
            if (Collision.within(r1y2, r2y1, r2y2)) {
                return new double[]{r2x1, r2y1, r1x2, r1y2};
            }
            if (!Collision.within(r2y1, r1y1, r1y2)) return null;
            return new double[]{r2x1, r2y1, r1x2, r2y2};
        }
        if (Collision.within(r1y1, r2y1, r2y2)) {
            if (!Collision.within(r1y2, r2y1, r2y2)) return new double[]{r2x1, r1y1, r2x2, r2y2};
            return new double[]{r2x1, r1y1, r2x2, r1y2};
        }
        if (Collision.within(r1y2, r2y1, r2y2)) {
            return new double[]{r2x1, r2y1, r2x2, r1y2};
        }
        if (!Collision.pointRectangle(r2x1, r2y1, r1x1, r1y1, r1x2, r1y2)) return null;
        return new double[]{r2x1, r2y1, r2x2, r2y2};
    }

    public static boolean colinear(double x1, double y1, double x2, double y2, double x3, double y3) {
        return Collision.pointLine(x1, y1, x2, y2, x3, y3);
    }

    public static boolean pointLine(double x, double y, double linex1, double liney1, double linex2, double liney2) {
        return (linex1 - x) * (liney2 - y) == (linex2 - x) * (liney1 - y);
    }

    public static char pointLineSide(double x, double y, double linex1, double liney1, double linex2, double liney2, boolean upNegative) {
        double d = (linex2 - x) * (liney1 - y) - (linex1 - x) * (liney2 - y);
        if (d > 0.0) {
            if (upNegative) {
                return LEFT;
            }
            return RIGHT;
        }
        if (d < 0.0) {
            if (upNegative) {
                return RIGHT;
            }
            return LEFT;
        }
        return ON;
    }

    public static boolean pointSegment(double x, double y, double sx1, double sy1, double sx2, double sy2) {
        return Collision.pointRectangle(x, y, sx1, sy1, sx2, sy2) && Collision.pointLine(x, y, sx1, sy1, sx2, sy2);
    }

    public static boolean pointConvexPolygon(double x, double y, double[] points) {
        char otherDir = Collision.pointLineSide(points[4], points[5], points[0], points[1], points[2], points[3], false);
        for (int i = 2; i < points.length; i += 2) {
            if (Collision.pointLineSide(x, y, points[i - 2], points[i - 1], points[i], points[i + 1], true) != otherDir) continue;
            return false;
        }
        return Collision.pointLineSide(x, y, points[points.length - 2], points[points.length - 1], points[0], points[1], true) != otherDir;
    }

    public static double[] lineLine(double line1x1, double line1y1, double line1x2, double line1y2, double line2x1, double line2y1, double line2x2, double line2y2) {
        boolean line2Point;
        boolean line1Point = line1x1 == line1x2 && line1y1 == line1y2;
        boolean bl = line2Point = line2x1 == line2x2 && line2y1 == line2y2;
        if (line1Point) {
            if (line2Point) {
                if (line1x1 == line2x1 && line1y1 == line2y1) {
                    return new double[]{line1x1, line1y1};
                }
                return null;
            }
            if (Collision.pointLine(line1x1, line1y1, line2x1, line2y1, line2x2, line2y2)) {
                return new double[]{line1x1, line1y1};
            }
            return null;
        }
        if (line2Point) {
            if (Collision.pointLine(line2x1, line2y1, line1x1, line1y1, line1x2, line1y2)) {
                return new double[]{line2x1, line2y1};
            }
            return null;
        }
        double xDist2 = line2x2 - line2x1;
        double yDist1 = line1y2 - line1y1;
        double xDist1 = line1x2 - line1x1;
        double yDist2 = line2y2 - line2y1;
        double denominator = -xDist2 * yDist1 + xDist1 * yDist2;
        if (denominator == 0.0) {
            if (Collision.colinear(line1x1, line1y1, line1x2, line1y2, line2x1, line2y1)) {
                return new double[]{Double.NaN, Double.NaN};
            }
            return null;
        }
        double numerator1 = xDist2 * (line1y1 - line2y1) - yDist2 * (line1x1 - line2x1);
        double scalar1 = numerator1 / denominator;
        return new double[]{line1x1 + scalar1 * xDist1, line1y1 + scalar1 * yDist1};
    }

    public static double[] segmentLine(double sx1, double sy1, double sx2, double sy2, double lx1, double ly1, double lx2, double ly2) {
        if (lx1 == lx2 && ly1 == ly2) {
            if (Collision.pointSegment(lx1, ly1, sx1, sy1, sx2, sy2)) {
                return new double[]{lx1, ly1};
            }
            return null;
        }
        if (sx1 == sx2 && sy1 == sy2 && Collision.pointLine(sx1, sy1, lx1, ly1, lx2, ly2)) {
            return new double[]{sx1, sy1};
        }
        double[] p1 = Collision.lineLine(lx1, ly1, lx2, ly2, sx1, sy1, sx2, sy2);
        if (p1 == null) {
            return null;
        }
        if (Double.isNaN(p1[1])) {
            return new double[]{sx1, sy1, sx2, sy2};
        }
        if (Collision.pointRectangle(p1[0], p1[1], sx1, sy1, sx2, sy2)) {
            return p1;
        }
        return null;
    }

    public static boolean segmentSegment(double s1x1, double s1y1, double s1x2, double s1y2, double s2x1, double s2y1, double s2x2, double s2y2) {
        return Collision.segmentSegmentExt(s1x1, s1y1, s1x2, s1y2, s2x1, s2y1, s2x2, s2y2)[0] >= 8.0;
    }

    public static double[] segmentSegmentExt(double s1x1, double s1y1, double s1x2, double s1y2, double s2x1, double s2y1, double s2x2, double s2y2) {
        double xDist2 = s2x2 - s2x1;
        double yDist1 = s1y2 - s1y1;
        double xDist1 = s1x2 - s1x1;
        double yDist2 = s2y2 - s2y1;
        double denominator = -xDist2 * yDist1 + xDist1 * yDist2;
        if (denominator == 0.0) {
            if (xDist1 == 0.0 && yDist1 == 0.0) {
                if (xDist2 == 0.0 && yDist2 == 0.0) {
                    if (s1x1 != s2x1 || s1y1 != s2y1) {
                        return new double[]{0.0};
                    }
                    return new double[]{8.0, s1x1, s1y1};
                }
                if (Collision.pointSegment(s1x1, s1y1, s2x1, s2y1, s2x2, s2y2)) {
                    return new double[]{10.0, s1x1, s1y1};
                }
                return new double[]{2.0};
            }
            if (xDist2 == 0.0 && yDist2 == 0.0) {
                if (Collision.pointSegment(s2x1, s2y1, s1x1, s1y1, s1x2, s1y2)) {
                    return new double[]{9.0, s2x1, s2y1};
                }
                return new double[]{1.0};
            }
            if (!Collision.colinear(s1x1, s1y1, s1x2, s1y2, s2x1, s2y1)) {
                return new double[]{4.0};
            }
            boolean s1p1ONs2 = Collision.pointRectangle(s1x1, s1y1, s2x1, s2y1, s2x2, s2y2);
            boolean s1p2ONs2 = Collision.pointRectangle(s1x2, s1y2, s2x1, s2y1, s2x2, s2y2);
            boolean s2p1ONs1 = Collision.pointRectangle(s2x1, s2y1, s1x1, s1y1, s1x2, s1y2);
            boolean s2p2ONs1 = Collision.pointRectangle(s2x2, s2y2, s1x1, s1y1, s1x2, s1y2);
            double[] result = new double[5];
            if (s1p1ONs2 && s1p2ONs2) {
                result[0] = 31.0;
                result[1] = s1x1;
                result[2] = s1y1;
                result[3] = s1x2;
                result[4] = s1y2;
                return result;
            }
            if (s2p1ONs1 && s2p2ONs1) {
                result[0] = 31.0;
                if (s1x2 - s1x1 < 0.0 && s2x2 - s2x1 < 0.0 || s1x2 - s1x1 > 0.0 && s2x2 - s2x1 > 0.0 || s1y2 - s1y1 < 0.0 && s2y2 - s2y1 < 0.0 || s1y2 - s1y1 > 0.0 && s2y2 - s2y1 > 0.0) {
                    result[1] = s2x1;
                    result[2] = s2y1;
                    result[3] = s2x2;
                    result[4] = s2y2;
                } else {
                    result[1] = s2x2;
                    result[2] = s2y2;
                    result[3] = s2x1;
                    result[4] = s2y1;
                }
                return result;
            }
            result[0] = 15.0;
            if (s1p1ONs2) {
                result[1] = s1x1;
                result[2] = s1y1;
                if (s2p1ONs1) {
                    result[3] = s2x1;
                    result[4] = s2y1;
                } else {
                    result[3] = s2x2;
                    result[4] = s2y2;
                }
            } else {
                result[3] = s1x2;
                result[4] = s1y2;
                if (s2p1ONs1) {
                    result[1] = s2x1;
                    result[2] = s2y1;
                } else {
                    result[1] = s2x2;
                    result[2] = s2y2;
                }
            }
            if (result[1] != result[3] || result[2] != result[4]) {
                result[0] = result[0] + 16.0;
            }
            return result;
        }
        double numerator1 = xDist2 * (s1y1 - s2y1) - yDist2 * (s1x1 - s2x1);
        double numerator2 = -yDist1 * (s1x1 - s2x1) + xDist1 * (s1y1 - s2y1);
        if (denominator > 0.0) {
            if (numerator2 >= 0.0 && numerator2 <= denominator && numerator1 >= 0.0 && numerator1 <= denominator) {
                double scalar1 = numerator1 / denominator;
                return new double[]{11.0, s1x1 + scalar1 * xDist1, s1y1 + scalar1 * yDist1};
            }
        } else if (numerator2 >= denominator && numerator2 <= 0.0 && numerator1 >= denominator && numerator1 <= 0.0) {
            double scalar1 = numerator1 / denominator;
            return new double[]{11.0, s1x1 + scalar1 * xDist1, s1y1 + scalar1 * yDist1};
        }
        return new double[]{3.0};
    }

    public static double[] lineRectangle(double x1, double y1, double x2, double y2, double rx1, double ry1, double rx2, double ry2) {
        if (x1 == x2 && y1 == y2) {
            if (Collision.pointRectangle(x1, y1, rx1, ry1, rx2, ry2)) {
                return new double[]{x1, y1};
            }
            return null;
        }
        if (rx1 == rx2) {
            if (ry1 == ry2) {
                if (Collision.pointLine(rx1, ry1, x1, y1, x2, y2)) {
                    return new double[]{rx1, ry1};
                }
                return null;
            }
            return Collision.segmentLine(rx1, ry1, rx2, ry2, x1, y1, x2, y2);
        }
        if (ry1 == ry2) {
            return Collision.segmentLine(rx1, ry1, rx2, ry2, x1, y1, x2, y2);
        }
        double[] points = Collision.segmentLine(rx1, ry1, rx2, ry1, x1, y1, x2, y2);
        double[] result = new double[4];
        boolean onePoint = false;
        if (points != null) {
            if (points.length == 4) {
                return points;
            }
            result[0] = points[0];
            result[1] = points[1];
            onePoint = true;
        }
        if ((points = Collision.segmentLine(rx1, ry2, rx2, ry2, x1, y1, x2, y2)) != null) {
            if (points.length == 4) {
                return points;
            }
            if (onePoint) {
                result[2] = points[0];
                result[3] = points[1];
                return result;
            }
            result[0] = points[0];
            result[1] = points[1];
            onePoint = true;
        }
        if ((points = Collision.segmentLine(rx1, ry1, rx1, ry2, x1, y1, x2, y2)) != null) {
            if (points.length == 4) {
                return points;
            }
            if (onePoint) {
                if (points[0] != result[0] || points[1] != result[1]) {
                    result[2] = points[0];
                    result[3] = points[1];
                    return result;
                }
            } else {
                result[0] = points[0];
                result[1] = points[1];
                onePoint = true;
            }
        }
        if ((points = Collision.segmentLine(rx2, ry1, rx2, ry2, x1, y1, x2, y2)) != null) {
            if (points.length == 4) {
                return points;
            }
            if (onePoint) {
                if (points[0] != result[0] || points[1] != result[1]) {
                    result[2] = points[0];
                    result[3] = points[1];
                    return result;
                }
            } else {
                result[0] = points[0];
                result[1] = points[1];
                onePoint = true;
            }
        }
        if (onePoint) {
            return new double[]{result[0], result[1]};
        }
        return null;
    }

    public static double[] segmentRectangle(double x1, double y1, double x2, double y2, double rx1, double ry1, double rx2, double ry2) {
        if (x1 == x2 && y1 == y2) {
            if (Collision.pointRectangle(x1, y1, rx1, ry1, rx2, ry2)) {
                return new double[]{x1, y1};
            }
            return null;
        }
        if (rx1 == rx2) {
            if (ry1 == ry2) {
                if (Collision.pointSegment(rx1, ry1, x1, y1, x2, y2)) {
                    return new double[]{rx1, ry1};
                }
                return null;
            }
            double[] result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx2, ry2);
            if (result.length == 1) {
                return null;
            }
            if (result.length == 3) {
                return new double[]{result[1], result[2]};
            }
            return new double[]{result[1], result[2], result[3], result[4]};
        }
        if (ry1 == ry2) {
            double[] result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx2, ry2);
            if (result.length == 1) {
                return null;
            }
            if (result.length == 3) {
                return new double[]{result[1], result[2]};
            }
            return new double[]{result[1], result[2], result[3], result[4]};
        }
        if (Collision.pointRectangle(x1, y1, rx1, ry1, rx2, ry2)) {
            if (Collision.pointRectangle(x2, y2, rx1, ry1, rx2, ry2)) {
                return new double[]{x1, y1, x2, y2};
            }
            double[] result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx2, ry1);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result[1] != x1 || result[2] != y1) {
                return new double[]{x1, y1, result[1], result[2]};
            }
            result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry2, rx2, ry2);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result[1] != x1 || result[2] != y1) {
                return new double[]{x1, y1, result[1], result[2]};
            }
            result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx1, ry2);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result[1] != x1 || result[2] != y1) {
                return new double[]{x1, y1, result[1], result[2]};
            }
            result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx2, ry1, rx2, ry2);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result[1] != x1 || result[2] != y1) {
                return new double[]{x1, y1, result[1], result[2]};
            }
            return new double[]{x1, y1};
        }
        if (Collision.pointRectangle(x2, y2, rx1, ry1, rx2, ry2)) {
            double[] result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx2, ry1);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result[1] != x2 || result[2] != y2) {
                return new double[]{result[1], result[2], x2, y2};
            }
            result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry2, rx2, ry2);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result[1] != x2 || result[2] != y2) {
                return new double[]{result[1], result[2], x2, y2};
            }
            result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx1, ry2);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result[1] != x2 || result[2] != y2) {
                return new double[]{result[1], result[2], x2, y2};
            }
            result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx2, ry1, rx2, ry2);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result[1] != x2 || result[2] != y2) {
                return new double[]{result[1], result[2], x2, y2};
            }
            return new double[]{x2, y2};
        }
        double[] result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx2, ry1);
        if (result.length == 5) {
            return new double[]{result[1], result[2], result[3], result[4]};
        }
        double[] prevResult = null;
        if (result.length == 3) {
            prevResult = result;
        }
        if ((result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry2, rx2, ry2)).length == 5) {
            return new double[]{result[1], result[2], result[3], result[4]};
        }
        if (result.length == 3) {
            if (prevResult == null) {
                prevResult = result;
            } else if (prevResult[1] != result[1] || prevResult[2] != result[2]) {
                double[] nearest = Collision.pointListNearest(x1, y1, prevResult[1], prevResult[2], result[1], result[2]);
                if (result[1] != nearest[0] || result[2] != nearest[1]) {
                    return new double[]{nearest[0], nearest[1], result[1], result[2]};
                }
                return new double[]{nearest[0], nearest[1], prevResult[1], prevResult[2]};
            }
        }
        if ((result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx1, ry2)).length == 5) {
            return new double[]{result[1], result[2], result[3], result[4]};
        }
        if (result.length == 3) {
            if (prevResult == null) {
                prevResult = result;
            } else if (prevResult[1] != result[1] || prevResult[2] != result[2]) {
                double[] nearest = Collision.pointListNearest(x1, y1, prevResult[1], prevResult[2], result[1], result[2]);
                if (result[1] != nearest[0] || result[2] != nearest[1]) {
                    return new double[]{nearest[0], nearest[1], result[1], result[2]};
                }
                return new double[]{nearest[0], nearest[1], prevResult[1], prevResult[2]};
            }
        }
        if ((result = Collision.segmentSegmentExt(x1, y1, x2, y2, rx1, ry1, rx1, ry2)).length == 5) {
            return new double[]{result[1], result[2], result[3], result[4]};
        }
        if (result.length == 3) {
            if (prevResult == null || prevResult[1] == result[1] && prevResult[2] == result[2]) {
                return new double[]{result[1], result[2]};
            }
            double[] nearest = Collision.pointListNearest(x1, y1, prevResult[1], prevResult[2], result[1], result[2]);
            if (result[1] != nearest[0] || result[2] != nearest[1]) {
                return new double[]{nearest[0], nearest[1], result[1], result[2]};
            }
            return new double[]{nearest[0], nearest[1], prevResult[1], prevResult[2]};
        }
        if (prevResult != null) {
            return new double[]{prevResult[1], prevResult[2]};
        }
        return null;
    }

    public static double[] segmentConvexPolygon(double x1, double y1, double x2, double y2, double[] points) {
        double[] result;
        if (x1 == x2 && y1 == y2) {
            if (Collision.pointConvexPolygon(x1, y1, points)) {
                return new double[]{x1, y1};
            }
            return null;
        }
        if (Collision.pointConvexPolygon(x1, y1, points)) {
            double[] result2;
            if (Collision.pointConvexPolygon(x2, y2, points)) {
                return new double[]{x1, y1, x2, y2};
            }
            for (int i = 2; i < points.length; i += 2) {
                result2 = Collision.segmentSegmentExt(x1, y1, x2, y2, points[i - 2], points[i - 1], points[i], points[i + 1]);
                if (result2.length == 5) {
                    return new double[]{result2[1], result2[2], result2[3], result2[4]};
                }
                if (result2.length != 3 || result2[1] == x1 && result2[2] == y1) continue;
                return new double[]{x1, y1, result2[1], result2[2]};
            }
            result2 = Collision.segmentSegmentExt(x1, y1, x2, y2, points[points.length - 2], points[points.length - 1], points[0], points[1]);
            if (result2.length == 5) {
                return new double[]{result2[1], result2[2], result2[3], result2[4]};
            }
            if (result2.length == 3 && (result2[1] != x1 || result2[2] != y1)) {
                return new double[]{x1, y1, result2[1], result2[2]};
            }
            return new double[]{x1, y1};
        }
        if (Collision.pointConvexPolygon(x2, y2, points)) {
            double[] result3;
            for (int i = 2; i < points.length; i += 2) {
                result3 = Collision.segmentSegmentExt(x1, y1, x2, y2, points[i - 2], points[i - 1], points[i], points[i + 1]);
                if (result3.length == 5) {
                    return new double[]{result3[1], result3[2], result3[3], result3[4]};
                }
                if (result3.length != 3 || result3[1] == x2 && result3[2] == y2) continue;
                return new double[]{result3[1], result3[2], x2, y2};
            }
            result3 = Collision.segmentSegmentExt(x1, y1, x2, y2, points[points.length - 2], points[points.length - 1], points[0], points[1]);
            if (result3.length == 5) {
                return new double[]{result3[1], result3[2], result3[3], result3[4]};
            }
            if (result3.length == 3 && (result3[1] != x2 || result3[2] != y2)) {
                return new double[]{result3[1], result3[2], x2, y2};
            }
            return new double[]{x2, y2};
        }
        double[] prevResult = null;
        for (int i = 2; i < points.length; i += 2) {
            result = Collision.segmentSegmentExt(x1, y1, x2, y2, points[i - 2], points[i - 1], points[i], points[i + 1]);
            if (result.length == 5) {
                return new double[]{result[1], result[2], result[3], result[4]};
            }
            if (result.length != 3) continue;
            if (prevResult == null) {
                prevResult = result;
                continue;
            }
            if (result[1] == prevResult[1] && result[2] == prevResult[2]) continue;
            double[] nearest = Collision.pointListNearest(x1, y1, result[1], result[2], prevResult[1], prevResult[2]);
            if (result[1] != nearest[0] || result[2] != nearest[1]) {
                return new double[]{nearest[0], nearest[1], result[1], result[2]};
            }
            return new double[]{nearest[0], nearest[1], prevResult[1], prevResult[2]};
        }
        result = Collision.segmentSegmentExt(x1, y1, x2, y2, points[points.length - 2], points[points.length - 1], points[0], points[1]);
        if (result.length == 5) {
            return new double[]{result[1], result[2], result[3], result[4]};
        }
        if (result.length == 3) {
            if (prevResult == null || result[1] == prevResult[1] && result[2] == prevResult[2]) {
                return new double[]{result[1], result[2]};
            }
            double[] nearest = Collision.pointListNearest(x1, y1, result[1], result[2], prevResult[1], prevResult[2]);
            if (result[1] != nearest[0] || result[2] != nearest[1]) {
                return new double[]{nearest[0], nearest[1], result[1], result[2]};
            }
            return new double[]{nearest[0], nearest[1], prevResult[1], prevResult[2]};
        }
        return null;
    }

    public static double[][] segmentConvexPolygonExt(double x1, double y1, double x2, double y2, double[] points) {
        double[] nearest;
        double[] result;
        if (x1 == x2 && y1 == y2) {
            if (Collision.pointConvexPolygon(x1, y1, points)) {
                return new double[][]{{x1, y1}, null, null};
            }
            return null;
        }
        boolean startCoords = false;
        boolean endCoords = false;
        double[] finalResult = new double[4];
        double[] startSides = null;
        double[] midSide = null;
        double[] endSides = null;
        if (Collision.pointConvexPolygon(x1, y1, points)) {
            double[] result2;
            if (Collision.pointConvexPolygon(x2, y2, points)) {
                return new double[][]{{x1, y1, x2, y2}, null, null};
            }
            finalResult[0] = x1;
            finalResult[1] = y1;
            for (int i = 2; i < points.length; i += 2) {
                result2 = Collision.segmentSegmentExt(x1, y1, x2, y2, points[i - 2], points[i - 1], points[i], points[i + 1]);
                if (result2.length == 5) {
                    finalResult[2] = result2[3];
                    finalResult[3] = result2[4];
                    endCoords = true;
                    midSide = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                }
                if (result2.length != 3) continue;
                if (result2[1] != x1 || result2[2] != y1) {
                    finalResult[2] = result2[1];
                    finalResult[3] = result2[2];
                    endCoords = true;
                    if (endSides == null) {
                        endSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                        continue;
                    }
                    result2 = endSides;
                    endSides = new double[]{result2[0], result2[1], result2[2], result2[3], points[i - 2], points[i - 1], points[i], points[i + 1]};
                    continue;
                }
                if (startSides == null) {
                    startSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                    continue;
                }
                result2 = startSides;
                startSides = new double[]{result2[0], result2[1], result2[2], result2[3], points[i - 2], points[i - 1], points[i], points[i + 1]};
            }
            result2 = Collision.segmentSegmentExt(x1, y1, x2, y2, points[points.length - 2], points[points.length - 1], points[0], points[1]);
            if (result2.length == 5) {
                finalResult[2] = result2[3];
                finalResult[3] = result2[4];
                endCoords = true;
                midSide = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
            }
            if (result2.length == 3) {
                if (result2[1] != x1 || result2[2] != y1) {
                    finalResult[2] = result2[1];
                    finalResult[3] = result2[2];
                    endCoords = true;
                    if (endSides == null) {
                        endSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
                    } else {
                        result2 = endSides;
                        endSides = new double[]{result2[0], result2[1], result2[2], result2[3], points[points.length - 2], points[points.length - 1], points[0], points[1]};
                    }
                } else if (startSides == null) {
                    startSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
                } else {
                    result2 = startSides;
                    startSides = new double[]{result2[0], result2[1], result2[2], result2[3], points[points.length - 2], points[points.length - 1], points[0], points[1]};
                }
            }
            if (endCoords) {
                return new double[][]{finalResult, startSides, midSide, endSides};
            }
            return new double[][]{{finalResult[0], finalResult[1]}, startSides, null, null};
        }
        if (Collision.pointConvexPolygon(x2, y2, points)) {
            double[] result3;
            finalResult[2] = x2;
            finalResult[3] = y2;
            for (int i = 2; i < points.length; i += 2) {
                result3 = Collision.segmentSegmentExt(x1, y1, x2, y2, points[i - 2], points[i - 1], points[i], points[i + 1]);
                if (result3.length == 5) {
                    finalResult[0] = result3[1];
                    finalResult[1] = result3[2];
                    startCoords = true;
                    midSide = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                }
                if (result3.length != 3) continue;
                if (result3[1] != x2 || result3[2] != y2) {
                    finalResult[0] = result3[1];
                    finalResult[1] = result3[2];
                    startCoords = true;
                    if (startSides == null) {
                        startSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                        continue;
                    }
                    result3 = startSides;
                    startSides = new double[]{result3[0], result3[1], result3[2], result3[3], points[i - 2], points[i - 1], points[i], points[i + 1]};
                    continue;
                }
                if (endSides == null) {
                    endSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                    continue;
                }
                result3 = endSides;
                endSides = new double[]{result3[0], result3[1], result3[2], result3[3], points[i - 2], points[i - 1], points[i], points[i + 1]};
            }
            result3 = Collision.segmentSegmentExt(x1, y1, x2, y2, points[points.length - 2], points[points.length - 1], points[0], points[1]);
            if (result3.length == 5) {
                finalResult[0] = result3[1];
                finalResult[1] = result3[2];
                startCoords = true;
                midSide = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
            }
            if (result3.length == 3) {
                if (result3[1] != x2 || result3[2] != y2) {
                    finalResult[0] = result3[1];
                    finalResult[1] = result3[2];
                    startCoords = true;
                    if (startSides == null) {
                        startSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
                    } else {
                        result3 = startSides;
                        startSides = new double[]{result3[0], result3[1], result3[2], result3[3], points[points.length - 2], points[points.length - 1], points[0], points[1]};
                    }
                } else if (endSides == null) {
                    endSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
                } else {
                    result3 = endSides;
                    endSides = new double[]{result3[0], result3[1], result3[2], result3[3], points[points.length - 2], points[points.length - 1], points[0], points[1]};
                }
            }
            if (startCoords) {
                return new double[][]{finalResult, startSides, midSide, endSides};
            }
            return new double[][]{{finalResult[2], finalResult[3]}, endSides, null, null};
        }
        for (int i = 2; i < points.length; i += 2) {
            result = Collision.segmentSegmentExt(x1, y1, x2, y2, points[i - 2], points[i - 1], points[i], points[i + 1]);
            if (result.length == 5) {
                if (startCoords && (finalResult[0] != result[1] || finalResult[1] != result[2])) {
                    endSides = startSides;
                    startSides = null;
                }
                finalResult[0] = result[1];
                finalResult[1] = result[2];
                finalResult[2] = result[3];
                finalResult[3] = result[4];
                startCoords = true;
                endCoords = true;
                midSide = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
            }
            if (result.length != 3) continue;
            if (!startCoords) {
                finalResult[0] = result[1];
                finalResult[1] = result[2];
                startCoords = true;
                startSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                continue;
            }
            if (finalResult[0] == result[1] && finalResult[1] == result[2]) {
                if (startSides == null) {
                    startSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                    continue;
                }
                result = startSides;
                startSides = new double[]{result[0], result[1], result[2], result[3], points[i - 2], points[i - 1], points[i], points[i + 1]};
                continue;
            }
            if (endCoords && finalResult[2] == result[1] && finalResult[3] == result[2]) {
                if (endSides == null) {
                    endSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                    continue;
                }
                result = endSides;
                endSides = new double[]{result[0], result[1], result[2], result[3], points[i - 2], points[i - 1], points[i], points[i + 1]};
                continue;
            }
            endCoords = true;
            nearest = Collision.pointListNearest(x1, y1, finalResult[0], finalResult[1], result[1], result[2]);
            if (nearest[0] == finalResult[0] && nearest[1] == finalResult[1]) {
                finalResult[2] = result[1];
                finalResult[3] = result[2];
                endSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
                continue;
            }
            finalResult[2] = finalResult[0];
            finalResult[3] = finalResult[1];
            finalResult[0] = result[1];
            finalResult[1] = result[2];
            endSides = startSides;
            startSides = new double[]{points[i - 2], points[i - 1], points[i], points[i + 1]};
        }
        result = Collision.segmentSegmentExt(x1, y1, x2, y2, points[points.length - 2], points[points.length - 1], points[0], points[1]);
        if (result.length == 5) {
            if (startCoords && (finalResult[0] != result[1] || finalResult[1] != result[2])) {
                endSides = startSides;
                startSides = null;
            }
            finalResult[0] = result[1];
            finalResult[1] = result[2];
            finalResult[2] = result[3];
            finalResult[3] = result[4];
            startCoords = true;
            endCoords = true;
            midSide = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
        }
        if (result.length == 3) {
            if (!startCoords) {
                finalResult[0] = result[1];
                finalResult[1] = result[2];
                startCoords = true;
                startSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
            } else if (finalResult[0] == result[1] && finalResult[1] == result[2]) {
                if (startSides == null) {
                    startSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
                } else {
                    result = startSides;
                    startSides = new double[]{result[0], result[1], result[2], result[3], points[points.length - 2], points[points.length - 1], points[0], points[1]};
                }
            } else if (endCoords && finalResult[2] == result[1] && finalResult[3] == result[2]) {
                if (endSides == null) {
                    endSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
                } else {
                    result = endSides;
                    endSides = new double[]{result[0], result[1], result[2], result[3], points[points.length - 2], points[points.length - 1], points[0], points[1]};
                }
            } else {
                endCoords = true;
                nearest = Collision.pointListNearest(x1, y1, finalResult[0], finalResult[1], result[1], result[2]);
                if (nearest[0] == finalResult[0] && nearest[1] == finalResult[1]) {
                    finalResult[2] = result[1];
                    finalResult[3] = result[2];
                    endSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
                } else {
                    finalResult[2] = finalResult[0];
                    finalResult[3] = finalResult[1];
                    finalResult[0] = result[1];
                    finalResult[1] = result[2];
                    endSides = startSides;
                    startSides = new double[]{points[points.length - 2], points[points.length - 1], points[0], points[1]};
                }
            }
        }
        if (!endCoords) {
            if (!startCoords) {
                return null;
            }
            return new double[][]{{finalResult[0], finalResult[1]}, startSides, null, null};
        }
        return new double[][]{finalResult, startSides, midSide, endSides};
    }

    public static double[] lineConvexPolygon(double x1, double y1, double x2, double y2, double[] points) {
        double[] result;
        if (x1 == x2 && y1 == y2) {
            if (Collision.pointConvexPolygon(x1, y1, points)) {
                return new double[]{x1, y1};
            }
            return null;
        }
        double[] prevResult = null;
        for (int i = 2; i < points.length; i += 2) {
            result = Collision.segmentLine(points[i - 2], points[i - 1], points[i], points[i + 1], x1, y1, x2, y2);
            if (result == null) continue;
            if (result.length == 4) {
                return result;
            }
            if (prevResult == null) {
                prevResult = result;
                continue;
            }
            if (result[0] == prevResult[0] && result[1] == prevResult[1]) continue;
            return new double[]{result[0], result[1], prevResult[1], prevResult[2]};
        }
        result = Collision.segmentLine(points[points.length - 2], points[points.length - 1], points[0], points[1], x1, y1, x2, y2);
        if (result != null) {
            if (result.length == 4) {
                return result;
            }
            if (prevResult == null || result[0] == prevResult[0] && result[1] == prevResult[1]) {
                return result;
            }
            return new double[]{result[0], result[1], prevResult[1], prevResult[2]};
        }
        return prevResult;
    }

    public static double[] pointListNearest(double x, double y, double ... arg) {
        if (arg == null || arg.length < 2) {
            return null;
        }
        double distSquared = Math.pow(x - arg[0], 2.0) + Math.pow(y - arg[1], 2.0);
        double[] result = new double[]{arg[0], arg[1]};
        int i = 2;
        while (i + 1 < arg.length) {
            double checkDistSquared = Math.pow(x - arg[i], 2.0) + Math.pow(y - arg[i + 1], 2.0);
            if (checkDistSquared < distSquared) {
                distSquared = checkDistSquared;
                result[0] = arg[i];
                result[1] = arg[i + 1];
            }
            i += 2;
        }
        return result;
    }

    public static boolean rectangleConvexPolygon(double x1, double y1, double x2, double y2, double[] points) {
        if (x1 == x2) {
            if (y1 == y2) {
                return Collision.pointConvexPolygon(x1, y1, points);
            }
            return Collision.segmentConvexPolygon(x1, y1, x2, y2, points) != null;
        }
        if (y1 == y2) {
            return Collision.segmentConvexPolygon(x1, y1, x2, y2, points) != null;
        }
        return Collision.pointRectangle(points[0], points[1], x1, y1, x2, y2) || Collision.segmentConvexPolygon(x1, y1, x2, y1, points) != null || Collision.segmentConvexPolygon(x2, y1, x2, y2, points) != null || Collision.segmentConvexPolygon(x2, y2, x1, y2, points) != null || Collision.segmentConvexPolygon(x1, y2, x1, y1, points) != null;
    }

    public static boolean convexPolygonConvexPolygon(double[] points1, double[] points2) {
        for (int i = 2; i < points1.length; i += 2) {
            if (Collision.segmentConvexPolygon(points1[i - 2], points1[i - 1], points1[i], points1[i + 1], points2) == null) continue;
            return true;
        }
        return Collision.segmentConvexPolygon(points1[points1.length - 2], points1[points1.length - 1], points1[0], points1[1], points2) != null;
    }

    public static double[] pointLineNearest(double x, double y, double x1, double y1, double x2, double y2) {
        return Collision.lineLine(x1, y1, x2, y2, x, y, x + y1 - y2, y - x1 + x2);
    }

    public static double[] pointSegmentNearest(double x, double y, double x1, double y1, double x2, double y2) {
        double[] p1 = Collision.pointLineNearest(x, y, x1, y1, x2, y2);
        if (p1 == null) {
            return null;
        }
        if (Collision.pointRectangle(p1[0], p1[1], x1, y1, x2, y2)) {
            return p1;
        }
        if (Math.pow(x1 - x, 2.0) + Math.pow(y1 - y, 2.0) < Math.pow(x2 - x, 2.0) + Math.pow(y2 - y, 2.0)) {
            return new double[]{x1, y1};
        }
        return new double[]{x2, y2};
    }

    public static double[] pointRectangleNearest(double x, double y, double x1, double y1, double x2, double y2) {
        double[] result = new double[2];
        if (x1 > x2) {
            result[0] = x1;
            x1 = x2;
            x2 = result[0];
        }
        if (y1 > y2) {
            result[0] = y1;
            y1 = y2;
            y2 = result[0];
        }
        result[0] = x2;
        result[1] = y2;
        if (x < x1) {
            result[0] = x1;
        } else if (x < x2) {
            result[0] = x;
        }
        if (y < y1) {
            result[1] = y1;
        } else if (y < y2) {
            result[1] = y;
        }
        return result;
    }

    public static double[] pointConvexPolygonNearest(double x, double y, double[] points) {
        if (Collision.pointConvexPolygon(x, y, points)) {
            return new double[]{x, y};
        }
        double[] result = new double[points.length];
        double[] point = Collision.pointSegmentNearest(x, y, points[points.length - 2], points[points.length - 1], points[0], points[1]);
        System.arraycopy(point, 0, result, 0, 2);
        for (int i = 2; i < points.length; i += 2) {
            point = Collision.pointSegmentNearest(x, y, points[i - 2], points[i - 1], points[i], points[i + 1]);
            System.arraycopy(point, 0, result, i, 2);
        }
        return Collision.pointListNearest(x, y, result);
    }

    public static boolean pointCircle(double x, double y, double cx, double cy, double r) {
        return Math.pow(cx - x, 2.0) + Math.pow(cy - y, 2.0) <= Math.pow(r, 2.0);
    }

    public static double[] lineCircle(double x1, double y1, double x2, double y2, double cx, double cy, double r) {
        if (x1 == x2 && y1 == y2) {
            if (Collision.pointCircle(x1, y1, cx, cy, r)) {
                return new double[]{x1, y1};
            }
            return null;
        }
        double rSquared = Math.pow(r, 2.0);
        double[] p1 = Collision.pointLineNearest(cx, cy, x1, y1, x2, y2);
        double p1dSquared = Math.pow(p1[0] - cx, 2.0) + Math.pow(p1[1] - cy, 2.0);
        if (p1dSquared > rSquared) {
            return null;
        }
        if (p1dSquared < rSquared) {
            double legLength = Math.sqrt(rSquared - p1dSquared);
            double p1d2 = Math.sqrt(Math.pow(p1[0] - x1, 2.0) + Math.pow(p1[1] - y1, 2.0));
            if (p1d2 != 0.0) {
                double ratio = legLength / p1d2;
                double xd = ratio * (p1[0] - x1);
                double yd = ratio * (p1[1] - y1);
                if (x2 >= x1 && Collision.pointCircle(x1, y1, cx, cy, r)) {
                    return new double[]{p1[0] + xd, p1[1] + yd, p1[0] - xd, p1[1] - yd};
                }
                return new double[]{p1[0] - xd, p1[1] - yd, p1[0] + xd, p1[1] + yd};
            }
            p1d2 = Math.sqrt(Math.pow(p1[0] - x2, 2.0) + Math.pow(p1[1] - y2, 2.0));
            double ratio = legLength / p1d2;
            double xd = ratio * (p1[1] - x2);
            double yd = ratio * (p1[2] - y2);
            return new double[]{p1[0] + xd, p1[1] + yd, p1[0] - xd, p1[1] - yd};
        }
        return p1;
    }

    public static double[] segmentCircle(double x1, double y1, double x2, double y2, double cx, double cy, double r) {
        if (x1 == x2 && y1 == y2) {
            if (Collision.pointCircle(x1, y1, cx, cy, r)) {
                return new double[]{x1, y1};
            }
            return null;
        }
        double[] points = Collision.lineCircle(x1, y1, x2, y2, cx, cy, r);
        if (points == null) {
            return null;
        }
        if (points.length == 2) {
            if (Collision.pointRectangle(points[0], points[1], x1, y1, x2, y2)) {
                return points;
            }
            return null;
        }
        if (Collision.pointRectangle(x1, y1, points[0], points[1], points[2], points[3])) {
            if (Collision.pointRectangle(x2, y2, points[0], points[1], points[2], points[3])) {
                return new double[]{x1, y1, x2, y2};
            }
            double[] nearest = Collision.pointListNearest(x2, y2, points[0], points[1], points[2], points[3]);
            if (nearest[0] != x1 || nearest[1] != y1) {
                return new double[]{x1, y1, nearest[0], nearest[1]};
            }
            return new double[]{x1, y1};
        }
        if (Collision.pointRectangle(x2, y2, points[0], points[1], points[2], points[3])) {
            double[] nearest = Collision.pointListNearest(x1, y1, points[0], points[1], points[2], points[3]);
            if (nearest[0] != x2 || nearest[1] != y2) {
                return new double[]{nearest[0], nearest[1], x2, y2};
            }
            return new double[]{x2, y2};
        }
        if (points[0] == x1 && points[1] == y1 && points[2] == x2 && points[3] == y2 || points[0] == x2 && points[1] == y2 && points[2] == x1 && points[3] == y1) {
            return points;
        }
        return null;
    }

    public static boolean rectangleCircle(double x1, double y1, double x2, double y2, double cx, double cy, double r) {
        if (Collision.pointRectangle(cx, cy, x1, y1, x2, y2)) {
            return true;
        }
        if (Collision.segmentCircle(x1, y1, x2, y1, cx, cy, r) != null) {
            return true;
        }
        if (Collision.segmentCircle(x1, y2, x2, y2, cx, cy, r) != null) {
            return true;
        }
        if (Collision.segmentCircle(x1, y1, x1, y2, cx, cy, r) != null) {
            return true;
        }
        return Collision.segmentCircle(x2, y1, x2, y2, cx, cy, r) != null;
    }

    public static boolean circleConvexPolygon(double cx, double cy, double r, double[] points) {
        if (Collision.pointConvexPolygon(cx, cy, points)) {
            return true;
        }
        if (Collision.segmentCircle(points[points.length - 2], points[points.length - 1], points[0], points[1], cx, cy, r) != null) {
            return true;
        }
        for (int i = 2; i < points.length; i += 2) {
            if (Collision.segmentCircle(points[i - 2], points[i - 1], points[i], points[i + 1], cx, cy, r) == null) continue;
            return true;
        }
        return false;
    }

    public static double[] pointCircleNearest(double x, double y, double cx, double cy, double r) {
        double[] points = Collision.segmentCircle(x, y, cx, cy, cx, cy, r);
        return new double[]{points[0], points[1]};
    }

    public static double[] circleTan2Center(double cx, double cy, double r, double l1x1, double l1y1, double l1x2, double l1y2, double l2x1, double l2y1, double l2x2, double l2y2) {
        double oldY;
        double oldX;
        if (l1x1 == l1x2 && l1y1 == l1y2 || l2x1 == l2x2 && l2y1 == l2y2) {
            return null;
        }
        double[] intersection = Collision.lineLine(l1x1, l1y1, l1x2, l1y2, l2x1, l2y1, l2x2, l2y2);
        if (intersection == null || Double.isNaN(intersection[0])) {
            return null;
        }
        double dist = Math.sqrt(Math.pow(l1x1 - l1x2, 2.0) + Math.pow(l1y1 - l1y2, 2.0));
        double ratio = r / dist;
        double dx = (l1y2 - l1y1) * ratio;
        double dy = (l1x1 - l1x2) * ratio;
        double dir = Collision.pointLineSide(cx, cy, l1x1, l1y1, l1x2, l1y2, true);
        if (dir == (double)Collision.pointLineSide(oldX = l1x1, oldY = l1y1, l1x1 += dx, l1y1 += dy, l1x2 += dx, l1y2 += dy, true)) {
            l1x1 -= dx * 2.0;
            l1x2 -= dx * 2.0;
            l1y1 -= dy * 2.0;
            l1y2 -= dy * 2.0;
        }
        dist = Math.sqrt(Math.pow(l2x1 - l2x2, 2.0) + Math.pow(l2y1 - l2y2, 2.0));
        ratio = r / dist;
        dx = (l2y2 - l2y1) * ratio;
        dy = (l2x1 - l2x2) * ratio;
        dir = Collision.pointLineSide(cx, cy, l2x1, l2y1, l2x2, l2y2, true);
        if (dir == (double)Collision.pointLineSide(oldX = l2x1, oldY = l2y1, l2x1 += dx, l2y1 += dy, l2x2 += dx, l2y2 += dy, true)) {
            l2x1 -= dx * 2.0;
            l2x2 -= dx * 2.0;
            l2y1 -= dy * 2.0;
            l2y2 -= dy * 2.0;
        }
        return Collision.lineLine(l1x1, l1y1, l1x2, l1y2, l2x1, l2y1, l2x2, l2y2);
    }

    public static double[] mirror(double x1, double y1, double x2, double y2, double[] points) {
        double[] result = new double[points.length];
        for (int i = 0; i < points.length; i += 2) {
            double[] nearest = Collision.pointLineNearest(points[i], points[i + 1], x1, y1, x2, y2);
            result[i] = nearest[0] * 2.0 - points[i];
            result[i + 1] = nearest[1] * 2.0 - points[i + 1];
        }
        return result;
    }
}

