/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.TwoClicksBuildMode;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Line;
import nl.requios.effortlessbuilding.helper.ReachHelper;

public class Wall
extends TwoClicksBuildMode {
    @Override
    protected BlockPos findSecondPos(PlayerEntity player, BlockPos firstPos, boolean skipRaytrace) {
        return Wall.findWall(player, firstPos, skipRaytrace);
    }

    public static BlockPos findWall(PlayerEntity player, BlockPos firstPos, boolean skipRaytrace) {
        Vec3d look = BuildModes.getPlayerLookVec(player);
        Vec3d start = new Vec3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>(3);
        Vec3d xBound = BuildModes.findXBound(firstPos.func_177958_n(), start, look);
        criteriaList.add(new Criteria(xBound, firstPos, start, look));
        Vec3d zBound = BuildModes.findZBound(firstPos.func_177952_p(), start, look);
        criteriaList.add(new Criteria(zBound, firstPos, start, look));
        int reach = ReachHelper.getPlacementReach(player) * 4;
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        Criteria selected = (Criteria)criteriaList.get(0);
        if (criteriaList.size() > 1) {
            for (int i = 1; i < criteriaList.size(); ++i) {
                Criteria criteria2 = (Criteria)criteriaList.get(i);
                if (!(criteria2.distToPlayerSq < selected.distToPlayerSq) || !(Math.abs(criteria2.angle) - Math.abs(selected.angle) < 3.0)) continue;
                selected = criteria2;
            }
        }
        return new BlockPos(selected.planeBound);
    }

    @Override
    protected List<BlockPos> getAllBlocks(PlayerEntity player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Wall.getWallBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    public static List<BlockPos> getWallBlocks(PlayerEntity player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (x1 == x2) {
            if (ModeOptions.getFill() == ModeOptions.ActionEnum.FULL) {
                Wall.addXWallBlocks(list, x1, y1, y2, z1, z2);
            } else {
                Wall.addXHollowWallBlocks(list, x1, y1, y2, z1, z2);
            }
        } else if (ModeOptions.getFill() == ModeOptions.ActionEnum.FULL) {
            Wall.addZWallBlocks(list, x1, x2, y1, y2, z1);
        } else {
            Wall.addZHollowWallBlocks(list, x1, x2, y1, y2, z1);
        }
        return list;
    }

    public static void addXWallBlocks(List<BlockPos> list, int x, int y1, int y2, int z1, int z2) {
        int z = z1;
        while (z1 < z2 ? z <= z2 : z >= z2) {
            int y = y1;
            while (y1 < y2 ? y <= y2 : y >= y2) {
                list.add(new BlockPos(x, y, z));
                y += y1 < y2 ? 1 : -1;
            }
            z += z1 < z2 ? 1 : -1;
        }
    }

    public static void addZWallBlocks(List<BlockPos> list, int x1, int x2, int y1, int y2, int z) {
        int x = x1;
        while (x1 < x2 ? x <= x2 : x >= x2) {
            int y = y1;
            while (y1 < y2 ? y <= y2 : y >= y2) {
                list.add(new BlockPos(x, y, z));
                y += y1 < y2 ? 1 : -1;
            }
            x += x1 < x2 ? 1 : -1;
        }
    }

    public static void addXHollowWallBlocks(List<BlockPos> list, int x, int y1, int y2, int z1, int z2) {
        Line.addZLineBlocks(list, z1, z2, x, y1);
        Line.addZLineBlocks(list, z1, z2, x, y2);
        Line.addYLineBlocks(list, y1, y2, x, z1);
        Line.addYLineBlocks(list, y1, y2, x, z2);
    }

    public static void addZHollowWallBlocks(List<BlockPos> list, int x1, int x2, int y1, int y2, int z) {
        Line.addXLineBlocks(list, x1, x2, y1, z);
        Line.addXLineBlocks(list, x1, x2, y2, z);
        Line.addYLineBlocks(list, y1, y2, x1, z);
        Line.addYLineBlocks(list, y1, y2, x2, z);
    }

    static class Criteria {
        Vec3d planeBound;
        double distToPlayerSq;
        double angle;

        Criteria(Vec3d planeBound, BlockPos firstPos, Vec3d start, Vec3d look) {
            this.planeBound = planeBound;
            this.distToPlayerSq = this.planeBound.func_178788_d(start).func_189985_c();
            Vec3d wall = this.planeBound.func_178788_d(new Vec3d((Vec3i)firstPos));
            this.angle = wall.field_72450_a * look.field_72450_a + wall.field_72449_c * look.field_72449_c;
        }

        public boolean isValid(Vec3d start, Vec3d look, int reach, PlayerEntity player, boolean skipRaytrace) {
            return BuildModes.isCriteriaValid(start, look, reach, player, skipRaytrace, this.planeBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

