/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.helper.FixedStack;
import nl.requios.effortlessbuilding.helper.InventoryHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;

public class UndoRedo {
    private static Map<UUID, FixedStack<BlockSet>> undoStacksClient = new HashMap<UUID, FixedStack<BlockSet>>();
    private static Map<UUID, FixedStack<BlockSet>> undoStacksServer = new HashMap<UUID, FixedStack<BlockSet>>();
    private static Map<UUID, FixedStack<BlockSet>> redoStacksClient = new HashMap<UUID, FixedStack<BlockSet>>();
    private static Map<UUID, FixedStack<BlockSet>> redoStacksServer = new HashMap<UUID, FixedStack<BlockSet>>();

    public static void addUndo(PlayerEntity player, BlockSet blockSet) {
        Map<UUID, FixedStack<BlockSet>> undoStacks;
        Map<UUID, FixedStack<BlockSet>> map = undoStacks = player.field_70170_p.field_72995_K ? undoStacksClient : undoStacksServer;
        if (blockSet.getCoordinates().size() != blockSet.getPreviousBlockStates().size() || blockSet.getCoordinates().size() != blockSet.getNewBlockStates().size()) {
            EffortlessBuilding.logger.error("Coordinates and blockstate lists are not equal length. Coordinates: {}. Previous blockstates: {}. New blockstates: {}.", (Object)blockSet.getCoordinates().size(), (Object)blockSet.getPreviousBlockStates().size(), (Object)blockSet.getNewBlockStates().size());
        }
        if (!undoStacks.containsKey(player.func_110124_au())) {
            undoStacks.put(player.func_110124_au(), new FixedStack<BlockSet>(new BlockSet[((Integer)BuildConfig.survivalBalancers.undoStackSize.get()).intValue()]));
        }
        undoStacks.get(player.func_110124_au()).push(blockSet);
    }

    private static void addRedo(PlayerEntity player, BlockSet blockSet) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_70170_p.field_72995_K ? redoStacksClient : redoStacksServer;
        if (!redoStacks.containsKey(player.func_110124_au())) {
            redoStacks.put(player.func_110124_au(), new FixedStack<BlockSet>(new BlockSet[((Integer)BuildConfig.survivalBalancers.undoStackSize.get()).intValue()]));
        }
        redoStacks.get(player.func_110124_au()).push(blockSet);
    }

    public static boolean undo(PlayerEntity player) {
        Map<UUID, FixedStack<BlockSet>> undoStacks;
        Map<UUID, FixedStack<BlockSet>> map = undoStacks = player.field_70170_p.field_72995_K ? undoStacksClient : undoStacksServer;
        if (!undoStacks.containsKey(player.func_110124_au())) {
            return false;
        }
        FixedStack<BlockSet> undoStack = undoStacks.get(player.func_110124_au());
        if (undoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = undoStack.pop();
        List<BlockPos> coordinates = blockSet.getCoordinates();
        List<BlockState> previousBlockStates = blockSet.getPreviousBlockStates();
        List<BlockState> newBlockStates = blockSet.getNewBlockStates();
        Vec3d hitVec = blockSet.getHitVec();
        List<ItemStack> itemStacks = UndoRedo.findItemStacksInInventory(player, previousBlockStates);
        if (player.field_70170_p.field_72995_K) {
            BlockPreviewRenderer.onBlocksBroken(coordinates, itemStacks, newBlockStates, blockSet.getSecondPos(), blockSet.getFirstPos());
        } else {
            for (int i = 0; i < coordinates.size(); ++i) {
                BlockPos coordinate = coordinates.get(i);
                ItemStack itemStack = itemStacks.get(i);
                if (previousBlockStates.get(i).equals(newBlockStates.get(i))) continue;
                BlockState previousBlockState = Blocks.field_150350_a.func_176223_P();
                if (itemStack.func_77973_b() instanceof BlockItem) {
                    previousBlockState = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P();
                }
                if (!player.field_70170_p.func_195588_v(coordinate)) continue;
                if (itemStack.func_190926_b()) {
                    itemStack = UndoRedo.findItemStackInInventory(player, previousBlockStates.get(i));
                    if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof BlockItem) {
                        previousBlockState = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P();
                    } else {
                        if (previousBlockStates.get(i).func_177230_c() != Blocks.field_150350_a) {
                            EffortlessBuilding.logTranslate(player, "", previousBlockStates.get(i).func_177230_c().func_149739_a(), " not found in inventory", true);
                        }
                        previousBlockState = Blocks.field_150350_a.func_176223_P();
                    }
                }
                if (itemStack.func_190926_b()) {
                    SurvivalHelper.breakBlock(player.field_70170_p, player, coordinate, true);
                }
                SurvivalHelper.placeBlock(player.field_70170_p, player, coordinate, previousBlockState, itemStack, Direction.UP, hitVec, true, false, false);
            }
        }
        UndoRedo.addRedo(player, blockSet);
        return true;
    }

    public static boolean redo(PlayerEntity player) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_70170_p.field_72995_K ? redoStacksClient : redoStacksServer;
        if (!redoStacks.containsKey(player.func_110124_au())) {
            return false;
        }
        FixedStack<BlockSet> redoStack = redoStacks.get(player.func_110124_au());
        if (redoStack.isEmpty()) {
            return false;
        }
        BlockSet blockSet = redoStack.pop();
        List<BlockPos> coordinates = blockSet.getCoordinates();
        List<BlockState> previousBlockStates = blockSet.getPreviousBlockStates();
        List<BlockState> newBlockStates = blockSet.getNewBlockStates();
        Vec3d hitVec = blockSet.getHitVec();
        List<ItemStack> itemStacks = UndoRedo.findItemStacksInInventory(player, newBlockStates);
        if (player.field_70170_p.field_72995_K) {
            BlockPreviewRenderer.onBlocksPlaced(coordinates, itemStacks, newBlockStates, blockSet.getFirstPos(), blockSet.getSecondPos());
        } else {
            for (int i = 0; i < coordinates.size(); ++i) {
                BlockPos coordinate = coordinates.get(i);
                ItemStack itemStack = itemStacks.get(i);
                if (previousBlockStates.get(i).equals(newBlockStates.get(i))) continue;
                BlockState newBlockState = Blocks.field_150350_a.func_176223_P();
                if (itemStack.func_77973_b() instanceof BlockItem) {
                    newBlockState = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P();
                }
                if (!player.field_70170_p.func_195588_v(coordinate)) continue;
                if (itemStack.func_190926_b()) {
                    itemStack = UndoRedo.findItemStackInInventory(player, newBlockStates.get(i));
                    if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof BlockItem) {
                        newBlockState = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P();
                    } else {
                        if (newBlockStates.get(i).func_177230_c() != Blocks.field_150350_a) {
                            EffortlessBuilding.logTranslate(player, "", newBlockStates.get(i).func_177230_c().func_149739_a(), " not found in inventory", true);
                        }
                        newBlockState = Blocks.field_150350_a.func_176223_P();
                    }
                }
                if (itemStack.func_190926_b()) {
                    SurvivalHelper.breakBlock(player.field_70170_p, player, coordinate, true);
                }
                SurvivalHelper.placeBlock(player.field_70170_p, player, coordinate, newBlockState, itemStack, Direction.UP, hitVec, true, false, false);
            }
        }
        UndoRedo.addUndo(player, blockSet);
        return true;
    }

    public static void clear(PlayerEntity player) {
        Map<UUID, FixedStack<BlockSet>> redoStacks;
        Map<UUID, FixedStack<BlockSet>> undoStacks = player.field_70170_p.field_72995_K ? undoStacksClient : undoStacksServer;
        Map<UUID, FixedStack<BlockSet>> map = redoStacks = player.field_70170_p.field_72995_K ? redoStacksClient : redoStacksServer;
        if (undoStacks.containsKey(player.func_110124_au())) {
            undoStacks.get(player.func_110124_au()).clear();
        }
        if (redoStacks.containsKey(player.func_110124_au())) {
            redoStacks.get(player.func_110124_au()).clear();
        }
    }

    private static List<ItemStack> findItemStacksInInventory(PlayerEntity player, List<BlockState> blockStates) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(blockStates.size());
        for (BlockState blockState : blockStates) {
            itemStacks.add(UndoRedo.findItemStackInInventory(player, blockState));
        }
        return itemStacks;
    }

    private static ItemStack findItemStackInInventory(PlayerEntity player, BlockState blockState) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (blockState == null) {
            return itemStack;
        }
        itemStack = InventoryHelper.findItemStackInInventory(player, blockState.func_177230_c());
        if (itemStack.func_190926_b() && !player.field_70170_p.field_72995_K) {
            List itemsDropped = Block.func_220070_a((BlockState)blockState, (ServerWorld)((ServerWorld)player.field_70170_p), (BlockPos)BlockPos.field_177992_a, null);
            for (ItemStack itemStackDropped : itemsDropped) {
                if (!(itemStackDropped.func_77973_b() instanceof BlockItem)) continue;
                Block block = ((BlockItem)itemStackDropped.func_77973_b()).func_179223_d();
                itemStack = InventoryHelper.findItemStackInInventory(player, block);
            }
        }
        return itemStack;
    }
}

