/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;

@Mod.EventBusSubscriber
public class ModeCapabilityManager {
    @CapabilityInject(value=IModeCapability.class)
    public static final Capability<IModeCapability> modeCapability = null;

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        LazyOptional original = event.getOriginal().getCapability(modeCapability, null);
        LazyOptional clone = event.getEntity().getCapability(modeCapability, null);
        clone.ifPresent(cloneModeCapability -> original.ifPresent(originalModeCapability -> cloneModeCapability.setModeData(originalModeCapability.getModeData())));
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        IModeCapability inst = (IModeCapability)modeCapability.getDefaultInstance();

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return modeCapability.orEmpty(cap, LazyOptional.of(() -> this.inst));
        }

        public INBT serializeNBT() {
            return modeCapability.getStorage().writeNBT(modeCapability, (Object)this.inst, null);
        }

        public void deserializeNBT(INBT nbt) {
            modeCapability.getStorage().readNBT(modeCapability, (Object)this.inst, null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IModeCapability> {
        public INBT writeNBT(Capability<IModeCapability> capability, IModeCapability instance, Direction side) {
            CompoundNBT compound = new CompoundNBT();
            ModeSettingsManager.ModeSettings modeSettings = instance.getModeData();
            if (modeSettings == null) {
                modeSettings = new ModeSettingsManager.ModeSettings();
            }
            return compound;
        }

        public void readNBT(Capability<IModeCapability> capability, IModeCapability instance, Direction side, INBT nbt) {
            CompoundNBT compound = (CompoundNBT)nbt;
            ModeSettingsManager.ModeSettings modeSettings = new ModeSettingsManager.ModeSettings(BuildModes.BuildModeEnum.NORMAL);
            instance.setModeData(modeSettings);
        }
    }

    public static class ModeCapability
    implements IModeCapability {
        private ModeSettingsManager.ModeSettings modeSettings;

        @Override
        public ModeSettingsManager.ModeSettings getModeData() {
            return this.modeSettings;
        }

        @Override
        public void setModeData(ModeSettingsManager.ModeSettings modeSettings) {
            this.modeSettings = modeSettings;
        }
    }

    public static interface IModeCapability {
        public ModeSettingsManager.ModeSettings getModeData();

        public void setModeData(ModeSettingsManager.ModeSettings var1);
    }
}

