/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmode;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.gui.widget.Slider;
import nl.requios.effortlessbuilding.EffortlessBuilding;

public class PlayerSettingsGui
extends Screen {
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    private Button shaderTypeButton;
    private ShaderTypeList shaderTypeList;
    private Button closeButton;
    protected boolean showShaderList = false;

    public PlayerSettingsGui() {
        super((ITextComponent)new TranslationTextComponent("effortlessbuilding.screen.player_settings", new Object[0]));
    }

    protected void init() {
        this.left = this.width / 2 - 140;
        this.right = this.width / 2 + 140;
        this.top = this.height / 2 - 100;
        this.bottom = this.height / 2 + 100;
        int yy = this.top;
        this.shaderTypeList = new ShaderTypeList(this.minecraft);
        this.children.add(this.shaderTypeList);
        String currentShaderName = ShaderType.DISSOLVE_BLUE.name;
        this.shaderTypeButton = new ExtendedButton(this.right - 180, yy, 180, 20, currentShaderName, button -> {
            this.showShaderList = !this.showShaderList;
        });
        this.addButton((Widget)this.shaderTypeButton);
        Slider slider = new Slider(this.right - 200, yy += 50, 200, 20, "", "", 0.5, 2.0, 1.0, true, true, button -> {});
        this.addButton((Widget)slider);
        this.closeButton = new ExtendedButton(this.left + 50, this.bottom - 20, 180, 20, "Done", button -> this.minecraft.field_71439_g.func_71053_j());
        this.addButton((Widget)this.closeButton);
    }

    public void tick() {
        super.tick();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        int yy = this.top;
        this.font.func_211126_b("Shader type", (float)this.left, (float)(yy + 5), 0xFFFFFF);
        this.font.func_211126_b("Shader speed", (float)this.left, (float)((yy += 50) + 5), 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
        if (this.showShaderList) {
            this.shaderTypeList.render(mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.showShaderList && !this.shaderTypeList.isMouseOver(mouseX, mouseY) && !this.shaderTypeButton.isMouseOver(mouseX, mouseY)) {
            this.showShaderList = false;
        }
        return true;
    }

    public void removed() {
        ShaderTypeList.ShaderTypeEntry selectedShader = (ShaderTypeList.ShaderTypeEntry)this.shaderTypeList.getSelected();
    }

    @OnlyIn(value=Dist.CLIENT)
    class ShaderTypeList
    extends ExtendedList<ShaderTypeEntry> {
        public ShaderTypeList(Minecraft mcIn) {
            super(mcIn, 180, 140, PlayerSettingsGui.this.top + 20, PlayerSettingsGui.this.top + 100, 18);
            this.setLeftPos(PlayerSettingsGui.this.right - this.width);
            for (int i = 0; i < 40; ++i) {
                for (ShaderType shaderType : ShaderType.values()) {
                    ShaderTypeEntry shaderTypeEntry = new ShaderTypeEntry(shaderType);
                    this.addEntry((AbstractList.AbstractListEntry)shaderTypeEntry);
                }
            }
            if (this.getSelected() != null) {
                this.centerScrollOn(this.getSelected());
            }
        }

        public int getRowWidth() {
            return this.width;
        }

        public void setSelected(ShaderTypeEntry selected) {
            super.setSelected((AbstractList.AbstractListEntry)selected);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            EffortlessBuilding.log("Selected shader " + ((ShaderTypeEntry)selected).shaderType.name);
            PlayerSettingsGui.this.shaderTypeButton.setMessage(((ShaderTypeEntry)selected).shaderType.name);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }

        public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }

        public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }

        public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        }

        public boolean isMouseOver(double p_isMouseOver_1_, double p_isMouseOver_3_) {
            if (!PlayerSettingsGui.this.showShaderList) {
                return false;
            }
            return super.isMouseOver(p_isMouseOver_1_, p_isMouseOver_3_);
        }

        protected boolean isFocused() {
            return PlayerSettingsGui.this.getFocused() == this;
        }

        protected int getScrollbarPosition() {
            return PlayerSettingsGui.this.right - 6;
        }

        public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
            this.renderBackground();
            int i = this.getScrollbarPosition();
            int j = i + 6;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225586_a_(20, 20, 20, 180).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225586_a_(20, 20, 20, 180).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225586_a_(20, 20, 20, 180).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225586_a_(20, 20, 20, 180).func_181675_d();
            tessellator.func_78381_a();
            int k = this.getRowLeft();
            int l = this.y0 + 4 - (int)this.getScrollAmount();
            if (this.renderHeader) {
                this.renderHeader(k, l, tessellator);
            }
            this.renderList(k, l, p_render_1_, p_render_2_, p_render_3_);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            int j1 = this.getMaxScroll();
            if (j1 > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
                int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
        }

        private int getMaxScroll() {
            return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
        }

        @OnlyIn(value=Dist.CLIENT)
        public class ShaderTypeEntry
        extends ExtendedList.AbstractListEntry<ShaderTypeEntry> {
            private final ShaderType shaderType;

            public ShaderTypeEntry(ShaderType shaderType) {
                this.shaderType = shaderType;
            }

            public void render(int itemIndex, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                if (rowTop + 10 > ShaderTypeList.this.y0 && rowTop + rowHeight - 5 < ShaderTypeList.this.y1) {
                    ShaderTypeList.this.drawString(PlayerSettingsGui.this.font, this.shaderType.name, ShaderTypeList.this.x0 + 8, rowTop + 4, 0xFFFFFF);
                }
            }

            public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    ShaderTypeList.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }

    public static enum ShaderType {
        DISSOLVE_BLUE("Dissolve Blue"),
        DISSOLVE_ORANGE("Dissolve Orange");

        public String name;

        private ShaderType(String name) {
            this.name = name;
        }
    }
}

