/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.gui.elements.GuiCheckBoxFixed;
import nl.requios.effortlessbuilding.gui.elements.GuiCollapsibleScrollEntry;
import nl.requios.effortlessbuilding.gui.elements.GuiNumberField;
import nl.requios.effortlessbuilding.gui.elements.GuiScrollPane;
import nl.requios.effortlessbuilding.helper.ReachHelper;

@OnlyIn(value=Dist.CLIENT)
public class ArraySettingsGui
extends GuiCollapsibleScrollEntry {
    protected List<GuiNumberField> arrayNumberFieldList = new ArrayList<GuiNumberField>();
    private GuiCheckBoxFixed buttonArrayEnabled;
    private GuiNumberField textArrayOffsetX;
    private GuiNumberField textArrayOffsetY;
    private GuiNumberField textArrayOffsetZ;
    private GuiNumberField textArrayCount;

    public ArraySettingsGui(GuiScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public void init(List<Widget> buttons) {
        super.init(buttons);
        int y = this.top;
        this.buttonArrayEnabled = new GuiCheckBoxFixed(this.left - 15 + 8, y, "", false){

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                ArraySettingsGui.this.setCollapsed(!ArraySettingsGui.this.buttonArrayEnabled.isChecked());
            }
        };
        buttons.add((Widget)this.buttonArrayEnabled);
        y = this.top + 20;
        this.textArrayOffsetX = new GuiNumberField(this.font, buttons, this.left + 70, y, 50, 18);
        this.textArrayOffsetX.setNumber(0.0);
        this.textArrayOffsetX.setTooltip("How much each copy is shifted.");
        this.arrayNumberFieldList.add(this.textArrayOffsetX);
        this.textArrayOffsetY = new GuiNumberField(this.font, buttons, this.left + 140, y, 50, 18);
        this.textArrayOffsetY.setNumber(0.0);
        this.textArrayOffsetY.setTooltip("How much each copy is shifted.");
        this.arrayNumberFieldList.add(this.textArrayOffsetY);
        this.textArrayOffsetZ = new GuiNumberField(this.font, buttons, this.left + 210, y, 50, 18);
        this.textArrayOffsetZ.setNumber(0.0);
        this.textArrayOffsetZ.setTooltip("How much each copy is shifted.");
        this.arrayNumberFieldList.add(this.textArrayOffsetZ);
        y = this.top + 50;
        this.textArrayCount = new GuiNumberField(this.font, buttons, this.left + 55, y, 50, 18);
        this.textArrayCount.setNumber(5.0);
        this.textArrayCount.setTooltip("How many copies should be made.");
        this.arrayNumberFieldList.add(this.textArrayCount);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)this.mc.field_71439_g);
        if (modifierSettings != null) {
            Array.ArraySettings a = modifierSettings.getArraySettings();
            this.buttonArrayEnabled.setIsChecked(a.enabled);
            this.textArrayOffsetX.setNumber(a.offset.func_177958_n());
            this.textArrayOffsetY.setNumber(a.offset.func_177956_o());
            this.textArrayOffsetZ.setNumber(a.offset.func_177952_p());
            this.textArrayCount.setNumber(a.count);
        }
        this.setCollapsed(!this.buttonArrayEnabled.isChecked());
    }

    @Override
    public void updateScreen() {
        this.arrayNumberFieldList.forEach(GuiNumberField::update);
    }

    @Override
    public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int yy = y;
        int offset = 8;
        this.buttonArrayEnabled.render(mouseX, mouseY, partialTicks);
        if (this.buttonArrayEnabled.isChecked()) {
            this.buttonArrayEnabled.y = yy;
            this.font.func_211126_b("Array enabled", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            yy = y + 20;
            this.font.func_211126_b("Offset", (float)(this.left + offset), (float)(yy + 5), 0xFFFFFF);
            this.font.func_211126_b("X", (float)(this.left + 50 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textArrayOffsetX.y = yy;
            this.font.func_211126_b("Y", (float)(this.left + 120 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textArrayOffsetY.y = yy;
            this.font.func_211126_b("Z", (float)(this.left + 190 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textArrayOffsetZ.y = yy;
            yy = y + 50;
            this.font.func_211126_b("Count", (float)(this.left + offset), (float)(yy + 5), 0xFFFFFF);
            this.textArrayCount.y = yy;
            int currentReach = Math.max(-1, this.getArrayReach());
            int maxReach = ReachHelper.getMaxReach((PlayerEntity)this.mc.field_71439_g);
            TextFormatting reachColor = this.isCurrentReachValid(currentReach, maxReach) ? TextFormatting.GRAY : TextFormatting.RED;
            String reachText = "Reach: " + reachColor + currentReach + TextFormatting.GRAY + "/" + TextFormatting.GRAY + maxReach;
            this.font.func_211126_b(reachText, (float)(this.left + 176 + offset), (float)(yy + 5), 0xFFFFFF);
            this.arrayNumberFieldList.forEach(numberField -> numberField.drawNumberField(mouseX, mouseY, partialTicks));
        } else {
            this.buttonArrayEnabled.y = yy;
            this.font.func_211126_b("Array disabled", (float)(this.left + offset), (float)(yy + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(Screen guiScreen, int mouseX, int mouseY) {
        if (this.buttonArrayEnabled.isChecked()) {
            this.arrayNumberFieldList.forEach(numberField -> numberField.drawTooltip(this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (GuiNumberField numberField : this.arrayNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideArrayEnabledLabel;
        this.arrayNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideArrayEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideArrayEnabledLabel) {
            this.buttonArrayEnabled.playDownSound(this.mc.func_147118_V());
            this.buttonArrayEnabled.onClick(mouseX, mouseY);
        }
        return true;
    }

    public Array.ArraySettings getArraySettings() {
        boolean arrayEnabled = this.buttonArrayEnabled.isChecked();
        BlockPos arrayOffset = new BlockPos(0, 0, 0);
        try {
            arrayOffset = new BlockPos(this.textArrayOffsetX.getNumber(), this.textArrayOffsetY.getNumber(), this.textArrayOffsetZ.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((PlayerEntity)this.mc.field_71439_g, "Array offset not a valid number.");
        }
        int arrayCount = 5;
        try {
            arrayCount = (int)this.textArrayCount.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((PlayerEntity)this.mc.field_71439_g, "Array count not a valid number.");
        }
        return new Array.ArraySettings(arrayEnabled, arrayOffset, arrayCount);
    }

    @Override
    protected String getName() {
        return "Array";
    }

    @Override
    protected int getExpandedHeight() {
        return 80;
    }

    private int getArrayReach() {
        try {
            double x = Math.abs(this.textArrayOffsetX.getNumber());
            double y = Math.abs(this.textArrayOffsetY.getNumber());
            double z = Math.abs(this.textArrayOffsetZ.getNumber());
            double largestOffset = Math.max(Math.max(x, y), z);
            return (int)(largestOffset * this.textArrayCount.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            return -1;
        }
    }

    private boolean isCurrentReachValid(int currentReach, int maxReach) {
        return currentReach <= maxReach && currentReach > -1;
    }
}

