/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.SlotGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;

@OnlyIn(value=Dist.CLIENT)
public class GuiScrollPane
extends SlotGui {
    public Screen parent;
    public FontRenderer font;
    private List<IScrollEntry> listEntries;
    private float scrollMultiplier = 1.0f;
    private int mouseX;
    private int mouseY;

    public GuiScrollPane(Screen parent, FontRenderer font, int top, int bottom) {
        super(Minecraft.func_71410_x(), parent.width, parent.height, top, bottom, 100);
        this.parent = parent;
        this.font = font;
        this.renderSelection = false;
        this.listEntries = new ArrayList<IScrollEntry>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public IScrollEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    public void AddListEntry(IScrollEntry listEntry) {
        this.listEntries.add(listEntry);
    }

    protected int getItemCount() {
        return this.listEntries.size();
    }

    protected boolean isSelectedItem(int slotIndex) {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width - 15;
    }

    public int getRowWidth() {
        return 280;
    }

    public void render(int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.visible) {
            this.mouseX = mouseXIn;
            this.mouseY = mouseYIn;
            this.renderBackground();
            int scrollbarLeft = this.getScrollbarPosition();
            int scrollbarRight = scrollbarLeft + 6;
            this.capYPosition();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            int insideLeft = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
            int insideTop = this.y0 + 4 - (int)this.yo;
            if (this.renderHeader) {
                this.renderHeader(insideLeft, insideTop, tessellator);
            }
            this.renderList(insideLeft, insideTop, mouseXIn, mouseYIn, partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            int maxScroll = this.getMaxScroll();
            if (maxScroll > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                int l1 = (int)this.yo * (this.y1 - this.y0 - (k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8)))) / maxScroll + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)scrollbarLeft, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollbarRight, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollbarRight, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollbarLeft, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)scrollbarLeft, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollbarRight, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollbarRight, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollbarLeft, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)scrollbarLeft, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(scrollbarRight - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(scrollbarRight - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)scrollbarLeft, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
        }
    }

    protected int getMaxPosition() {
        int height = this.headerHeight;
        for (IScrollEntry entry : this.listEntries) {
            height += entry.getHeight();
        }
        return height;
    }

    protected void renderBackground() {
    }

    protected void renderItem(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        this.getListEntry(slotIndex).drawEntry(slotIndex, xPos, yPos, this.getRowWidth(), heightIn, mouseXIn, mouseYIn, this.getSlotIndexFromScreenCoords(mouseXIn, mouseYIn) == slotIndex, partialTicks);
    }

    public int getMaxPosition(int count) {
        int height = this.headerHeight;
        for (int i = 0; i < count; ++i) {
            IScrollEntry entry = this.listEntries.get(i);
            height += entry.getHeight();
        }
        return height;
    }

    public int getSlotIndexFromScreenCoords(double posX, double posY) {
        int left = this.x0 + (this.width - this.getRowWidth()) / 2;
        int right = this.x0 + (this.width + this.getRowWidth()) / 2;
        double relativeMouseY = this.getRelativeMouseY(this.mouseY, 0);
        for (int i = 0; i < this.listEntries.size(); ++i) {
            IScrollEntry entry = this.listEntries.get(i);
            if (relativeMouseY <= (double)entry.getHeight()) {
                return posX < (double)this.getScrollbarPosition() && posX >= (double)left && posX <= (double)right && i >= 0 && relativeMouseY >= 0.0 && i < this.getItemCount() ? i : -1;
            }
            relativeMouseY -= (double)entry.getHeight();
        }
        return -1;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int selectedSlot = this.getSlotIndexFromScreenCoords(mouseX, mouseY);
        double relativeX = this.getRelativeMouseX(mouseX);
        for (int i = 0; i < this.listEntries.size(); ++i) {
            double relativeY = this.getRelativeMouseY(mouseY, i);
            this.getListEntry(i).mousePressed(selectedSlot, (int)mouseX, (int)mouseY, button, (int)relativeX, (int)relativeY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            double relativeX = this.getRelativeMouseX(mouseX);
            double relativeY = this.getRelativeMouseY(mouseY, i);
            this.getListEntry(i).mouseReleased(i, (int)mouseX, (int)mouseY, button, (int)relativeX, (int)relativeY);
        }
        this.visible = true;
        return false;
    }

    public void handleMouseInput() {
        if (this.isMouseInList(this.mouseX, this.mouseY)) {
            if (this.minecraft.field_71417_B.func_198030_b() && this.mouseY >= this.y0 && this.mouseY <= this.y1) {
                int i = this.x0 + (this.width - this.getRowWidth()) / 2;
                int j = this.x0 + (this.width + this.getRowWidth()) / 2;
                int slotIndex = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                double relativeMouseY = this.getRelativeMouseY(this.mouseY, slotIndex);
                if (slotIndex > -1) {
                    this.mouseClicked(this.mouseX, this.mouseY, 0);
                } else if (this.mouseX >= i && this.mouseX <= j && relativeMouseY < 0.0) {
                    this.clickedHeader(this.mouseX - i, this.mouseY - this.y0 + (int)this.yo - 4);
                }
            }
            if (this.minecraft.field_71417_B.func_198030_b() && this.isVisible()) {
                if (this.yDrag == -1) {
                    boolean flag1 = true;
                    if (this.mouseY >= this.y0 && this.mouseY <= this.y1) {
                        int i2 = this.x0 + (this.width - this.getRowWidth()) / 2;
                        int j2 = this.x0 + (this.width + this.getRowWidth()) / 2;
                        int slotIndex = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                        double relativeMouseY = this.getRelativeMouseY(this.mouseY, slotIndex);
                        if (slotIndex > -1) {
                            this.mouseClicked(slotIndex, this.mouseX, this.mouseY);
                        } else if (this.mouseX >= i2 && this.mouseX <= j2 && relativeMouseY < 0.0) {
                            this.clickedHeader(this.mouseX - i2, this.mouseY - this.y0 + (int)this.yo - 4);
                            flag1 = false;
                        }
                        int i3 = this.getScrollbarPosition();
                        int j1 = i3 + 6;
                        if (this.mouseX >= i3 && this.mouseX <= j1) {
                            this.scrollMultiplier = -1.0f;
                            int maxScroll = this.getMaxScroll();
                            if (maxScroll < 1) {
                                maxScroll = 1;
                            }
                            int l1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                            l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.y1 - this.y0 - 8));
                            this.scrollMultiplier /= (float)(this.y1 - this.y0 - l1) / (float)maxScroll;
                        } else {
                            this.scrollMultiplier = 1.0f;
                        }
                        this.yDrag = flag1 ? this.mouseY : -2;
                    } else {
                        this.yDrag = -2;
                    }
                } else if (this.yDrag >= 0) {
                    this.yo -= (double)((float)(this.mouseY - this.yDrag) * this.scrollMultiplier);
                    this.yDrag = this.mouseY;
                }
            } else {
                this.yDrag = -1;
            }
        }
    }

    protected void renderList(int insideLeft, int insideTop, int mouseXIn, int mouseYIn, float partialTicks) {
        int insideHeight;
        int itemCount = this.getItemCount();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int y = this.headerHeight + insideTop;
        int contentHeight = this.getMaxPosition();
        if (contentHeight < (insideHeight = this.y1 - this.y0 - 4)) {
            y += (insideHeight - contentHeight) / 2;
        }
        for (int i = 0; i < itemCount; ++i) {
            int entryHeight = this.listEntries.get(i).getHeight();
            int entryHeight2 = entryHeight - 4;
            if (y > this.y1 || y + entryHeight2 < this.y0) {
                this.updateItemPosition(i, insideLeft, y, partialTicks);
            }
            if (this.renderSelection && this.isSelectedItem(i)) {
                int i1 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int j1 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                RenderSystem.disableTexture();
                float f = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)f, (float)f, (float)f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_((double)i1, (double)(y + entryHeight2 + 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)j1, (double)(y + entryHeight2 + 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)j1, (double)(y - 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)i1, (double)(y - 2), 0.0).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_((double)(i1 + 1), (double)(y + entryHeight2 + 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j1 - 1), (double)(y + entryHeight2 + 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j1 - 1), (double)(y - 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(i1 + 1), (double)(y - 1), 0.0).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.enableTexture();
            }
            this.renderItem(i, insideLeft, y, entryHeight2, mouseXIn, mouseYIn, partialTicks);
            y += entryHeight;
        }
    }

    private double getRelativeMouseX(double mouseX) {
        int j = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
        return mouseX - (double)j;
    }

    private double getRelativeMouseY(double mouseY, int contentIndex) {
        int insideHeight;
        int k = this.y0 + 4 - this.getScroll() + this.getMaxPosition(contentIndex) + this.headerHeight;
        double relativeMouseY = mouseY - (double)k;
        int contentHeight = this.getMaxPosition();
        if (contentHeight < (insideHeight = this.y1 - this.y0 - 4)) {
            relativeMouseY -= (double)((float)(insideHeight - contentHeight) / 2.0f);
        }
        return relativeMouseY;
    }

    public void init(List<Widget> buttonList) {
        for (IScrollEntry entry : this.listEntries) {
            entry.init(buttonList);
        }
    }

    public void updateScreen() {
        for (IScrollEntry entry : this.listEntries) {
            entry.updateScreen();
        }
    }

    public void drawTooltip(Screen guiScreen, int mouseX, int mouseY) {
        for (IScrollEntry entry : this.listEntries) {
            entry.drawTooltip(guiScreen, mouseX, mouseY);
        }
    }

    public boolean charTyped(char eventChar, int eventKey) {
        for (IScrollEntry entry : this.listEntries) {
            entry.charTyped(eventChar, eventKey);
        }
        return false;
    }

    public void onGuiClosed() {
        for (IScrollEntry entry : this.listEntries) {
            entry.onGuiClosed();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static interface IScrollEntry {
        public void init(List<Widget> var1);

        public void updateScreen();

        public void drawTooltip(Screen var1, int var2, int var3);

        public boolean charTyped(char var1, int var2);

        public void onGuiClosed();

        public int getHeight();

        public void updatePosition(int var1, int var2, int var3, float var4);

        public void drawEntry(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public boolean mousePressed(int var1, int var2, int var3, int var4, int var5, int var6);

        public void mouseReleased(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

