/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import nl.requios.effortlessbuilding.render.ShaderHandler;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class BuildRenderTypes {
    public static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = (RenderState.TransparencyState)ObfuscationReflectionHelper.getPrivateValue(RenderState.class, null, (String)"field_228515_g_");
    public static final RenderState.TransparencyState NO_TRANSPARENCY = (RenderState.TransparencyState)ObfuscationReflectionHelper.getPrivateValue(RenderState.class, null, (String)"field_228510_b_");
    public static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_ENABLED = new RenderState.DiffuseLightingState(true);
    public static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_DISABLED = new RenderState.DiffuseLightingState(false);
    public static final RenderState.LayerState PROJECTION_LAYERING = (RenderState.LayerState)ObfuscationReflectionHelper.getPrivateValue(RenderState.class, null, (String)"field_228500_J_");
    public static final RenderState.CullState CULL_DISABLED = new RenderState.CullState(false);
    public static final RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
    public static final RenderState.WriteMaskState WRITE_TO_DEPTH_AND_COLOR;
    public static final RenderState.WriteMaskState COLOR_WRITE;
    public static final RenderType LINES;
    public static final RenderType PLANES;
    private static final int primaryTextureUnit = 0;
    private static final int secondaryTextureUnit = 2;

    public static RenderType getBlockPreviewRenderType(float dissolve, BlockPos blockPos, BlockPos firstPos, BlockPos secondPos, boolean red) {
        String stateName = "eb_texturing_" + dissolve + "_" + blockPos + "_" + firstPos + "_" + secondPos + "_" + red;
        RenderState.TexturingState MY_TEXTURING = new RenderState.TexturingState(stateName, () -> {
            ShaderHandler.useShader(ShaderHandler.dissolve, BuildRenderTypes.generateShaderCallback(dissolve, new Vec3d((Vec3i)blockPos), new Vec3d((Vec3i)firstPos), new Vec3d((Vec3i)secondPos), blockPos == secondPos, red));
            RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        }, () -> ShaderHandler.releaseShader());
        RenderType.State renderState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(ShaderHandler.shaderMaskTextureLocation, false, false)).func_228725_a_(MY_TEXTURING).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_DISABLED).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(new RenderState.CullState(true)).func_228719_a_(new RenderState.LightmapState(false)).func_228722_a_(new RenderState.OverlayState(false)).func_228728_a_(true);
        String name = "eb_block_previews_" + dissolve + "_" + blockPos + "_" + firstPos + "_" + secondPos + "_" + red;
        return RenderType.func_228633_a_((String)name, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)renderState);
    }

    private static Consumer<Integer> generateShaderCallback(float dissolve, Vec3d blockpos, Vec3d firstpos, Vec3d secondpos, boolean highlight, boolean red) {
        Minecraft mc = Minecraft.func_71410_x();
        return shader -> {
            int percentileUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"dissolve");
            int highlightUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"highlight");
            int redUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"red");
            int blockposUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"blockpos");
            int firstposUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"firstpos");
            int secondposUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"secondpos");
            int imageUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"image");
            int maskUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"mask");
            RenderSystem.enableTexture();
            GL11.glGetInteger((int)32873);
            ARBShaderObjects.glUniform1iARB((int)maskUniform, (int)2);
            BuildRenderTypes.glActiveTexture(33986);
            mc.func_110434_K().func_110577_a(ShaderHandler.shaderMaskTextureLocation);
            ARBShaderObjects.glUniform1iARB((int)imageUniform, (int)0);
            BuildRenderTypes.glActiveTexture(33984);
            mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            ARBShaderObjects.glUniform3fARB((int)blockposUniform, (float)((float)blockpos.field_72450_a), (float)((float)blockpos.field_72448_b), (float)((float)blockpos.field_72449_c));
            ARBShaderObjects.glUniform3fARB((int)firstposUniform, (float)((float)firstpos.field_72450_a), (float)((float)firstpos.field_72448_b), (float)((float)firstpos.field_72449_c));
            ARBShaderObjects.glUniform3fARB((int)secondposUniform, (float)((float)secondpos.field_72450_a), (float)((float)secondpos.field_72448_b), (float)((float)secondpos.field_72449_c));
            ARBShaderObjects.glUniform1fARB((int)percentileUniform, (float)dissolve);
            ARBShaderObjects.glUniform1iARB((int)highlightUniform, (int)(highlight ? 1 : 0));
            ARBShaderObjects.glUniform1iARB((int)redUniform, (int)(red ? 1 : 0));
        };
    }

    public static void glActiveTexture(int texture) {
        if (GL.getCapabilities().GL_ARB_multitexture && !GL.getCapabilities().OpenGL13) {
            ARBMultitexture.glActiveTextureARB((int)texture);
        } else {
            GL13.glActiveTexture((int)texture);
        }
    }

    static {
        boolean ENABLE_DEPTH_WRITING = true;
        boolean ENABLE_COLOUR_COMPONENTS_WRITING = true;
        WRITE_TO_DEPTH_AND_COLOR = new RenderState.WriteMaskState(true, true);
        COLOR_WRITE = new RenderState.WriteMaskState(true, false);
        int INITIAL_BUFFER_SIZE = 128;
        RenderType.State renderState = RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(2.0))).func_228718_a_(PROJECTION_LAYERING).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228727_a_(WRITE_TO_DEPTH_AND_COLOR).func_228714_a_(CULL_DISABLED).func_228728_a_(false);
        LINES = RenderType.func_228632_a_((String)"eb_lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)128, (RenderType.State)renderState);
        renderState = RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(2.0))).func_228718_a_(PROJECTION_LAYERING).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228727_a_(COLOR_WRITE).func_228714_a_(CULL_DISABLED).func_228728_a_(false);
        PLANES = RenderType.func_228632_a_((String)"eb_planes", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)5, (int)128, (RenderType.State)renderState);
    }

    private class ShaderInfo {
        float dissolve;
        Vec3d blockPos;
        Vec3d firstPos;
        Vec3d secondPos;
        boolean red;

        public ShaderInfo(float dissolve, Vec3d blockPos, Vec3d firstPos, Vec3d secondPos, boolean red) {
            this.dissolve = dissolve;
            this.blockPos = blockPos;
            this.firstPos = firstPos;
            this.secondPos = secondPos;
            this.red = red;
        }
    }
}

