/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import nl.requios.effortlessbuilding.buildmode.BaseBuildMode;
import nl.requios.effortlessbuilding.helper.ReachHelper;

public abstract class TwoClicksBuildMode
extends BaseBuildMode {
    @Override
    public List<BlockPos> onRightClick(PlayerEntity player, BlockPos blockPos, Direction sideHit, Vector3d hitVec, boolean skipRaytrace) {
        ArrayList<BlockPos> list = new ArrayList();
        Dictionary rightClickTable = player.field_70170_p.field_72995_K ? this.rightClickClientTable : this.rightClickServerTable;
        int rightClickNr = (Integer)rightClickTable.get(player.func_110124_au());
        rightClickTable.put(player.func_110124_au(), ++rightClickNr);
        if (rightClickNr == 1) {
            if (blockPos == null) {
                rightClickTable.put(player.func_110124_au(), 0);
                return list;
            }
            this.firstPosTable.put(player.func_110124_au(), blockPos);
            this.sideHitTable.put(player.func_110124_au(), sideHit);
            this.hitVecTable.put(player.func_110124_au(), hitVec);
        } else {
            list = this.findCoordinates(player, blockPos, skipRaytrace);
            rightClickTable.put(player.func_110124_au(), 0);
        }
        return list;
    }

    @Override
    public List<BlockPos> findCoordinates(PlayerEntity player, BlockPos blockPos, boolean skipRaytrace) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        Dictionary rightClickTable = player.field_70170_p.field_72995_K ? this.rightClickClientTable : this.rightClickServerTable;
        int rightClickNr = (Integer)rightClickTable.get(player.func_110124_au());
        BlockPos firstPos = (BlockPos)this.firstPosTable.get(player.func_110124_au());
        if (rightClickNr == 0) {
            if (blockPos != null) {
                list.add(blockPos);
            }
        } else {
            BlockPos secondPos = this.findSecondPos(player, firstPos, skipRaytrace);
            if (secondPos == null) {
                return list;
            }
            int axisLimit = ReachHelper.getMaxBlocksPerAxis(player);
            int x1 = firstPos.func_177958_n();
            int x2 = secondPos.func_177958_n();
            int y1 = firstPos.func_177956_o();
            int y2 = secondPos.func_177956_o();
            int z1 = firstPos.func_177952_p();
            int z2 = secondPos.func_177952_p();
            if (x2 - x1 >= axisLimit) {
                x2 = x1 + axisLimit - 1;
            }
            if (x1 - x2 >= axisLimit) {
                x2 = x1 - axisLimit + 1;
            }
            if (y2 - y1 >= axisLimit) {
                y2 = y1 + axisLimit - 1;
            }
            if (y1 - y2 >= axisLimit) {
                y2 = y1 - axisLimit + 1;
            }
            if (z2 - z1 >= axisLimit) {
                z2 = z1 + axisLimit - 1;
            }
            if (z1 - z2 >= axisLimit) {
                z2 = z1 - axisLimit + 1;
            }
            list.addAll(this.getAllBlocks(player, x1, y1, z1, x2, y2, z2));
        }
        return list;
    }

    protected abstract BlockPos findSecondPos(PlayerEntity var1, BlockPos var2, boolean var3);

    protected abstract List<BlockPos> getAllBlocks(PlayerEntity var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

