/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmode;

import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.ModClientEventHandler;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.proxy.ClientProxy;
import org.apache.commons.lang3.text.WordUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RadialMenu
extends Screen {
    public static final RadialMenu instance = new RadialMenu();
    private final float TIME_SCALE = 0.01f;
    public BuildModes.BuildModeEnum switchTo = null;
    public ModeOptions.ActionEnum doAction = null;
    public boolean actionUsed = false;
    private float visibility = 0.0f;
    private Stopwatch lastChange = Stopwatch.createStarted();

    public RadialMenu() {
        super((ITextComponent)new TranslationTextComponent("effortlessbuilding.screen.radial_menu"));
    }

    private float clampVis(float f) {
        return Math.max(0.0f, Math.min(1.0f, f));
    }

    public void raiseVisibility() {
        this.visibility = this.clampVis(this.visibility + (float)this.lastChange.elapsed(TimeUnit.MILLISECONDS) * 0.01f);
        this.lastChange = Stopwatch.createStarted();
    }

    public void decreaseVisibility() {
        this.visibility = this.clampVis(this.visibility - (float)this.lastChange.elapsed(TimeUnit.MILLISECONDS) * 0.01f);
        this.lastChange = Stopwatch.createStarted();
    }

    public void setVisibility(float visibility) {
        this.visibility = visibility;
    }

    public boolean isVisible() {
        return (double)this.visibility > 0.001;
    }

    public void configure(int scaledWidth, int scaledHeight) {
        Minecraft mc = Minecraft.func_71410_x();
        this.field_230712_o_ = mc.field_71466_p;
        this.field_230708_k_ = scaledWidth;
        this.field_230709_l_ = scaledHeight;
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        BuildModes.BuildModeEnum currentBuildMode = ModeSettingsManager.getModeSettings((PlayerEntity)Minecraft.func_71410_x().field_71439_g).getBuildMode();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)200.0f);
        int startColor = (int)(this.visibility * 98.0f) << 24;
        int endColor = (int)(this.visibility * 128.0f) << 24;
        this.func_238468_a_(ms, 0, 0, this.field_230708_k_, this.field_230709_l_, startColor, endColor);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double middleX = (double)this.field_230708_k_ / 2.0;
        double middleY = (double)this.field_230709_l_ / 2.0;
        Minecraft mc = Minecraft.func_71410_x();
        int mouseXX = (int)(mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
        int mouseYY = (int)(mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
        double mouseXCenter = (double)mouseXX - middleX;
        double mouseYCenter = (double)mouseYY - middleY;
        double mouseRadians = Math.atan2(mouseYCenter, mouseXCenter);
        double ringInnerEdge = 30.0;
        double ringOuterEdge = 65.0;
        double textDistance = 75.0;
        double buttonDistance = 105.0;
        double quarterCircle = 1.5707963267948966;
        if (mouseRadians < -1.5707963267948966) {
            mouseRadians += Math.PI * 2;
        }
        ArrayList<MenuRegion> modes = new ArrayList<MenuRegion>();
        ArrayList<MenuButton> buttons = new ArrayList<MenuButton>();
        for (BuildModes.BuildModeEnum mode : BuildModes.BuildModeEnum.values()) {
            modes.add(new MenuRegion(mode));
        }
        buttons.add(new MenuButton(ModeOptions.ActionEnum.UNDO.name, ModeOptions.ActionEnum.UNDO, -131.0, -13.0, Direction.UP));
        buttons.add(new MenuButton(ModeOptions.ActionEnum.REDO.name, ModeOptions.ActionEnum.REDO, -105.0, -13.0, Direction.UP));
        buttons.add(new MenuButton(ModeOptions.ActionEnum.OPEN_PLAYER_SETTINGS.name, ModeOptions.ActionEnum.OPEN_PLAYER_SETTINGS, -144.0, 13.0, Direction.DOWN));
        buttons.add(new MenuButton(ModeOptions.ActionEnum.OPEN_MODIFIER_SETTINGS.name, ModeOptions.ActionEnum.OPEN_MODIFIER_SETTINGS, -118.0, 13.0, Direction.DOWN));
        buttons.add(new MenuButton(ModeOptions.ActionEnum.REPLACE.name, ModeOptions.ActionEnum.REPLACE, -92.0, 13.0, Direction.DOWN));
        ModeOptions.OptionEnum[] options = currentBuildMode.options;
        for (int i = 0; i < options.length; ++i) {
            for (int j = 0; j < options[i].actions.length; ++j) {
                ModeOptions.ActionEnum action = options[i].actions[j];
                buttons.add(new MenuButton(action.name, action, 105.0 + (double)(j * 26), -13 + i * 39, Direction.DOWN));
            }
        }
        this.switchTo = null;
        this.doAction = null;
        if (!modes.isEmpty()) {
            int totalModes = Math.max(3, modes.size());
            int currentMode = 0;
            double fragment = 0.015707963267948967;
            double fragment2 = 0.007853981633974483;
            double perObject = Math.PI * 2 / (double)totalModes;
            for (int i = 0; i < modes.size(); ++i) {
                boolean isMouseInQuad;
                MenuRegion menuRegion = (MenuRegion)modes.get(i);
                double beginRadians = (double)currentMode * perObject - 1.5707963267948966;
                double endRadians = (double)(currentMode + 1) * perObject - 1.5707963267948966;
                menuRegion.x1 = Math.cos(beginRadians);
                menuRegion.x2 = Math.cos(endRadians);
                menuRegion.y1 = Math.sin(beginRadians);
                menuRegion.y2 = Math.sin(endRadians);
                double x1m1 = Math.cos(beginRadians + 0.015707963267948967) * 30.0;
                double x2m1 = Math.cos(endRadians - 0.015707963267948967) * 30.0;
                double y1m1 = Math.sin(beginRadians + 0.015707963267948967) * 30.0;
                double y2m1 = Math.sin(endRadians - 0.015707963267948967) * 30.0;
                double x1m2 = Math.cos(beginRadians + 0.007853981633974483) * 65.0;
                double x2m2 = Math.cos(endRadians - 0.007853981633974483) * 65.0;
                double y1m2 = Math.sin(beginRadians + 0.007853981633974483) * 65.0;
                double y2m2 = Math.sin(endRadians - 0.007853981633974483) * 65.0;
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.5f;
                int buildMode = currentBuildMode.ordinal();
                if (buildMode == i) {
                    r = 0.0f;
                    g = 0.5f;
                    b = 1.0f;
                    a = 0.5f;
                }
                boolean bl = isMouseInQuad = this.inTriangle(x1m1, y1m1, x2m2, y2m2, x2m1, y2m1, mouseXCenter, mouseYCenter) || this.inTriangle(x1m1, y1m1, x1m2, y1m2, x2m2, y2m2, mouseXCenter, mouseYCenter);
                if (beginRadians <= mouseRadians && mouseRadians <= endRadians && isMouseInQuad) {
                    r = 0.6f;
                    g = 0.8f;
                    b = 1.0f;
                    a = 0.6f;
                    menuRegion.highlighted = true;
                    this.switchTo = menuRegion.mode;
                }
                buffer.func_225582_a_(middleX + x1m1, middleY + y1m1, (double)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
                buffer.func_225582_a_(middleX + x2m1, middleY + y2m1, (double)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
                buffer.func_225582_a_(middleX + x2m2, middleY + y2m2, (double)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
                buffer.func_225582_a_(middleX + x1m2, middleY + y1m2, (double)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
                ++currentMode;
            }
        }
        for (MenuButton btn : buttons) {
            float r = 0.5f;
            float g = 0.5f;
            float b = 0.5f;
            float a = 0.5f;
            if (btn.action == ModeOptions.getBuildSpeed() || btn.action == ModeOptions.getFill() || btn.action == ModeOptions.getCubeFill() || btn.action == ModeOptions.getRaisedEdge() || btn.action == ModeOptions.getLineThickness() || btn.action == ModeOptions.getCircleStart()) {
                r = 0.0f;
                g = 0.5f;
                b = 1.0f;
                a = 0.6f;
            }
            if (btn.x1 <= mouseXCenter && btn.x2 >= mouseXCenter && btn.y1 <= mouseYCenter && btn.y2 >= mouseYCenter) {
                r = 0.6f;
                g = 0.8f;
                b = 1.0f;
                a = 0.6f;
                btn.highlighted = true;
                this.doAction = btn.action;
            }
            buffer.func_225582_a_(middleX + btn.x1, middleY + btn.y1, (double)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_(middleX + btn.x1, middleY + btn.y2, (double)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_(middleX + btn.x2, middleY + btn.y2, (double)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_(middleX + btn.x2, middleY + btn.y1, (double)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)5.0f);
        RenderSystem.enableTexture();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (MenuRegion menuRegion : modes) {
            double x = (menuRegion.x1 + menuRegion.x2) * 0.5 * 51.0;
            double y = (menuRegion.y1 + menuRegion.y2) * 0.5 * 51.0;
            TextureAtlasSprite sprite = ModClientEventHandler.getBuildModeIcon(menuRegion.mode);
            double x1 = x - 8.0;
            double x2 = x + 8.0;
            double y1 = y - 8.0;
            double y2 = y + 8.0;
            float f = 1.0f;
            float a = 1.0f;
            double u1 = 0.0;
            double u2 = 16.0;
            double v1 = 0.0;
            double v2 = 16.0;
            buffer.func_225582_a_(middleX + x1, middleY + y1, (double)this.func_230927_p_()).func_225583_a_(sprite.func_94214_a(0.0), sprite.func_94207_b(0.0)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(middleX + x1, middleY + y2, (double)this.func_230927_p_()).func_225583_a_(sprite.func_94214_a(0.0), sprite.func_94207_b(16.0)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(middleX + x2, middleY + y2, (double)this.func_230927_p_()).func_225583_a_(sprite.func_94214_a(16.0), sprite.func_94207_b(16.0)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(middleX + x2, middleY + y1, (double)this.func_230927_p_()).func_225583_a_(sprite.func_94214_a(16.0), sprite.func_94207_b(0.0)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        }
        for (MenuButton button : buttons) {
            float f = 1.0f;
            float a = 1.0f;
            double u1 = 0.0;
            double u2 = 16.0;
            double v1 = 0.0;
            double v2 = 16.0;
            TextureAtlasSprite sprite = ModClientEventHandler.getModeOptionIcon(button.action);
            double btnmiddleX = (button.x1 + button.x2) / 2.0 + 0.01;
            double btnmiddleY = (button.y1 + button.y2) / 2.0 + 0.01;
            double btnx1 = btnmiddleX - 8.0;
            double btnx2 = btnmiddleX + 8.0;
            double btny1 = btnmiddleY - 8.0;
            double btny2 = btnmiddleY + 8.0;
            buffer.func_225582_a_(middleX + btnx1, middleY + btny1, (double)this.func_230927_p_()).func_225583_a_(sprite.func_94214_a(0.0), sprite.func_94207_b(0.0)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(middleX + btnx1, middleY + btny2, (double)this.func_230927_p_()).func_225583_a_(sprite.func_94214_a(0.0), sprite.func_94207_b(16.0)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(middleX + btnx2, middleY + btny2, (double)this.func_230927_p_()).func_225583_a_(sprite.func_94214_a(16.0), sprite.func_94207_b(16.0)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_(middleX + btnx2, middleY + btny1, (double)this.func_230927_p_()).func_225583_a_(sprite.func_94214_a(16.0), sprite.func_94207_b(0.0)).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        for (int i = 0; i < currentBuildMode.options.length; ++i) {
            ModeOptions.OptionEnum option = options[i];
            this.field_230712_o_.func_238405_a_(ms, I18n.func_135052_a((String)option.name, (Object[])new Object[0]), (float)((int)(middleX + 105.0 - 9.0)), (float)((int)middleY - 37 + i * 39), -286331137);
        }
        String credits = "Effortless Building";
        this.field_230712_o_.func_238405_a_(ms, credits, (float)(this.field_230708_k_ - this.field_230712_o_.func_78256_a(credits) - 4), (float)(this.field_230709_l_ - 10), -2004318072);
        for (MenuRegion menuRegion : modes) {
            if (!menuRegion.highlighted) continue;
            double x = (menuRegion.x1 + menuRegion.x2) * 0.5;
            double y = (menuRegion.y1 + menuRegion.y2) * 0.5;
            int fixed_x = (int)(x * 75.0);
            int n = (int)(y * 75.0);
            this.field_230712_o_.getClass();
            int fixed_y = n - 9 / 2;
            String text = I18n.func_135052_a((String)menuRegion.mode.name, (Object[])new Object[0]);
            if (x <= -0.2) {
                fixed_x -= this.field_230712_o_.func_78256_a(text);
            } else if (-0.2 <= x && x <= 0.2) {
                fixed_x -= this.field_230712_o_.func_78256_a(text) / 2;
            }
            this.field_230712_o_.func_238405_a_(ms, text, (float)((int)middleX + fixed_x), (float)((int)middleY + fixed_y), -1);
        }
        for (MenuButton button : buttons) {
            if (!button.highlighted) continue;
            String text = TextFormatting.AQUA + button.name;
            int wrap = 120;
            String keybind = "";
            String keybindFormatted = "";
            if (button.action == ModeOptions.ActionEnum.UNDO) {
                keybind = I18n.func_135052_a((String)ClientProxy.keyBindings[4].func_197982_m(), (Object[])new Object[0]);
            }
            if (button.action == ModeOptions.ActionEnum.REDO) {
                keybind = I18n.func_135052_a((String)ClientProxy.keyBindings[5].func_197982_m(), (Object[])new Object[0]);
            }
            if (button.action == ModeOptions.ActionEnum.REPLACE) {
                keybind = I18n.func_135052_a((String)ClientProxy.keyBindings[1].func_197982_m(), (Object[])new Object[0]);
            }
            if (button.action == ModeOptions.ActionEnum.OPEN_MODIFIER_SETTINGS) {
                keybind = I18n.func_135052_a((String)ClientProxy.keyBindings[0].func_197982_m(), (Object[])new Object[0]);
            }
            if (currentBuildMode.options.length > 0 && (button.action == currentBuildMode.options[0].actions[0] || button.action == currentBuildMode.options[0].actions[1]) && (keybind = I18n.func_135052_a((String)ClientProxy.keyBindings[6].func_197982_m(), (Object[])new Object[0])).equals("Left Control")) {
                keybind = "Ctrl";
            }
            if (!keybind.isEmpty()) {
                keybindFormatted = TextFormatting.GRAY + "(" + WordUtils.capitalizeFully((String)keybind) + ")";
            }
            if (button.textSide == Direction.WEST) {
                this.field_230712_o_.func_238421_b_(ms, text, (float)((int)(middleX + button.x1 - 8.0) - this.field_230712_o_.func_78256_a(text)), (float)((int)(middleY + button.y1 + 6.0)), -1);
                continue;
            }
            if (button.textSide == Direction.EAST) {
                this.field_230712_o_.func_238421_b_(ms, text, (float)((int)(middleX + button.x2 + 8.0)), (float)((int)(middleY + button.y1 + 6.0)), -1);
                continue;
            }
            if (button.textSide == Direction.UP || button.textSide == Direction.NORTH) {
                this.field_230712_o_.func_238421_b_(ms, keybindFormatted, (float)((int)(middleX + (button.x1 + button.x2) * 0.5 - (double)this.field_230712_o_.func_78256_a(keybindFormatted) * 0.5)), (float)((int)(middleY + button.y1 - 26.0)), -1);
                this.field_230712_o_.func_238421_b_(ms, text, (float)((int)(middleX + (button.x1 + button.x2) * 0.5 - (double)this.field_230712_o_.func_78256_a(text) * 0.5)), (float)((int)(middleY + button.y1 - 14.0)), -1);
                continue;
            }
            if (button.textSide != Direction.DOWN && button.textSide != Direction.SOUTH) continue;
            this.field_230712_o_.func_238421_b_(ms, text, (float)((int)(middleX + (button.x1 + button.x2) * 0.5 - (double)this.field_230712_o_.func_78256_a(text) * 0.5)), (float)((int)(middleY + button.y1 + 26.0)), -1);
            this.field_230712_o_.func_238421_b_(ms, keybindFormatted, (float)((int)(middleX + (button.x1 + button.x2) * 0.5 - (double)this.field_230712_o_.func_78256_a(keybindFormatted) * 0.5)), (float)((int)(middleY + button.y1 + 38.0)), -1);
        }
        RenderSystem.popMatrix();
    }

    private boolean inTriangle(double x1, double y1, double x2, double y2, double x3, double y3, double x, double y) {
        double ab = (x1 - x) * (y2 - y) - (x2 - x) * (y1 - y);
        double bc = (x2 - x) * (y3 - y) - (x3 - x) * (y2 - y);
        double ca = (x3 - x) * (y1 - y) - (x1 - x) * (y3 - y);
        return this.sign(ab) == this.sign(bc) && this.sign(bc) == this.sign(ca);
    }

    private int sign(double n) {
        return n > 0.0 ? 1 : -1;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        EffortlessBuilding.log("mouse clicked");
        KeyBinding.func_186704_a();
        KeyBinding.func_197980_a((InputMappings.Input)ClientProxy.keyBindings[3].getKey(), (boolean)true);
        if (mouseButton == 0) {
            this.field_230706_i_.func_147108_a(null);
            if (this.field_230706_i_.field_71462_r == null) {
                this.field_230706_i_.func_213228_a(true);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    static class MenuRegion {
        public final BuildModes.BuildModeEnum mode;
        public double x1;
        public double x2;
        public double y1;
        public double y2;
        public boolean highlighted;

        public MenuRegion(BuildModes.BuildModeEnum mode) {
            this.mode = mode;
        }
    }

    private static class MenuButton {
        public final ModeOptions.ActionEnum action;
        public double x1;
        public double x2;
        public double y1;
        public double y2;
        public boolean highlighted;
        public String name;
        public Direction textSide;

        public MenuButton(String name, ModeOptions.ActionEnum action, double x, double y, Direction textSide) {
            this.name = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.action = action;
            this.x1 = x - 10.0;
            this.x2 = x + 10.0;
            this.y1 = y - 10.0;
            this.y2 = y + 10.0;
            this.textSide = textSide;
        }
    }
}

