/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.gui.elements.GuiCheckBoxFixed;
import nl.requios.effortlessbuilding.gui.elements.GuiCollapsibleScrollEntry;
import nl.requios.effortlessbuilding.gui.elements.GuiIconButton;
import nl.requios.effortlessbuilding.gui.elements.GuiNumberField;
import nl.requios.effortlessbuilding.gui.elements.GuiScrollPane;
import nl.requios.effortlessbuilding.helper.ReachHelper;

@OnlyIn(value=Dist.CLIENT)
public class MirrorSettingsGui
extends GuiCollapsibleScrollEntry {
    protected static final ResourceLocation BUILDING_ICONS = new ResourceLocation("effortlessbuilding", "textures/gui/building_icons.png");
    protected List<Button> mirrorButtonList = new ArrayList<Button>();
    protected List<GuiIconButton> mirrorIconButtonList = new ArrayList<GuiIconButton>();
    protected List<GuiNumberField> mirrorNumberFieldList = new ArrayList<GuiNumberField>();
    private GuiNumberField textMirrorPosX;
    private GuiNumberField textMirrorPosY;
    private GuiNumberField textMirrorPosZ;
    private GuiNumberField textMirrorRadius;
    private GuiCheckBoxFixed buttonMirrorEnabled;
    private GuiCheckBoxFixed buttonMirrorX;
    private GuiCheckBoxFixed buttonMirrorY;
    private GuiCheckBoxFixed buttonMirrorZ;
    private GuiIconButton buttonCurrentPosition;
    private GuiIconButton buttonToggleOdd;
    private GuiIconButton buttonDrawPlanes;
    private GuiIconButton buttonDrawLines;
    private boolean drawPlanes;
    private boolean drawLines;
    private boolean toggleOdd;

    public MirrorSettingsGui(GuiScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public void init(List<Widget> buttonList) {
        super.init(buttonList);
        int y = this.top - 2;
        this.buttonMirrorEnabled = new GuiCheckBoxFixed(this.left - 15 + 8, y, "", false){

            public void func_230982_a_(double mouseX, double mouseY) {
                super.func_230982_a_(mouseX, mouseY);
                MirrorSettingsGui.this.setCollapsed(!MirrorSettingsGui.this.buttonMirrorEnabled.isChecked());
            }
        };
        buttonList.add((Widget)this.buttonMirrorEnabled);
        y = this.top + 18;
        this.textMirrorPosX = new GuiNumberField(this.font, buttonList, this.left + 58, y, 62, 18);
        this.textMirrorPosX.setNumber(0.0);
        this.textMirrorPosX.setTooltip(Arrays.asList(new StringTextComponent("The position of the mirror."), new StringTextComponent("For odd numbered builds add 0.5.").func_240699_a_(TextFormatting.GRAY)));
        this.mirrorNumberFieldList.add(this.textMirrorPosX);
        this.textMirrorPosY = new GuiNumberField(this.font, buttonList, this.left + 138, y, 62, 18);
        this.textMirrorPosY.setNumber(64.0);
        this.textMirrorPosY.setTooltip(Arrays.asList(new StringTextComponent("The position of the mirror."), new StringTextComponent("For odd numbered builds add 0.5.").func_240699_a_(TextFormatting.GRAY)));
        this.mirrorNumberFieldList.add(this.textMirrorPosY);
        this.textMirrorPosZ = new GuiNumberField(this.font, buttonList, this.left + 218, y, 62, 18);
        this.textMirrorPosZ.setNumber(0.0);
        this.textMirrorPosZ.setTooltip(Arrays.asList(new StringTextComponent("The position of the mirror."), new StringTextComponent("For odd numbered builds add 0.5.").func_240699_a_(TextFormatting.GRAY)));
        this.mirrorNumberFieldList.add(this.textMirrorPosZ);
        y = this.top + 50;
        this.buttonMirrorX = new GuiCheckBoxFixed(this.left + 60, y, " X", true);
        this.mirrorButtonList.add(this.buttonMirrorX);
        this.buttonMirrorY = new GuiCheckBoxFixed(this.left + 100, y, " Y", false);
        this.mirrorButtonList.add(this.buttonMirrorY);
        this.buttonMirrorZ = new GuiCheckBoxFixed(this.left + 140, y, " Z", false);
        this.mirrorButtonList.add(this.buttonMirrorZ);
        y = this.top + 47;
        this.textMirrorRadius = new GuiNumberField(this.font, buttonList, this.left + 218, y, 62, 18);
        this.textMirrorRadius.setNumber(50.0);
        this.textMirrorRadius.setTooltip(Arrays.asList(new StringTextComponent("How far the mirror reaches in any direction."), new StringTextComponent("Max: ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(ReachHelper.getMaxReach((PlayerEntity)this.mc.field_71439_g) / 2)).func_240699_a_(TextFormatting.GOLD)), new StringTextComponent("Upgradeable in survival with reach upgrades.").func_240699_a_(TextFormatting.GRAY)));
        this.mirrorNumberFieldList.add(this.textMirrorRadius);
        y = this.top + 72;
        this.buttonCurrentPosition = new GuiIconButton(this.left + 5, y, 0, 0, BUILDING_ICONS, button -> {
            Vector3d pos = new Vector3d(Math.floor(this.mc.field_71439_g.func_226277_ct_()) + 0.5, Math.floor(this.mc.field_71439_g.func_226278_cu_()) + 0.5, Math.floor(this.mc.field_71439_g.func_226281_cx_()) + 0.5);
            this.textMirrorPosX.setNumber(pos.field_72450_a);
            this.textMirrorPosY.setNumber(pos.field_72448_b);
            this.textMirrorPosZ.setNumber(pos.field_72449_c);
        });
        this.buttonCurrentPosition.setTooltip((ITextComponent)new StringTextComponent("Set mirror position to current player position"));
        this.mirrorIconButtonList.add(this.buttonCurrentPosition);
        this.buttonToggleOdd = new GuiIconButton(this.left + 35, y, 0, 20, BUILDING_ICONS, button -> {
            this.toggleOdd = !this.toggleOdd;
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
            if (this.toggleOdd) {
                this.buttonToggleOdd.setTooltip(Arrays.asList(new StringTextComponent("Set mirror position to corner of block"), new StringTextComponent("for even numbered builds")));
                this.textMirrorPosX.setNumber(this.textMirrorPosX.getNumber() + 0.5);
                this.textMirrorPosY.setNumber(this.textMirrorPosY.getNumber() + 0.5);
                this.textMirrorPosZ.setNumber(this.textMirrorPosZ.getNumber() + 0.5);
            } else {
                this.buttonToggleOdd.setTooltip(Arrays.asList(new StringTextComponent("Set mirror position to middle of block"), new StringTextComponent("for odd numbered builds")));
                this.textMirrorPosX.setNumber(Math.floor(this.textMirrorPosX.getNumber()));
                this.textMirrorPosY.setNumber(Math.floor(this.textMirrorPosY.getNumber()));
                this.textMirrorPosZ.setNumber(Math.floor(this.textMirrorPosZ.getNumber()));
            }
        });
        this.buttonToggleOdd.setTooltip(Arrays.asList(new StringTextComponent("Set mirror position to middle of block"), new StringTextComponent("for odd numbered builds")));
        this.mirrorIconButtonList.add(this.buttonToggleOdd);
        this.buttonDrawLines = new GuiIconButton(this.left + 65, y, 0, 40, BUILDING_ICONS, button -> {
            this.drawLines = !this.drawLines;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawLines.setTooltip((ITextComponent)new StringTextComponent(this.drawLines ? "Hide lines" : "Show lines"));
        });
        this.buttonDrawLines.setTooltip((ITextComponent)new StringTextComponent("Show lines"));
        this.mirrorIconButtonList.add(this.buttonDrawLines);
        this.buttonDrawPlanes = new GuiIconButton(this.left + 95, y, 0, 60, BUILDING_ICONS, button -> {
            this.drawPlanes = !this.drawPlanes;
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawPlanes.setTooltip((ITextComponent)new StringTextComponent(this.drawPlanes ? "Hide area" : "Show area"));
        });
        this.buttonDrawPlanes.setTooltip((ITextComponent)new StringTextComponent("Show area"));
        this.mirrorIconButtonList.add(this.buttonDrawPlanes);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)this.mc.field_71439_g);
        if (modifierSettings != null) {
            Mirror.MirrorSettings m = modifierSettings.getMirrorSettings();
            this.buttonMirrorEnabled.setIsChecked(m.enabled);
            this.textMirrorPosX.setNumber(m.position.field_72450_a);
            this.textMirrorPosY.setNumber(m.position.field_72448_b);
            this.textMirrorPosZ.setNumber(m.position.field_72449_c);
            this.buttonMirrorX.setIsChecked(m.mirrorX);
            this.buttonMirrorY.setIsChecked(m.mirrorY);
            this.buttonMirrorZ.setIsChecked(m.mirrorZ);
            this.textMirrorRadius.setNumber(m.radius);
            this.drawLines = m.drawLines;
            this.drawPlanes = m.drawPlanes;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawLines.setTooltip((ITextComponent)new StringTextComponent(this.drawLines ? "Hide lines" : "Show lines"));
            this.buttonDrawPlanes.setTooltip((ITextComponent)new StringTextComponent(this.drawPlanes ? "Hide area" : "Show area"));
            if (this.textMirrorPosX.getNumber() == Math.floor(this.textMirrorPosX.getNumber())) {
                this.toggleOdd = false;
                this.buttonToggleOdd.setTooltip(Arrays.asList(new StringTextComponent("Set mirror position to middle of block"), new StringTextComponent("for odd numbered builds")));
            } else {
                this.toggleOdd = true;
                this.buttonToggleOdd.setTooltip(Arrays.asList(new StringTextComponent("Set mirror position to corner of block"), new StringTextComponent("for even numbered builds")));
            }
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
        }
        buttonList.addAll(this.mirrorButtonList);
        buttonList.addAll(this.mirrorIconButtonList);
        this.setCollapsed(!this.buttonMirrorEnabled.isChecked());
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.mirrorNumberFieldList.forEach(GuiNumberField::update);
    }

    @Override
    public void drawEntry(MatrixStack ms, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int yy = y;
        int offset = 8;
        this.buttonMirrorEnabled.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        if (this.buttonMirrorEnabled.isChecked()) {
            this.buttonMirrorEnabled.field_230691_m_ = yy;
            this.font.func_238421_b_(ms, "Mirror enabled", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            yy = y + 18;
            this.font.func_238421_b_(ms, "Position", (float)(this.left + offset), (float)(yy + 5), 0xFFFFFF);
            this.font.func_238421_b_(ms, "X", (float)(this.left + 40 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textMirrorPosX.y = yy;
            this.font.func_238421_b_(ms, "Y", (float)(this.left + 120 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textMirrorPosY.y = yy;
            this.font.func_238421_b_(ms, "Z", (float)(this.left + 200 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textMirrorPosZ.y = yy;
            yy = y + 50;
            this.font.func_238421_b_(ms, "Direction", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            this.buttonMirrorX.field_230691_m_ = yy;
            this.buttonMirrorY.field_230691_m_ = yy;
            this.buttonMirrorZ.field_230691_m_ = yy;
            this.font.func_238421_b_(ms, "Radius", (float)(this.left + 176 + offset), (float)(yy + 2), 0xFFFFFF);
            this.textMirrorRadius.y = yy - 3;
            this.buttonCurrentPosition.field_230691_m_ = yy = y + 72;
            this.buttonToggleOdd.field_230691_m_ = yy;
            this.buttonDrawLines.field_230691_m_ = yy;
            this.buttonDrawPlanes.field_230691_m_ = yy;
            this.mirrorButtonList.forEach(button -> button.func_230430_a_(ms, mouseX, mouseY, partialTicks));
            this.mirrorIconButtonList.forEach(button -> button.func_230430_a_(ms, mouseX, mouseY, partialTicks));
            this.mirrorNumberFieldList.forEach(numberField -> numberField.drawNumberField(ms, mouseX, mouseY, partialTicks));
        } else {
            this.buttonMirrorEnabled.field_230691_m_ = yy;
            this.font.func_238421_b_(ms, "Mirror disabled", (float)(this.left + offset), (float)(yy + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(MatrixStack ms, Screen guiScreen, int mouseX, int mouseY) {
        if (this.buttonMirrorEnabled.isChecked()) {
            this.mirrorIconButtonList.forEach(iconButton -> iconButton.drawTooltip(ms, this.scrollPane.parent, mouseX, mouseY));
            this.mirrorNumberFieldList.forEach(numberField -> numberField.drawTooltip(ms, this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (GuiNumberField numberField : this.mirrorNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideMirrorEnabledLabel;
        this.mirrorNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideMirrorEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideMirrorEnabledLabel) {
            this.buttonMirrorEnabled.func_230988_a_(this.mc.func_147118_V());
            this.buttonMirrorEnabled.func_230982_a_(mouseX, mouseY);
        }
        return true;
    }

    public Mirror.MirrorSettings getMirrorSettings() {
        boolean mirrorEnabled = this.buttonMirrorEnabled.isChecked();
        Vector3d mirrorPos = new Vector3d(0.0, 64.0, 0.0);
        try {
            mirrorPos = new Vector3d(this.textMirrorPosX.getNumber(), this.textMirrorPosY.getNumber(), this.textMirrorPosZ.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((PlayerEntity)this.mc.field_71439_g, "Mirror position not a valid number.");
        }
        boolean mirrorX = this.buttonMirrorX.isChecked();
        boolean mirrorY = this.buttonMirrorY.isChecked();
        boolean mirrorZ = this.buttonMirrorZ.isChecked();
        int mirrorRadius = 50;
        try {
            mirrorRadius = (int)this.textMirrorRadius.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((PlayerEntity)this.mc.field_71439_g, "Mirror radius not a valid number.");
        }
        return new Mirror.MirrorSettings(mirrorEnabled, mirrorPos, mirrorX, mirrorY, mirrorZ, mirrorRadius, this.drawLines, this.drawPlanes);
    }

    @Override
    protected String getName() {
        return "Mirror";
    }

    @Override
    protected int getExpandedHeight() {
        return 100;
    }
}

