/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GuiNumberField
extends AbstractGui {
    public int x;
    public int y;
    public int width;
    public int height;
    public int buttonWidth = 10;
    protected TextFieldWidget textField;
    protected Button minusButton;
    protected Button plusButton;
    List<ITextComponent> tooltip = new ArrayList<ITextComponent>();

    public GuiNumberField(FontRenderer font, List<Widget> buttonList, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textField = new TextFieldWidget(font, x + this.buttonWidth + 1, y + 1, width - 2 * this.buttonWidth - 2, height - 2, StringTextComponent.field_240750_d_);
        this.minusButton = new Button(x, y - 1, this.buttonWidth, height + 2, (ITextComponent)new StringTextComponent("-"), button -> {
            float valueChanged = 1.0f;
            if (Screen.func_231172_r_()) {
                valueChanged = 5.0f;
            }
            if (Screen.func_231173_s_()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() - (double)valueChanged);
        });
        this.plusButton = new Button(x + width - this.buttonWidth, y - 1, this.buttonWidth, height + 2, (ITextComponent)new StringTextComponent("+"), button -> {
            float valueChanged = 1.0f;
            if (Screen.func_231172_r_()) {
                valueChanged = 5.0f;
            }
            if (Screen.func_231173_s_()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() + (double)valueChanged);
        });
        buttonList.add((Widget)this.minusButton);
        buttonList.add((Widget)this.plusButton);
    }

    public double getNumber() {
        if (this.textField.func_146179_b().isEmpty()) {
            return 0.0;
        }
        try {
            return DecimalFormat.getInstance().parse(this.textField.func_146179_b()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public void setNumber(double number) {
        this.textField.func_146180_a(DecimalFormat.getInstance().format(number));
    }

    public void setTooltip(ITextComponent tooltip) {
        this.setTooltip(Collections.singletonList(tooltip));
    }

    public void setTooltip(List<ITextComponent> tooltip) {
        this.tooltip = tooltip;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        boolean result = this.textField.func_231044_a_(mouseX, mouseY, mouseButton);
        boolean bl = flag = mouseX >= (double)(this.x + this.buttonWidth) && mouseX < (double)(this.x + this.width - this.buttonWidth) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        if (flag && mouseButton == 1) {
            this.textField.func_146180_a("");
            this.textField.func_146195_b(true);
            result = true;
        }
        return result;
    }

    public void drawNumberField(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.textField.field_230691_m_ = this.y + 1;
        this.minusButton.field_230691_m_ = this.y - 1;
        this.plusButton.field_230691_m_ = this.y - 1;
        this.textField.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.minusButton.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.plusButton.func_230430_a_(ms, mouseX, mouseY, partialTicks);
    }

    public void drawTooltip(MatrixStack ms, Screen screen, int mouseX, int mouseY) {
        boolean insideTextField = mouseX >= this.x + this.buttonWidth && mouseX < this.x + this.width - this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insideMinusButton = mouseX >= this.x && mouseX < this.x + this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insidePlusButton = mouseX >= this.x + this.width - this.buttonWidth && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        ArrayList<Object> textLines = new ArrayList<Object>();
        if (insideTextField) {
            textLines.addAll(this.tooltip);
        }
        if (insideMinusButton) {
            textLines.add(new StringTextComponent("Hold ").func_230529_a_((ITextComponent)new StringTextComponent("shift ").func_240699_a_(TextFormatting.AQUA)).func_240702_b_("for ").func_230529_a_((ITextComponent)new StringTextComponent("10").func_240699_a_(TextFormatting.RED)));
            textLines.add(new StringTextComponent("Hold ").func_230529_a_((ITextComponent)new StringTextComponent("ctrl ").func_240699_a_(TextFormatting.AQUA)).func_240702_b_("for ").func_230529_a_((ITextComponent)new StringTextComponent("5").func_240699_a_(TextFormatting.RED)));
        }
        if (insidePlusButton) {
            textLines.add(new StringTextComponent("Hold ").func_230529_a_((ITextComponent)new StringTextComponent("shift ").func_240699_a_(TextFormatting.DARK_GREEN)).func_240702_b_("for ").func_230529_a_((ITextComponent)new StringTextComponent("10").func_240699_a_(TextFormatting.RED)));
            textLines.add(new StringTextComponent("Hold ").func_230529_a_((ITextComponent)new StringTextComponent("ctrl ").func_240699_a_(TextFormatting.DARK_GREEN)).func_240702_b_("for ").func_230529_a_((ITextComponent)new StringTextComponent("5").func_240699_a_(TextFormatting.RED)));
        }
        screen.func_243308_b(ms, textLines, mouseX - 10, mouseY + 25);
    }

    public void update() {
        this.textField.func_146178_a();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.textField.func_230999_j_()) {
            return false;
        }
        return this.textField.func_231042_a_(typedChar, keyCode);
    }
}

