/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.helper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;

public class SurvivalHelper {
    public static boolean placeBlock(World world, PlayerEntity player, BlockPos pos, BlockState blockState, ItemStack origstack, Direction facing, Vector3d hitVec, boolean skipPlaceCheck, boolean skipCollisionCheck, boolean playSound) {
        if (!world.func_195588_v(pos)) {
            return false;
        }
        ItemStack itemstack = origstack;
        if (blockState.func_177230_c().isAir(blockState, (IBlockReader)world, pos) || itemstack.func_190926_b()) {
            SurvivalHelper.dropBlock(world, player, pos);
            world.func_217377_a(pos, false);
            return true;
        }
        if (CompatHelper.isItemBlockProxy(itemstack)) {
            itemstack = CompatHelper.getItemBlockByState(itemstack, blockState);
        }
        if (!(itemstack.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        Block block = ((BlockItem)itemstack.func_77973_b()).func_179223_d();
        if (skipPlaceCheck || SurvivalHelper.canPlace(world, player, pos, blockState, itemstack, skipCollisionCheck, facing.func_176734_d())) {
            SurvivalHelper.dropBlock(world, player, pos);
            if (!world.func_180501_a(pos, blockState, 3)) {
                return false;
            }
            BlockItem.func_179224_a((World)world, (PlayerEntity)player, (BlockPos)pos, (ItemStack)itemstack);
            block.func_180633_a(world, pos, blockState, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, itemstack);
            }
            BlockState afterState = world.func_180495_p(pos);
            if (playSound) {
                SoundType soundtype = afterState.func_177230_c().getSoundType(afterState, (IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            }
            if (!player.func_184812_l_() && Block.func_149634_a((Item)itemstack.func_77973_b()) == block) {
                CompatHelper.shrinkStack(origstack, itemstack, player);
            }
            return true;
        }
        return false;
    }

    public static boolean breakBlock(World world, PlayerEntity player, BlockPos pos, boolean skipChecks) {
        if (!world.func_195588_v(pos) && !world.func_175623_d(pos)) {
            return false;
        }
        if (skipChecks || SurvivalHelper.canBreak(world, player, pos)) {
            SurvivalHelper.dropBlock(world, player, pos);
            player.func_184614_ca().func_179548_a(world, world.func_180495_p(pos), pos, player);
            world.func_217377_a(pos, false);
            return true;
        }
        return false;
    }

    public static void dropBlock(World world, PlayerEntity player, BlockPos pos) {
        if (player.func_184812_l_()) {
            return;
        }
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        block.func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), player.func_184614_ca());
    }

    public static boolean canPlace(World world, PlayerEntity player, BlockPos pos, BlockState newBlockState, ItemStack itemStack, boolean skipCollisionCheck, Direction sidePlacedOn) {
        if (!(itemStack.func_77973_b() instanceof BlockItem) || Block.func_149634_a((Item)itemStack.func_77973_b()) != newBlockState.func_177230_c()) {
            return false;
        }
        Block block = ((BlockItem)itemStack.func_77973_b()).func_179223_d();
        return !itemStack.func_190926_b() && SurvivalHelper.canPlayerEdit(player, world, pos, itemStack) && SurvivalHelper.mayPlace(world, block, newBlockState, pos, skipCollisionCheck, sidePlacedOn, (Entity)player) && SurvivalHelper.canReplace(world, player, pos);
    }

    private static boolean canReplace(World world, PlayerEntity player, BlockPos pos) {
        if (player.func_184812_l_()) {
            return true;
        }
        BlockState state = world.func_180495_p(pos);
        switch ((Integer)BuildConfig.survivalBalancers.quickReplaceMiningLevel.get()) {
            case -1: {
                return !state.func_235783_q_();
            }
            case 0: {
                return state.func_177230_c().getHarvestLevel(state) <= 0;
            }
            case 1: {
                return state.func_177230_c().getHarvestLevel(state) <= 1;
            }
            case 2: {
                return state.func_177230_c().getHarvestLevel(state) <= 2;
            }
            case 3: {
                return state.func_177230_c().getHarvestLevel(state) <= 3;
            }
        }
        return false;
    }

    private static boolean canPlayerEdit(PlayerEntity player, World world, BlockPos pos, ItemStack stack) {
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        if (player.field_71075_bZ.field_75099_e) {
            return true;
        }
        CachedBlockInfo blockworldstate = new CachedBlockInfo((IWorldReader)world, pos, false);
        return stack.func_206847_b(world.func_205772_D(), blockworldstate);
    }

    private static boolean mayPlace(World world, Block blockIn, BlockState newBlockState, BlockPos pos, boolean skipCollisionCheck, Direction sidePlacedOn, @Nullable Entity placer) {
        VoxelShape voxelShape;
        BlockState iblockstate1 = world.func_180495_p(pos);
        VoxelShape voxelShape2 = voxelShape = skipCollisionCheck ? null : blockIn.func_176223_P().func_196952_d((IBlockReader)world, pos);
        if (voxelShape != null && !world.func_195585_a(placer, voxelShape)) {
            return false;
        }
        if (placer != null && SurvivalHelper.doesBecomeDoubleSlab((PlayerEntity)placer, pos, sidePlacedOn)) {
            return true;
        }
        if (iblockstate1 == newBlockState) {
            return false;
        }
        if (iblockstate1.func_185904_a() == Material.field_151591_t && blockIn == Blocks.field_150467_bQ) {
            return true;
        }
        if (placer instanceof PlayerEntity && ModifierSettingsManager.getModifierSettings((PlayerEntity)placer).doQuickReplace()) {
            return true;
        }
        return iblockstate1.func_185904_a().func_76222_j();
    }

    public static boolean canBreak(World world, PlayerEntity player, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        if (!world.func_204610_c(pos).func_206888_e()) {
            return false;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        return SurvivalHelper.canHarvestBlock(blockState.func_177230_c(), player, world, pos);
    }

    public static boolean canHarvestBlock(@Nonnull Block block, @Nonnull PlayerEntity player, @Nonnull World world, @Nonnull BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_185887_b((IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        if (!state.func_235783_q_()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        ToolType tool = block.getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return player.func_234569_d_(state);
        }
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            return false;
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_234569_d_(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean doesBecomeDoubleSlab(PlayerEntity player, BlockPos pos, Direction facing) {
        BlockState placedBlockState = player.field_70170_p.func_180495_p(pos);
        ItemStack itemstack = player.func_184586_b(Hand.MAIN_HAND);
        if (CompatHelper.isItemBlockProxy(itemstack)) {
            itemstack = CompatHelper.getItemBlockFromStack(itemstack);
        }
        if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof BlockItem) || !(((BlockItem)itemstack.func_77973_b()).func_179223_d() instanceof SlabBlock)) {
            return false;
        }
        SlabBlock heldSlab = (SlabBlock)((BlockItem)itemstack.func_77973_b()).func_179223_d();
        if (placedBlockState.func_177230_c() == heldSlab) {
            // empty if block
        }
        return false;
    }
}

