/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;

public class AddUndoMessage {
    private final BlockPos coordinate;
    private final BlockState previousBlockState;
    private final BlockState newBlockState;

    public AddUndoMessage() {
        this.coordinate = BlockPos.field_177992_a;
        this.previousBlockState = null;
        this.newBlockState = null;
    }

    public AddUndoMessage(BlockPos coordinate, BlockState previousBlockState, BlockState newBlockState) {
        this.coordinate = coordinate;
        this.previousBlockState = previousBlockState;
        this.newBlockState = newBlockState;
    }

    public static void encode(AddUndoMessage message, PacketBuffer buf) {
        buf.writeInt(message.coordinate.func_177958_n());
        buf.writeInt(message.coordinate.func_177956_o());
        buf.writeInt(message.coordinate.func_177952_p());
        buf.writeInt(Block.func_196246_j((BlockState)message.previousBlockState));
        buf.writeInt(Block.func_196246_j((BlockState)message.newBlockState));
    }

    public static AddUndoMessage decode(PacketBuffer buf) {
        BlockPos coordinate = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        BlockState previousBlockState = Block.func_196257_b((int)buf.readInt());
        BlockState newBlockState = Block.func_196257_b((int)buf.readInt());
        return new AddUndoMessage(coordinate, previousBlockState, newBlockState);
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public BlockState getPreviousBlockState() {
        return this.previousBlockState;
    }

    public BlockState getNewBlockState() {
        return this.newBlockState;
    }

    public static class Handler {
        public static void handle(final AddUndoMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    PlayerEntity player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                    UndoRedo.addUndo(player, new BlockSet((List<BlockPos>)new ArrayList<BlockPos>(){
                        {
                            this.add(message.getCoordinate());
                        }
                    }, (List<BlockState>)new ArrayList<BlockState>(){
                        {
                            this.add(message.getPreviousBlockState());
                        }
                    }, (List<BlockState>)new ArrayList<BlockState>(){
                        {
                            this.add(message.getNewBlockState());
                        }
                    }, new Vector3d(0.0, 0.0, 0.0), message.getCoordinate(), message.getCoordinate()));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

