/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;

public class BlockPlacedMessage {
    private final boolean blockHit;
    private final BlockPos blockPos;
    private final Direction sideHit;
    private final Vector3d hitVec;
    private final boolean placeStartPos;

    public BlockPlacedMessage() {
        this.blockHit = false;
        this.blockPos = BlockPos.field_177992_a;
        this.sideHit = Direction.UP;
        this.hitVec = new Vector3d(0.0, 0.0, 0.0);
        this.placeStartPos = true;
    }

    public BlockPlacedMessage(BlockRayTraceResult result, boolean placeStartPos) {
        this.blockHit = result.func_216346_c() == RayTraceResult.Type.BLOCK;
        this.blockPos = result.func_216350_a();
        this.sideHit = result.func_216354_b();
        this.hitVec = result.func_216347_e();
        this.placeStartPos = placeStartPos;
    }

    public BlockPlacedMessage(boolean blockHit, BlockPos blockPos, Direction sideHit, Vector3d hitVec, boolean placeStartPos) {
        this.blockHit = blockHit;
        this.blockPos = blockPos;
        this.sideHit = sideHit;
        this.hitVec = hitVec;
        this.placeStartPos = placeStartPos;
    }

    public static void encode(BlockPlacedMessage message, PacketBuffer buf) {
        buf.writeBoolean(message.blockHit);
        buf.writeInt(message.blockPos.func_177958_n());
        buf.writeInt(message.blockPos.func_177956_o());
        buf.writeInt(message.blockPos.func_177952_p());
        buf.writeInt(message.sideHit.func_176745_a());
        buf.writeDouble(message.hitVec.field_72450_a);
        buf.writeDouble(message.hitVec.field_72448_b);
        buf.writeDouble(message.hitVec.field_72449_c);
        buf.writeBoolean(message.placeStartPos);
    }

    public static BlockPlacedMessage decode(PacketBuffer buf) {
        boolean blockHit = buf.readBoolean();
        BlockPos blockPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        Direction sideHit = Direction.func_82600_a((int)buf.readInt());
        Vector3d hitVec = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        boolean placeStartPos = buf.readBoolean();
        return new BlockPlacedMessage(blockHit, blockPos, sideHit, hitVec, placeStartPos);
    }

    public boolean isBlockHit() {
        return this.blockHit;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Direction getSideHit() {
        return this.sideHit;
    }

    public Vector3d getHitVec() {
        return this.hitVec;
    }

    public boolean getPlaceStartPos() {
        return this.placeStartPos;
    }

    public static class Handler {
        public static void handle(BlockPlacedMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    BlockPreviewRenderer.onBlocksPlaced();
                } else {
                    BuildModes.onBlockPlacedMessage((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), message);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

