/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.render.RenderHandler;

@OnlyIn(value=Dist.CLIENT)
public class ModifierRenderer {
    protected static final Color colorX = new Color(255, 72, 52);
    protected static final Color colorY = new Color(67, 204, 51);
    protected static final Color colorZ = new Color(52, 247, 255);
    protected static final Color colorRadial = new Color(52, 247, 255);
    protected static final int lineAlpha = 200;
    protected static final int planeAlpha = 75;
    protected static final Vector3d epsilon = new Vector3d(0.001, 0.001, 0.001);

    public static void render(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, ModifierSettingsManager.ModifierSettings modifierSettings) {
        RadialMirror.RadialMirrorSettings r;
        Mirror.MirrorSettings m = modifierSettings.getMirrorSettings();
        if (m != null && m.enabled && (m.mirrorX || m.mirrorY || m.mirrorZ)) {
            Vector3d posB;
            Vector3d posA;
            Vector3d pos = m.position.func_178787_e(epsilon);
            int radius = m.radius;
            if (m.mirrorX) {
                posA = new Vector3d(pos.field_72450_a, pos.field_72448_b - (double)radius, pos.field_72449_c - (double)radius);
                posB = new Vector3d(pos.field_72450_a, pos.field_72448_b + (double)radius, pos.field_72449_c + (double)radius);
                ModifierRenderer.drawMirrorPlane(matrixStack, renderTypeBuffer, posA, posB, colorX, m.drawLines, m.drawPlanes, true);
            }
            if (m.mirrorY) {
                posA = new Vector3d(pos.field_72450_a - (double)radius, pos.field_72448_b, pos.field_72449_c - (double)radius);
                posB = new Vector3d(pos.field_72450_a + (double)radius, pos.field_72448_b, pos.field_72449_c + (double)radius);
                ModifierRenderer.drawMirrorPlaneY(matrixStack, renderTypeBuffer, posA, posB, colorY, m.drawLines, m.drawPlanes);
            }
            if (m.mirrorZ) {
                posA = new Vector3d(pos.field_72450_a - (double)radius, pos.field_72448_b - (double)radius, pos.field_72449_c);
                posB = new Vector3d(pos.field_72450_a + (double)radius, pos.field_72448_b + (double)radius, pos.field_72449_c);
                ModifierRenderer.drawMirrorPlane(matrixStack, renderTypeBuffer, posA, posB, colorZ, m.drawLines, m.drawPlanes, true);
            }
            if (m.drawLines && (m.mirrorX && m.mirrorY || m.mirrorX && m.mirrorZ || m.mirrorY && m.mirrorZ)) {
                ModifierRenderer.drawMirrorLines(matrixStack, renderTypeBuffer, m);
            }
        }
        if ((r = modifierSettings.getRadialMirrorSettings()) != null && r.enabled) {
            Vector3d pos = r.position.func_178787_e(epsilon);
            int radius = r.radius;
            float angle = (float)Math.PI * 2 / (float)r.slices;
            Vector3d relStartVec = new Vector3d((double)radius, 0.0, 0.0);
            if (r.slices % 4 == 2) {
                relStartVec = relStartVec.func_178785_b(angle / 2.0f);
            }
            for (int i = 0; i < r.slices; ++i) {
                Vector3d relNewVec = relStartVec.func_178785_b(angle * (float)i);
                Vector3d newVec = pos.func_178787_e(relNewVec);
                Vector3d posA = new Vector3d(pos.field_72450_a, pos.field_72448_b - (double)radius, pos.field_72449_c);
                Vector3d posB = new Vector3d(newVec.field_72450_a, pos.field_72448_b + (double)radius, newVec.field_72449_c);
                ModifierRenderer.drawMirrorPlane(matrixStack, renderTypeBuffer, posA, posB, colorRadial, r.drawLines, r.drawPlanes, false);
            }
        }
    }

    protected static void drawMirrorPlane(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, Vector3d posA, Vector3d posB, Color c, boolean drawLines, boolean drawPlanes, boolean drawVerticalLines) {
        IVertexBuilder buffer;
        Matrix4f matrixPos = matrixStack.func_227866_c_().func_227870_a_();
        if (drawPlanes) {
            buffer = RenderHandler.beginPlanes(renderTypeBuffer);
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)posA.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)posB.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posB.field_72450_a, (float)posA.field_72448_b, (float)posB.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posB.field_72450_a, (float)posB.field_72448_b, (float)posB.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)posA.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)posB.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            RenderHandler.endPlanes(renderTypeBuffer);
        }
        if (drawLines) {
            buffer = RenderHandler.beginLines(renderTypeBuffer);
            Vector3d middle = posA.func_178787_e(posB).func_186678_a(0.5);
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)middle.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posB.field_72450_a, (float)middle.field_72448_b, (float)posB.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            if (drawVerticalLines) {
                buffer.func_227888_a_(matrixPos, (float)middle.field_72450_a, (float)posA.field_72448_b, (float)middle.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
                buffer.func_227888_a_(matrixPos, (float)middle.field_72450_a, (float)posB.field_72448_b, (float)middle.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            }
            RenderHandler.endLines(renderTypeBuffer);
        }
    }

    protected static void drawMirrorPlaneY(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, Vector3d posA, Vector3d posB, Color c, boolean drawLines, boolean drawPlanes) {
        IVertexBuilder buffer;
        Matrix4f matrixPos = matrixStack.func_227866_c_().func_227870_a_();
        if (drawPlanes) {
            buffer = RenderHandler.beginPlanes(renderTypeBuffer);
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)posA.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)posA.field_72448_b, (float)posB.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posB.field_72450_a, (float)posA.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posB.field_72450_a, (float)posA.field_72448_b, (float)posB.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)posA.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)posA.field_72448_b, (float)posB.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            RenderHandler.endPlanes(renderTypeBuffer);
        }
        if (drawLines) {
            buffer = RenderHandler.beginLines(renderTypeBuffer);
            Vector3d middle = posA.func_178787_e(posB).func_186678_a(0.5);
            buffer.func_227888_a_(matrixPos, (float)middle.field_72450_a, (float)middle.field_72448_b, (float)posA.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)middle.field_72450_a, (float)middle.field_72448_b, (float)posB.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posA.field_72450_a, (float)middle.field_72448_b, (float)middle.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            buffer.func_227888_a_(matrixPos, (float)posB.field_72450_a, (float)middle.field_72448_b, (float)middle.field_72449_c).func_225586_a_(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            RenderHandler.endLines(renderTypeBuffer);
        }
    }

    protected static void drawMirrorLines(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, Mirror.MirrorSettings m) {
        IVertexBuilder buffer = RenderHandler.beginLines(renderTypeBuffer);
        Matrix4f matrixPos = matrixStack.func_227866_c_().func_227870_a_();
        Vector3d pos = m.position.func_178787_e(epsilon);
        buffer.func_227888_a_(matrixPos, (float)pos.field_72450_a - (float)m.radius, (float)pos.field_72448_b, (float)pos.field_72449_c).func_225586_a_(colorX.getRed(), colorX.getGreen(), colorX.getBlue(), 200).func_181675_d();
        buffer.func_227888_a_(matrixPos, (float)pos.field_72450_a + (float)m.radius, (float)pos.field_72448_b, (float)pos.field_72449_c).func_225586_a_(colorX.getRed(), colorX.getGreen(), colorX.getBlue(), 200).func_181675_d();
        buffer.func_227888_a_(matrixPos, (float)pos.field_72450_a, (float)pos.field_72448_b - (float)m.radius, (float)pos.field_72449_c).func_225586_a_(colorY.getRed(), colorY.getGreen(), colorY.getBlue(), 200).func_181675_d();
        buffer.func_227888_a_(matrixPos, (float)pos.field_72450_a, (float)pos.field_72448_b + (float)m.radius, (float)pos.field_72449_c).func_225586_a_(colorY.getRed(), colorY.getGreen(), colorY.getBlue(), 200).func_181675_d();
        buffer.func_227888_a_(matrixPos, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c - (float)m.radius).func_225586_a_(colorZ.getRed(), colorZ.getGreen(), colorZ.getBlue(), 200).func_181675_d();
        buffer.func_227888_a_(matrixPos, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c + (float)m.radius).func_225586_a_(colorZ.getRed(), colorZ.getGreen(), colorZ.getBlue(), 200).func_181675_d();
        RenderHandler.endLines(renderTypeBuffer);
    }
}

