/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.registry;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.mobenchant.ProtectionMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.SpeedyMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.StrongMobEnchant;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enchantwithmob", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEnchants {
    public static final MobEnchant PROTECTION = new ProtectionMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.COMMON, 4));
    public static final MobEnchant SPEEDY = new SpeedyMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.UNCOMMON, 2));
    public static final MobEnchant STRONG = new StrongMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.COMMON, 3));
    private static ForgeRegistry<MobEnchant> registry;

    @SubscribeEvent
    public static void onNewRegistry(RegistryEvent.NewRegistry event) {
        registry = (ForgeRegistry)new RegistryBuilder().setType(MobEnchant.class).setName(new ResourceLocation("enchantwithmob", "mob_enchant")).setDefaultKey(new ResourceLocation("enchantwithmob", "protection")).create();
    }

    @SubscribeEvent
    public static void onRegisterEnchant(RegistryEvent.Register<MobEnchant> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new MobEnchant[]{(MobEnchant)PROTECTION.setRegistryName("protection"), (MobEnchant)SPEEDY.setRegistryName("speedy"), (MobEnchant)STRONG.setRegistryName("strong")});
    }

    public static ForgeRegistry<MobEnchant> getRegistry() {
        if (registry == null) {
            throw new IllegalStateException("Registry not yet initialized");
        }
        return registry;
    }

    public static int getId(MobEnchant enchant) {
        return registry.getID((IForgeRegistryEntry)enchant);
    }

    public static MobEnchant byId(int id) {
        return (MobEnchant)registry.getValue(id);
    }
}

