/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.entity;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.registry.ModItems;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnchanterEntity
extends SpellcastingIllagerEntity {
    private LivingEntity enchantTarget;
    public float prevCapeX;
    public float prevCapeY;
    public float prevCapeZ;
    public float capeX;
    public float capeY;
    public float capeZ;
    private float clientSideBookAnimation0;
    private float clientSideBookAnimation;

    public EnchanterEntity(EntityType<? extends EnchanterEntity> type, World p_i48551_2_) {
        super(type, p_i48551_2_);
        this.field_70728_aV = 12;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, new AvoidTargetEntityGoal<MobEntity>(this, MobEntity.class, 6.5f, 0.8, 1.05));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.8, 1.15));
        this.field_70714_bg.func_75776_a(3, (Goal)new SpellGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public static AttributeModifierMap.MutableAttribute getAttributeMap() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233819_b_, 24.0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideBookAnimation != this.clientSideBookAnimation0) {
                this.func_213323_x_();
            }
            this.clientSideBookAnimation0 = this.clientSideBookAnimation;
            this.clientSideBookAnimation = this.func_193082_dl() ? MathHelper.func_76131_a((float)(this.clientSideBookAnimation + 0.1f), (float)0.0f, (float)1.0f) : MathHelper.func_76131_a((float)(this.clientSideBookAnimation - 0.15f), (float)0.0f, (float)1.0f);
        }
        this.updateCape();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBookAnimationScale(float tick) {
        return MathHelper.func_219799_g((float)tick, (float)this.clientSideBookAnimation0, (float)this.clientSideBookAnimation) / 1.0f;
    }

    private void updateCape() {
        double elasticity = 0.25;
        double gravity = -0.1;
        this.prevCapeX = this.capeX;
        this.prevCapeY = this.capeY;
        this.prevCapeZ = this.capeZ;
        this.capeY = (float)((double)this.capeY + gravity);
        this.capeX = (float)((double)this.capeX + (this.func_226277_ct_() - (double)this.capeX) * elasticity);
        this.capeY = (float)((double)this.capeY + (this.func_226278_cu_() - (double)this.capeY) * elasticity);
        this.capeZ = (float)((double)this.capeZ + (this.func_226281_cx_() - (double)this.capeZ) * elasticity);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    private void setEnchantTarget(@Nullable LivingEntity enchantTargetIn) {
        this.enchantTarget = enchantTargetIn;
    }

    @Nullable
    public LivingEntity getEnchantTarget() {
        return this.enchantTarget;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        if (this.field_70146_Z.nextFloat() < 0.125f + 0.025f * (float)looting) {
            ItemStack itemStack = new ItemStack((IItemProvider)ModItems.MOB_ENCHANT_BOOK);
            this.func_199701_a_(MobEnchantUtils.addRandomEnchantmentToItemStack(this.field_70146_Z, itemStack, 20, true));
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_193786_de;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_193787_df;
    }

    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_190021_aL;
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_193783_dc;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.func_193082_dl()) {
            return AbstractIllagerEntity.ArmPose.SPELLCASTING;
        }
        return AbstractIllagerEntity.ArmPose.CROSSED;
    }

    class AvoidTargetEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final EnchanterEntity enchanter;

        public AvoidTargetEntityGoal(EnchanterEntity enchanterIn, Class<T> entityClassToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super((CreatureEntity)enchanterIn, entityClassToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
            this.enchanter = enchanterIn;
        }

        public boolean func_75250_a() {
            if (super.func_75250_a() && this.field_75376_d == this.enchanter.func_70638_az()) {
                return this.enchanter.func_70638_az() != null;
            }
            return false;
        }

        public void func_75249_e() {
            EnchanterEntity.this.func_70624_b(null);
            super.func_75249_e();
        }

        public void func_75246_d() {
            EnchanterEntity.this.func_70624_b(null);
            super.func_75246_d();
        }
    }

    public class SpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private final Predicate<LivingEntity> fillter;

        public SpellGoal() {
            super((SpellcastingIllagerEntity)EnchanterEntity.this);
            this.fillter = entity -> !(entity instanceof EnchanterEntity) && entity instanceof IMob && (Boolean)entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).map(mob -> !mob.hasEnchant()).orElse((Object)false) != false;
        }

        public boolean func_75250_a() {
            if (EnchanterEntity.this.func_70638_az() == null) {
                return false;
            }
            if (EnchanterEntity.this.func_193082_dl()) {
                return false;
            }
            if (EnchanterEntity.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            List list = EnchanterEntity.this.field_70170_p.func_175647_a(LivingEntity.class, EnchanterEntity.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), this.fillter);
            if (list.isEmpty()) {
                return false;
            }
            LivingEntity target = (LivingEntity)list.get(EnchanterEntity.this.field_70146_Z.nextInt(list.size()));
            if (target != EnchanterEntity.this.func_70638_az()) {
                EnchanterEntity.this.setEnchantTarget((LivingEntity)list.get(EnchanterEntity.this.field_70146_Z.nextInt(list.size())));
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EnchanterEntity.this.getEnchantTarget() != null && EnchanterEntity.this.getEnchantTarget() != EnchanterEntity.this.func_70638_az() && this.field_193321_c > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EnchanterEntity.this.setEnchantTarget(null);
        }

        protected void func_190868_j() {
            LivingEntity entity = EnchanterEntity.this.getEnchantTarget();
            if (entity != null && entity.func_70089_S()) {
                entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> MobEnchantUtils.addRandomEnchantmentToEntity(entity, cap, entity.func_70681_au(), 12, false));
            }
        }

        protected int func_190867_m() {
            return 40;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 600;
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_187941_ho;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.WOLOLO;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super((SpellcastingIllagerEntity)EnchanterEntity.this);
        }

        public void func_75246_d() {
            if (EnchanterEntity.this.func_193082_dl() && EnchanterEntity.this.getEnchantTarget() != null) {
                EnchanterEntity.this.func_70671_ap().func_75651_a((Entity)EnchanterEntity.this.getEnchantTarget(), (float)EnchanterEntity.this.func_184649_cE(), (float)EnchanterEntity.this.func_70646_bf());
            } else if (EnchanterEntity.this.func_193082_dl() && EnchanterEntity.this.func_70638_az() != null) {
                EnchanterEntity.this.func_70671_ap().func_75651_a((Entity)EnchanterEntity.this.func_70638_az(), (float)EnchanterEntity.this.func_184649_cE(), (float)EnchanterEntity.this.func_70646_bf());
            }
        }
    }
}

