/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.item;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class MobEnchantBookItem
extends Item {
    public MobEnchantBookItem(Item.Properties group) {
        super(group);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (MobEnchantUtils.hasMobEnchant(stack)) {
            target.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> MobEnchantUtils.addMobEnchantToEntity(stack, target, cap));
            playerIn.func_184185_a(SoundEvents.field_190021_aL, 1.0f, 1.0f);
            stack.func_222118_a(1, (LivingEntity)playerIn, entity -> entity.func_213334_d(hand));
            return ActionResultType.SUCCESS;
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (MobEnchant enchant : MobEnchants.getRegistry()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                MobEnchantUtils.addMobEnchantToItemStack(stack, enchant, enchant.getMaxLevel());
                items.add((Object)stack);
            }
        }
    }

    public static ListNBT getEnchantmentList(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null ? compoundnbt.func_150295_c("StoredMobEnchants", 10) : new ListNBT();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (MobEnchantUtils.hasMobEnchant(stack)) {
            ListNBT listnbt = MobEnchantUtils.getEnchantmentListForNBT(stack.func_77978_p());
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
                int level = MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt);
                if (mobEnchant == null) continue;
                TextFormatting[] textformatting = new TextFormatting[]{TextFormatting.AQUA};
                tooltip.add((ITextComponent)new TranslationTextComponent("mobenchant.enchantwithmob.name." + mobEnchant.getRegistryName().func_110624_b() + "." + mobEnchant.getRegistryName().func_110623_a()).func_240701_a_(textformatting).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + level).func_240701_a_(textformatting)));
            }
            ArrayList list1 = Lists.newArrayList();
            for (int i = 0; i < listnbt.size(); ++i) {
                Map<Attribute, AttributeModifier> map;
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
                int mobEnchantLevel = MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt);
                if (mobEnchant == null || (map = mobEnchant.getAttributeModifierMap()).isEmpty()) continue;
                for (Map.Entry<Attribute, AttributeModifier> entry : map.entrySet()) {
                    AttributeModifier attributemodifier = entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), mobEnchant.getAttributeModifierAmount(mobEnchantLevel, attributemodifier), attributemodifier.func_220375_c());
                    list1.add(new Pair((Object)entry.getKey(), (Object)attributemodifier1));
                }
            }
            if (!list1.isEmpty()) {
                tooltip.add(StringTextComponent.field_240750_d_);
                tooltip.add((ITextComponent)new TranslationTextComponent("mobenchant.enchantwithmob.when_ehcnanted").func_240699_a_(TextFormatting.DARK_PURPLE));
                for (Pair pair : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                    double d0 = attributemodifier2.func_111164_d();
                    double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
                }
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

