/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.endertendril.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.silentchaos512.endertendril.block.FloweringEnderTendrilBlock;
import net.silentchaos512.endertendril.setup.LootInjector;
import net.silentchaos512.endertendril.setup.ModBlocks;
import net.silentchaos512.endertendril.setup.ModItems;
import net.silentchaos512.endertendril.setup.Registration;

public class ModLootTables
extends LootTableProvider {
    public ModLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new Chests(), (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((name, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)name, (LootTable)lootTable));
    }

    private static final class Chests
    extends ChestLootTables {
        private Chests() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(LootInjector.Tables.CHESTS_ABANDONED_MINESHAFT, Chests.addSeeds(7));
            consumer.accept(LootInjector.Tables.CHESTS_BURIED_TREASURE, Chests.addSeeds(4));
            consumer.accept(LootInjector.Tables.CHESTS_END_CITY_TREASURE, Chests.addSeeds(2));
            consumer.accept(LootInjector.Tables.CHESTS_SHIPWRECK_TREASURE, Chests.addSeeds(5));
            consumer.accept(LootInjector.Tables.CHESTS_STRONGHOLD_CORRIDOR, Chests.addSeeds(2));
            consumer.accept(LootInjector.Tables.CHESTS_STRONGHOLD_CROSSING, Chests.addSeeds(3));
        }

        private static LootTable.Builder addSeeds(int emptyWeight) {
            return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).bonusRolls(0.0f, 1.0f).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(emptyWeight)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ENDER_TENDRIL_SEED.get())).func_216086_a(1)));
        }
    }

    private static final class Blocks
    extends BlockLootTables {
        private Blocks() {
        }

        protected void addTables() {
            this.func_218493_a((Block)ModBlocks.ENDER_TENDRIL.get(), (IItemProvider)ModItems.ENDER_TENDRIL_SEED.get());
            this.func_218507_a((Block)ModBlocks.ENDER_TENDRIL_PLANT.get(), LootTable.func_216119_b());
            BlockStateProperty.Builder floweringTendrilMature = BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.FLOWERING_ENDER_TENDRIL.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)FloweringEnderTendrilBlock.AGE, ((FloweringEnderTendrilBlock)ModBlocks.FLOWERING_ENDER_TENDRIL.get()).getMaxAge()));
            this.func_218507_a((Block)ModBlocks.FLOWERING_ENDER_TENDRIL.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_((ILootCondition.IBuilder)floweringTendrilMature).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.TENDRIL_PEARL.get())))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_((ILootCondition.IBuilder)floweringTendrilMature).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.ENDER_TENDRIL_SEED.get())).func_216086_a(1).func_212840_b_(RandomChance.func_216004_a((float)0.1f)))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }
    }
}

