/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.endertendril.setup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.endertendril.EnderTendrilMod;

@Mod.EventBusSubscriber(modid="endertendril")
public final class LootInjector {
    private LootInjector() {
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        Tables.get(event.getName()).ifPresent(injectorName -> {
            EnderTendrilMod.LOGGER.info("Injecting loot table '{}' into '{}'", injectorName, (Object)event.getName());
            event.getTable().addPool(LootPool.func_216096_a().name("endertendril_injected").func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)injectorName)).func_216044_b());
        });
    }

    public static final class Tables {
        private static final Map<ResourceLocation, ResourceLocation> MAP = new HashMap<ResourceLocation, ResourceLocation>();
        public static final ResourceLocation CHESTS_ABANDONED_MINESHAFT = Tables.inject(LootTables.field_186424_f);
        public static final ResourceLocation CHESTS_BURIED_TREASURE = Tables.inject(LootTables.field_204312_r);
        public static final ResourceLocation CHESTS_END_CITY_TREASURE = Tables.inject(LootTables.field_186421_c);
        public static final ResourceLocation CHESTS_SHIPWRECK_TREASURE = Tables.inject(LootTables.field_204773_u);
        public static final ResourceLocation CHESTS_STRONGHOLD_CORRIDOR = Tables.inject(LootTables.field_186428_j);
        public static final ResourceLocation CHESTS_STRONGHOLD_CROSSING = Tables.inject(LootTables.field_186427_i);

        private Tables() {
        }

        public static Collection<ResourceLocation> getValues() {
            return MAP.values();
        }

        public static Optional<ResourceLocation> get(ResourceLocation lootTable) {
            return Optional.ofNullable(MAP.get(lootTable));
        }

        private static ResourceLocation inject(ResourceLocation lootTable) {
            ResourceLocation ret = EnderTendrilMod.getId("inject/" + lootTable.func_110623_a());
            MAP.put(lootTable, ret);
            return ret;
        }
    }
}

