/*
 * Decompiled with CFR 0.152.
 */
package bloop.excavation.event;

import bloop.excavation.Excavation;
import bloop.excavation.config.Tags;
import bloop.excavation.veinmine.MiningAlgorithm;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="excavation")
public class ServerEvent {
    private static boolean alreadyBreaking = false;
    public static Set<UUID> playersWithButtonDown = new HashSet<UUID>();

    @SubscribeEvent
    public static void veinMine(BlockEvent.BreakEvent e) {
        boolean blockIsAllowed;
        boolean correctTool;
        PlayerEntity player = e.getPlayer();
        World world = e.getPlayer().field_70170_p;
        BlockPos blockPos = e.getPos();
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (player.func_71024_bL().func_75116_a() == 0) {
            return;
        }
        if (alreadyBreaking) {
            return;
        }
        if (player instanceof FakePlayer) {
            return;
        }
        if (Excavation.config.crouchEnable.get().booleanValue()) {
            if (!player.func_213453_ef()) {
                ServerEvent.removePlayer(player.func_110124_au());
                return;
            }
            ServerEvent.addPlayer(player.func_110124_au());
        }
        if (!(correctTool = ForgeHooks.canHarvestBlock((BlockState)world.func_180495_p(blockPos), (PlayerEntity)player, (IBlockReader)world, (BlockPos)blockPos)) && Excavation.config.mineWithTool.get().booleanValue() && !player.func_184812_l_()) {
            return;
        }
        if (!world.func_180495_p(blockPos).func_177230_c().canHarvestBlock(world.func_180495_p(blockPos), (IBlockReader)world, blockPos, player) && !player.func_184812_l_() || !world.func_195588_v(blockPos)) {
            return;
        }
        boolean bl = blockIsAllowed = !Tags.blacklist.func_230235_a_((Object)block) && (Tags.whitelist.func_230236_b_().isEmpty() || Tags.whitelist.func_230235_a_((Object)block));
        if (!blockIsAllowed) {
            return;
        }
        if (!playersWithButtonDown.contains(player.func_110124_au())) {
            return;
        }
        alreadyBreaking = true;
        e.setCanceled(true);
        MiningAlgorithm miningAlgorithm = new MiningAlgorithm(blockPos, world, player);
        miningAlgorithm.findBlocks();
        miningAlgorithm.mine();
        ServerEvent.setAlreadyBreaking(false);
    }

    public static void setAlreadyBreaking(boolean breaking) {
        alreadyBreaking = breaking;
    }

    public static void addPlayer(UUID uuid) {
        playersWithButtonDown.add(uuid);
    }

    public static void removePlayer(UUID uuid) {
        playersWithButtonDown.removeIf(u -> u.equals(uuid));
    }
}

