/*
 * Decompiled with CFR 0.152.
 */
package bloop.excavation.veinmine;

import bloop.excavation.Excavation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class MiningAlgorithm {
    private final List<BlockPos> blocksToBreak = new ArrayList<BlockPos>();
    private final BlockPos startingBlock;
    private final List<BlockPos> alreadyChecked = new ArrayList<BlockPos>();
    private final World world;
    private final ServerPlayerEntity player;
    private int totalXp = 0;
    private final BlockPos playerPos;
    private final List<ItemStack> itemsToDrop = new ArrayList<ItemStack>();

    public MiningAlgorithm(BlockPos start, World worldIn, PlayerEntity playerIn) {
        this.world = worldIn;
        this.player = (ServerPlayerEntity)playerIn;
        this.playerPos = new BlockPos(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
        this.startingBlock = start;
        this.blocksToBreak.add(start);
        this.alreadyChecked.add(start);
        this.itemsToDrop.add(ItemStack.field_190927_a);
    }

    public void findBlocks() {
        BlockPos.Mutable checking = new BlockPos.Mutable();
        int[] range = new int[]{0, -1, 1};
        ArrayList<BlockPos> dummyBlocks = new ArrayList<BlockPos>();
        while (!this.blocksToBreak.equals(dummyBlocks)) {
            dummyBlocks.clear();
            dummyBlocks.addAll(this.blocksToBreak);
            for (BlockPos p2 : dummyBlocks) {
                for (int x : range) {
                    for (int y : range) {
                        for (int z : range) {
                            checking.func_189533_g((Vector3i)p2).func_196234_d(x, y, z);
                            if (this.alreadyChecked.contains(checking)) continue;
                            this.blocksToBreak.add(checking.func_185334_h());
                            this.alreadyChecked.add(checking.func_185334_h());
                        }
                    }
                }
            }
            dummyBlocks.clear();
            dummyBlocks.addAll(this.blocksToBreak);
            this.blocksToBreak.removeIf(p -> !this.world.func_180495_p(this.startingBlock).func_177230_c().equals(this.world.func_180495_p(p).func_177230_c()));
            if (this.blocksToBreak.size() < Excavation.config.maxBlocks.get()) continue;
            this.blocksToBreak.subList(Excavation.config.maxBlocks.get(), this.blocksToBreak.size()).clear();
            break;
        }
        this.blocksToBreak.forEach(p -> System.out.println("Block type first: " + this.world.func_180495_p(p).func_177230_c()));
    }

    public boolean tryBreak(BlockPos p) {
        BlockState state = this.world.func_180495_p(p);
        Block block = state.func_177230_c();
        if (block.equals(Blocks.field_150350_a)) {
            this.world.func_180501_a(p, Blocks.field_196567_aW.func_176223_P(), 0);
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)this.player, (IBlockReader)this.world, (BlockPos)p) && !this.player.func_184812_l_()) {
            return false;
        }
        if (!this.world.func_201670_d()) {
            int xp = ForgeHooks.onBlockBreakEvent((World)this.world, (GameType)this.player.field_71134_c.func_73081_b(), (ServerPlayerEntity)this.player, (BlockPos)p);
            if (xp == -1) {
                return false;
            }
            if (!block.removedByPlayer(state, this.world, p, (PlayerEntity)this.player, !this.player.func_184812_l_(), state.func_204520_s())) {
                return false;
            }
            if (!this.player.func_184812_l_()) {
                if (!Excavation.config.vacuumBlocks.get().booleanValue()) {
                    block.func_180657_a(this.world, (PlayerEntity)this.player, p, state, this.world.func_175625_s(p), this.player.func_184614_ca());
                } else {
                    this.addToDropsList(p, block, state);
                    this.player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)block));
                    this.player.func_71020_j((float)((double)0.005f * Excavation.config.exhaustionMultiplier.get()));
                }
                if (xp > 0) {
                    this.totalXp += xp;
                }
            }
        } else {
            if (!block.removedByPlayer(state, this.world, p, (PlayerEntity)this.player, !this.player.func_184812_l_(), state.func_204520_s())) {
                return false;
            }
            block.func_180657_a(this.world, (PlayerEntity)this.player, p, state, this.world.func_175625_s(p), this.player.func_184614_ca());
        }
        return true;
    }

    private void addToDropsList(BlockPos p, Block block, BlockState state) {
        List drops = Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)this.world), (BlockPos)p, (TileEntity)this.world.func_175625_s(p), (Entity)this.player, (ItemStack)this.player.func_184614_ca());
        ArrayList dummyItemsToDrop = new ArrayList();
        this.itemsToDrop.forEach(i -> dummyItemsToDrop.add(i.func_77973_b()));
        for (ItemStack drop : drops) {
            if (dummyItemsToDrop.contains(drop.func_77973_b())) {
                int oldCount = this.itemsToDrop.get(dummyItemsToDrop.indexOf(drop.func_77973_b())).func_190916_E();
                int extraCount = drop.func_190916_E();
                this.itemsToDrop.get(dummyItemsToDrop.indexOf(drop.func_77973_b())).func_190920_e(oldCount + extraCount);
                continue;
            }
            this.itemsToDrop.add(drop);
        }
        this.itemsToDrop.remove(ItemStack.field_190927_a);
    }

    public void dropItems() {
        if (!this.world.func_201670_d() && this.world.func_82736_K().func_223586_b(GameRules.field_223603_f) && !this.world.restoringBlockSnapshots) {
            for (ItemStack item : this.itemsToDrop) {
                if (this.player.field_71071_by.func_70441_a(item)) continue;
                ItemEntity itemEntity = new ItemEntity(this.world, (double)this.playerPos.func_177958_n() + 0.5, (double)this.playerPos.func_177956_o() + 0.5, (double)this.playerPos.func_177952_p() + 0.5, item);
                itemEntity.func_174869_p();
                this.world.func_217376_c((Entity)itemEntity);
            }
        }
        this.itemsToDrop.clear();
    }

    public void mine() {
        this.totalXp = 0;
        for (BlockPos p : this.blocksToBreak) {
            ItemStack mh;
            System.out.println("Block type second: " + this.world.func_180495_p(p).func_177230_c());
            if (!this.tryBreak(p) || this.world.func_201670_d() || !(mh = this.player.func_184614_ca()).func_77984_f() || this.player.func_184812_l_()) continue;
            if (mh.func_77952_i() < mh.func_77958_k()) {
                mh.func_96631_a(1, this.player.func_70681_au(), this.player);
                continue;
            }
            mh.func_222118_a(1, (LivingEntity)this.player, player -> player.func_213361_c(EquipmentSlotType.MAINHAND));
            break;
        }
        if (!this.world.func_201670_d()) {
            this.dropItems();
        }
        this.world.func_180495_p(this.startingBlock).func_177230_c().func_180637_b((ServerWorld)this.world, this.playerPos, this.totalXp);
    }
}

