/*
 * Decompiled with CFR 0.152.
 */
package net.bloop.excavation.event;

import net.bloop.excavation.veinmine.MiningAlgorithm;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="excavation")
public class ServerEvent {
    private static boolean alreadyBreaking = false;
    private static boolean excavationPressed = false;

    @SubscribeEvent
    public static void veinMine(BlockEvent.BreakEvent e) {
        BlockPos blockPos;
        if (alreadyBreaking) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        World world = e.getWorld().func_201672_e();
        if (!world.func_180495_p(blockPos = e.getPos()).func_177230_c().canHarvestBlock(world.func_180495_p(blockPos), (IBlockReader)world, blockPos, player) || !world.func_175667_e(blockPos)) {
            return;
        }
        if (!excavationPressed) {
            return;
        }
        alreadyBreaking = true;
        e.setCanceled(true);
        MiningAlgorithm miningAlgorithm = new MiningAlgorithm(blockPos, world, player);
        miningAlgorithm.findBlocks();
        miningAlgorithm.mine();
        miningAlgorithm.tryBreak(blockPos);
        miningAlgorithm.dropItems();
        ServerEvent.setAlreadyBreaking(false);
    }

    public static void setAlreadyBreaking(boolean breaking) {
        alreadyBreaking = breaking;
    }

    public static void setExcavationPressed(boolean pressed) {
        excavationPressed = pressed;
    }
}

