/*
 * Decompiled with CFR 0.152.
 */
package net.bloop.excavation.veinmine;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.bloop.excavation.Excavation;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class MiningAlgorithm {
    private List<BlockPos> blocksToBreak = new ArrayList<BlockPos>();
    private BlockPos startingBlock;
    private List<BlockPos> alreadyChecked = new ArrayList<BlockPos>();
    private World world;
    private ServerPlayerEntity player;
    private int totalXp = 0;
    private BlockPos playerPos;
    private List<ItemStack> itemsToDrop = new ArrayList<ItemStack>();

    public MiningAlgorithm(BlockPos start, World worldIn, PlayerEntity playerIn) {
        this.world = worldIn;
        this.player = (ServerPlayerEntity)playerIn;
        this.playerPos = new BlockPos(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
        this.startingBlock = start;
        this.blocksToBreak.add(start);
        this.itemsToDrop.add(ItemStack.field_190927_a);
    }

    public void findBlocks() {
        BlockPos.Mutable checking = new BlockPos.Mutable();
        int[] range = new int[]{0, -1, 1};
        ArrayList<BlockPos> dummyBlocks = new ArrayList<BlockPos>();
        while (!this.blocksToBreak.equals(dummyBlocks)) {
            dummyBlocks.clear();
            dummyBlocks.addAll(this.blocksToBreak);
            for (BlockPos p : dummyBlocks) {
                for (int x : range) {
                    for (int y : range) {
                        for (int z : range) {
                            checking.func_189533_g((Vector3i)p).func_196234_d(x, y, z);
                            if (this.alreadyChecked.contains(checking.func_185334_h())) continue;
                            this.blocksToBreak.add(checking.func_185334_h());
                            this.alreadyChecked.add(checking.func_185334_h());
                        }
                    }
                }
            }
            this.cleanOutTrash();
            if (this.blocksToBreak.size() < Excavation.config.maxBlocks.get()) continue;
        }
        this.cleanOutTrash();
    }

    public boolean tryBreak(BlockPos p) {
        BlockState state = this.world.func_180495_p(p);
        Block block = state.func_177230_c();
        if (this.world.func_175623_d(p)) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)this.player, (IBlockReader)this.world, (BlockPos)p)) {
            return false;
        }
        if (!this.world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)this.world, (GameType)this.player.field_71134_c.func_73081_b(), (ServerPlayerEntity)this.player, (BlockPos)p);
            if (xp == -1) {
                return false;
            }
            if (!block.removedByPlayer(state, this.world, p, (PlayerEntity)this.player, !this.player.func_184812_l_(), state.func_204520_s())) {
                return false;
            }
            block.func_176206_d((IWorld)this.world, p, state);
            if (!this.player.func_184812_l_()) {
                if (Excavation.config.vacuumBlocks.get() == 0) {
                    block.func_180657_a(this.world, (PlayerEntity)this.player, p, state, this.world.func_175625_s(p), this.player.func_184614_ca());
                } else {
                    this.addToDropsList(p, block, state);
                    this.player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)block));
                    this.player.func_71020_j((float)((double)0.005f * Excavation.config.exhaustionMultiplier.get()));
                }
                if (xp > 0) {
                    this.totalXp += xp;
                }
            }
        } else {
            if (!block.removedByPlayer(state, this.world, p, (PlayerEntity)this.player, !this.player.func_184812_l_(), state.func_204520_s())) {
                return false;
            }
            block.func_176206_d((IWorld)this.world, p, state);
        }
        return true;
    }

    private void addToDropsList(BlockPos p, Block block, BlockState state) {
        List drops = Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)this.world), (BlockPos)p, (TileEntity)this.world.func_175625_s(p), (Entity)this.player, (ItemStack)this.player.func_184614_ca());
        ArrayList dummyItemsToDrop = new ArrayList();
        this.itemsToDrop.forEach(i -> dummyItemsToDrop.add(i.func_77973_b()));
        for (ItemStack drop : drops) {
            if (dummyItemsToDrop.contains(drop.func_77973_b())) {
                int oldCount = this.itemsToDrop.get(dummyItemsToDrop.indexOf(drop.func_77973_b())).func_190916_E();
                int extraCount = drop.func_190916_E();
                this.itemsToDrop.get(dummyItemsToDrop.indexOf(drop.func_77973_b())).func_190920_e(oldCount + extraCount);
                continue;
            }
            this.itemsToDrop.add(drop);
        }
        this.itemsToDrop.remove(ItemStack.field_190927_a);
    }

    public void dropItems() {
        if (!this.world.field_72995_K && this.world.func_82736_K().func_223586_b(GameRules.field_223603_f) && !this.world.restoringBlockSnapshots) {
            for (ItemStack item : this.itemsToDrop) {
                ItemEntity itemEntity = new ItemEntity(this.world, (double)this.playerPos.func_177958_n() + 0.5, (double)this.playerPos.func_177956_o() + 0.5, (double)this.playerPos.func_177952_p() + 0.5, item);
                itemEntity.func_174869_p();
                this.world.func_217376_c((Entity)itemEntity);
            }
        }
        this.itemsToDrop.clear();
    }

    private void cleanOutTrash() {
        this.blocksToBreak.removeIf(p -> this.world.func_180495_p(this.startingBlock).func_177230_c() != this.world.func_180495_p(p).func_177230_c());
    }

    public void mine() {
        this.totalXp = 0;
        for (BlockPos p : this.blocksToBreak) {
            if (p.equals((Object)this.startingBlock) || !this.tryBreak(p) || this.world.field_72995_K) continue;
            this.player.func_184614_ca().func_96631_a(1, new Random(), this.player);
        }
        if (!this.world.field_72995_K) {
            this.dropItems();
        }
        this.world.func_180495_p(this.startingBlock).func_177230_c().func_180637_b(this.world, this.playerPos, this.totalXp);
    }
}

