/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;
import net.pavocado.exoticbirds.capabilities.IBirdStorage;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.entity.EntityOstrich;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsPacketHandler;
import net.pavocado.exoticbirds.network.PacketSyncCapabilities;

@Mod.EventBusSubscriber(modid="exoticbirds", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventSubscriber {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientTick(TickEvent.PlayerTickEvent event) throws Exception {
        if (event.side == LogicalSide.CLIENT && event.phase.equals((Object)TickEvent.Phase.END) && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && event.player.func_184187_bx() instanceof EntityOstrich) {
            EntityOstrich entityOstrich = (EntityOstrich)event.player.func_184187_bx();
            entityOstrich.func_110206_u(90);
        }
    }

    @SubscribeEvent
    public static void onEggImpact(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity entity = event.getThrowable();
        if (entity instanceof EggEntity && !entity.field_70170_p.field_72995_K && ExoticBirdsConfig.createVanillaEggshell && entity.field_70170_p.field_73012_v.nextInt(3) == 0) {
            entity.func_199701_a_(new ItemStack((IItemProvider)ExoticBirdsItems.EGGSHELL.get(), entity.field_70170_p.field_73012_v.nextInt(2) + 1));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("exoticbirds", "bird_tracking"), (ICapabilityProvider)new BirdTrackingProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        IBirdStorage birdStorage = (IBirdStorage)event.getPlayer().getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY, null).orElseThrow(NullPointerException::new);
        ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSyncCapabilities(birdStorage.getAll()));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        IBirdStorage birdStorage = (IBirdStorage)event.getPlayer().getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY, null).orElseThrow(NullPointerException::new);
        ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSyncCapabilities(birdStorage.getAll()));
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        IBirdStorage birdStorage = (IBirdStorage)event.getPlayer().getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY, null).orElseThrow(NullPointerException::new);
        ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSyncCapabilities(birdStorage.getAll()));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity player = event.getPlayer();
        if (event.isWasDeath() && player != null && BirdTrackingProvider.BIRD_TRACKING_CAPABILITY != null) {
            IBirdStorage newStorage = (IBirdStorage)player.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY, null).orElseThrow(NullPointerException::new);
            IBirdStorage oldStorage = (IBirdStorage)event.getOriginal().getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY, null).orElseThrow(NullPointerException::new);
            newStorage.setAll(oldStorage.getAll());
        }
    }

    @SubscribeEvent
    public static void checkSpawns(LivingSpawnEvent.CheckSpawn event) {
        ResourceLocation currentDimension;
        if (event.getEntity() instanceof EntityAbstractBird && (currentDimension = DimensionType.func_212678_a((DimensionType)event.getEntity().field_71093_bK)) != null) {
            for (String dimensionType : ExoticBirdsConfig.blacklistedSpawningDimensions) {
                if (!dimensionType.equals(currentDimension.toString())) continue;
                event.setResult(Event.Result.DENY);
            }
            for (String dimensionType : ((EntityAbstractBird)event.getEntity()).getBlacklistedDimensions()) {
                if (!dimensionType.equals(currentDimension.toString())) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

